# 機能設計書 F005-自動車保険照会

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける自動車保険照会機能の詳細設計を定義する。顧客番号とポリシー番号を指定して自動車保険の詳細情報をDb2データベースから取得する機能である。

### 本機能の処理概要

本機能は、既存の自動車保険ポリシーの詳細情報を照会・表示するための基幹機能を提供する。

**業務上の目的・背景**：保険業務において、契約内容の確認、保険金請求の処理、契約更新の際の情報確認など、様々な場面で保険ポリシー情報の参照が必要となる。本機能は、顧客番号とポリシー番号をキーとして自動車保険の詳細（車両情報、保険料、契約期間等）を迅速に取得し、業務効率の向上を支援する。

**機能の利用シーン**：顧客からの問い合わせ対応時、保険金請求処理時、契約更新処理時など、自動車保険詳細画面でPF5キーを押下して照会を実行する。

**主要な処理内容**：
1. リクエストID('01IMOT')とCOMMAREAの検証
2. LGIPOL01プログラムを呼び出しビジネスロジックを実行
3. LGIPDB01プログラムでPOLICYテーブルとMOTORテーブルをJOINしてSELECT
4. 取得した情報をCOMMAREAに設定
5. 処理結果を呼び出し元に返却

**関連システム・外部連携**：Db2データベースとの連携のみ。

**権限による制御**：本機能は保険ポリシー閲覧権限を持つオペレーターが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 自動車保険詳細画面 | 主画面 | PF5キー押下時にLGIPOL01プログラムをCICS LINKで呼び出し、自動車保険の詳細情報を取得・表示する |

## 機能種別

CRUD操作（Read）/ データ参照処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01IMOT'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 存在するポリシー番号 |

### 入力データソース

- 画面入力（自動車保険詳細画面 SSMAPM2）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-ISSUE-DATE | X(10) | 発効日 |
| CA-EXPIRY-DATE | X(10) | 満期日 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ |
| CA-BROKERID | 9(10) | ブローカーID |
| CA-BROKERSREF | X(10) | ブローカー参照番号 |
| CA-PAYMENT | 9(6) | 支払額 |
| CA-M-MAKE | X(15) | メーカー |
| CA-M-MODEL | X(15) | モデル |
| CA-M-VALUE | 9(6) | 車両価値 |
| CA-M-REGNUMBER | X(7) | 登録番号 |
| CA-M-COLOUR | X(8) | 色 |
| CA-M-CC | 9(4) | 排気量(cc) |
| CA-M-MANUFACTURED | X(10) | 製造年 |
| CA-M-PREMIUM | 9(6) | 保険料 |
| CA-M-ACCIDENTS | 9(6) | 事故件数 |

### 出力先

- CICS通信領域（COMMAREA）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. LGIPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
3. リクエストIDの判定
   └─ '01IMOT'の場合、GET-MOTOR-DB2-INFOを実行
4. POLICY/MOTORテーブルのJOIN SELECT（LGIPDB01）
   └─ 顧客番号とポリシー番号をキーに保険情報を取得
5. COMMAREAの長さ検証
   └─ 返却データが格納可能か確認
6. 結果の返却
   └─ 保険詳細情報とリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D[LGIPDB01呼出]
    D --> E{REQUEST-ID判定}
    E -->|'01IMOT'| F[GET-MOTOR-DB2-INFO]
    E -->|Other| G[RC=99で終了]
    F --> H[POLICY/MOTOR JOIN SELECT]
    H --> I{SQLCODE判定}
    I -->|0| J{COMMAREA長さ確認}
    I -->|100| K[RC=01 データなし]
    I -->|Other| L[RC=90 エラー]
    J -->|NG| M[RC=98で終了]
    J -->|OK| N[データをCOMMAREAに設定]
    N --> O[データ終端マーク'FINAL'設定]
    O --> P[RC=00で正常終了]
    G --> Q[終了]
    K --> Q
    L --> Q
    M --> Q
    P --> Q
    C --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客ポリシー紐付け | 指定された顧客番号とポリシー番号の組み合わせが一致するレコードのみ返却 | 常時 |
| BR-002 | データ終端マーク | 返却データの末尾に'FINAL'マークを付与 | 正常終了時 |
| BR-003 | NULL値処理 | BROKERID/BROKERSREF/PAYMENTはNULL許容。インジケータ変数で判定 | 照会時 |

### 計算ロジック

- 計算ロジックなし（純粋な参照処理）
- 整数型から表示用数値型への変換処理あり

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 保険情報取得 | POLICY, MOTOR | SELECT(JOIN) | 自動車保険詳細情報の取得 |

### テーブル別操作詳細

#### POLICY, MOTOR (JOIN)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ISSUEDATE | FROM POLICY | |
| SELECT | EXPIRYDATE | FROM POLICY | |
| SELECT | LASTCHANGED | FROM POLICY | |
| SELECT | BROKERID | FROM POLICY | NULL許容（インジケータ使用） |
| SELECT | BROKERSREFERENCE | FROM POLICY | NULL許容 |
| SELECT | PAYMENT | FROM POLICY | NULL許容 |
| SELECT | MAKE | FROM MOTOR | メーカー |
| SELECT | MODEL | FROM MOTOR | モデル |
| SELECT | VALUE | FROM MOTOR | 車両価値 |
| SELECT | REGNUMBER | FROM MOTOR | 登録番号 |
| SELECT | COLOUR | FROM MOTOR | 色 |
| SELECT | CC | FROM MOTOR | 排気量 |
| SELECT | YEAROFMANUFACTURE | FROM MOTOR | 製造年 |
| SELECT | PREMIUM | FROM MOTOR | 保険料 |
| SELECT | ACCIDENTS | FROM MOTOR | 事故件数 |

**WHERE条件**:
```sql
WHERE POLICY.POLICYNUMBER = MOTOR.POLICYNUMBER
  AND POLICY.CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT
  AND POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT
```

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 01 | 業務エラー | データが存在しない（SQLCODE=100） | 正しい顧客番号/ポリシー番号を指定 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |

### リトライ仕様

- 参照処理のためリトライ不要
- エラー時は適切なリターンコードで終了

## トランザクション仕様

- トランザクションID: SSC1
- 参照のみの処理のため、コミット/ロールバックの影響なし

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 主キーによる単一行SELECT のため高速

## セキュリティ考慮事項

- 保険ポリシー情報の閲覧には適切な権限管理が必要
- 顧客番号とポリシー番号の組み合わせでアクセス制御
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録

## 備考

- LGIPOL01: ビジネスロジック層（LGIPDB01を呼び出し）
- LGIPDB01: Db2データアクセス層（POLICY/MOTORテーブルSELECT）
- 自動車保険完全データ長: WS-FULL-MOTOR-LEN = 137バイト
- ヘッダー・トレーラー長: WS-CA-HEADERTRAILER-LEN = 33バイト

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造の理解。入力は`CA-REQUEST-ID='01IMOT'`、`CA-CUSTOMER-NUM`、`CA-POLICY-NUM`。出力は`CA-POLICY-COMMON`と`CA-MOTOR`構造体 |
| 1-2 | lgpolicy.cpy | `base/src/lgpolicy.cpy` | `WS-FULL-MOTOR-LEN`（137バイト）と`WS-CA-HEADERTRAILER-LEN`（33バイト）の定義。`DB2-MOTOR`構造体がDB2からの取得データ格納領域 |

**読解のコツ**: 照会処理では、DB2から取得したデータを`DB2-*`変数に格納後、`CA-*`（COMMAREA）にコピーする2段階処理を理解することが重要。

#### Step 2: 画面レイアウトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | `SSMAPM2`マップが自動車保険詳細画面。PF5キーで照会処理を実行 |

**読解のコツ**: 自動車保険関連の画面は`SSMAPM`プレフィックス（Motor用）で識別。

#### Step 3: エントリーポイント（ビジネスロジック層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgipol01.cbl | `base/src/lgipol01.cbl` | **MAINLINE SECTION**（70-99行目）: 非常にシンプルなラッパー。COMMAREA検証後、即座にLGIPDB01を呼び出し |

**主要処理フロー**:
1. **79-83行目**: COMMAREAなしの場合はABEND('LGCA')
2. **86行目**: リターンコードを'00'で初期化
3. **91-94行目**: CICS LINKでLGIPDB01を呼び出し

**読解のコツ**: LGIPOL01は最小限のラッパー。リクエストID判定を含むすべてのロジックはLGIPDB01で実行される。

#### Step 4: データアクセス層（DB2 SELECT処理）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | **最も重要なファイル**。POLICY/MOTORテーブルのJOIN SELECTと結果のCOMMAREA設定 |

**主要処理フロー**:
1. **251-255行目**: COMMAREAなしの場合はABEND('LGCA')
2. **263-264行目**: 顧客番号・ポリシー番号をDB2整数型に変換
3. **275行目**: リクエストIDを大文字変換
4. **277-310行目**: リクエストID別の処理分岐
   - `'01IMOT'`（287-289行目）: GET-MOTOR-DB2-INFOを実行

**注目すべき詳細 - GET-MOTOR-DB2-INFO**（529-621行目）:
- **532-570行目**: POLICY/MOTORテーブルのJOIN SELECT
  - 15項目を取得（発効日、満期日、車両情報等）
  - NULL許容カラム（BROKERID等）はインジケータ変数使用
- **572-606行目**: SQLCODE=0の場合
  - **576-577行目**: 必要COMMAREA長を計算
  - **581-583行目**: 長さ不足時はRC='98'
  - **588-602行目**: 整数型→表示型変換とCOMMAREAへのデータ移動
  - **606行目**: データ終端マーク'FINAL'を設定
- **610-618行目**: エラー処理
  - `SQLCODE=100`: データなし、RC='01'
  - その他: RC='90'

**読解のコツ**: インジケータ変数（IND-BROKERID等）は-1でNULL判定。NULLでない場合のみデータをコピーする。

#### Step 5: 補助機能（エラーログ）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | エラーメッセージをTDQ/TSQに書き込む共通ログ機能 |

### プログラム呼び出し階層図

```
画面操作（PF5キー押下 + 顧客番号・ポリシー番号指定）
    │
    ▼
LGIPOL01 (lgipol01.cbl)  ─────────────────┐
    │ CICS LINK                           │ エラー時
    ▼                                     ▼
LGIPDB01 (lgipdb01.cbl)              LGSTSQ (lgstsq.cbl)
    │                                     │
    └─ SQL SELECT (POLICY JOIN MOTOR)     └─ TDQ/TSQ書込
           │
           └─▶ 保険詳細をCOMMAREAに設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

COMMAREA ─────────▶ LGIPOL01 ─────▶ LGIPDB01
 │                                      │
 ├─ CA-REQUEST-ID                       │
 │  ('01IMOT')                          │
 ├─ CA-CUSTOMER-NUM ──────────────────▶ SELECT条件
 └─ CA-POLICY-NUM ────────────────────▶ SELECT条件
                                        │
                                        ▼
                              POLICY + MOTOR (Db2)
                              ┌──────────────┐
                              │  JOIN SELECT │
                              └──────────────┘
                                        │
                                        ▼
                                   COMMAREA
                                        │
                                        ├─ CA-RETURN-CODE
                                        ├─ CA-ISSUE-DATE
                                        ├─ CA-EXPIRY-DATE
                                        ├─ CA-LASTCHANGED
                                        ├─ CA-BROKERID
                                        ├─ CA-BROKERSREF
                                        ├─ CA-PAYMENT
                                        ├─ CA-M-MAKE
                                        ├─ CA-M-MODEL
                                        ├─ CA-M-VALUE
                                        ├─ CA-M-REGNUMBER
                                        ├─ CA-M-COLOUR
                                        ├─ CA-M-CC
                                        ├─ CA-M-MANUFACTURED
                                        ├─ CA-M-PREMIUM
                                        └─ CA-M-ACCIDENTS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipol01.cbl | `base/src/lgipol01.cbl` | COBOLプログラム | ビジネスロジック層（エントリーポイント） |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | COBOLプログラム | Db2データアクセス層（POLICY/MOTOR SELECT） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA構造定義 |
| lgpolicy.cpy | `base/src/lgpolicy.cpy` | コピーブック | ポリシー/自動車保険データ長定義、DB2-MOTOR構造体 |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面定義（SSMAPM2が自動車保険詳細） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | COBOLプログラム | エラーログ共通機能 |
