# 機能設計書 F006-自動車保険更新

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける自動車保険更新機能の詳細設計を定義する。既存の自動車保険ポリシーの情報をDb2データベースおよびVSAMファイルで更新する機能である。

### 本機能の処理概要

本機能は、既に登録されている自動車保険ポリシーの内容を変更・更新するための基幹機能を提供する。

**業務上の目的・背景**：自動車保険の契約期間中に、車両の変更、保険料の見直し、契約条件の変更など、様々な更新が発生する。本機能は、これらの変更を迅速かつ正確にシステムに反映し、契約内容の正確性を維持する。楽観的ロック（タイムスタンプ比較）により、同時更新の競合を防止する。

**機能の利用シーン**：顧客から契約内容の変更申し出があった際、オペレーターが自動車保険詳細画面でPF4キーを押下し、変更内容を入力して更新を実行する。更新前に必ず照会（F005）で現在の情報を取得してから更新を行う。

**主要な処理内容**：
1. リクエストID('01UMOT')とCOMMAREAの検証
2. LGUPOL01プログラムを呼び出しビジネスロジックを実行
3. LGUPDB01プログラムでPOLICYテーブルをSELECT FOR UPDATEでロック取得
4. タイムスタンプ比較による楽観的ロック検証
5. MOTORテーブルとPOLICYテーブルをUPDATE
6. LGUPVS01プログラムでVSAMファイル（KSDSPOLY）を更新
7. 処理結果と新タイムスタンプを呼び出し元に返却

**関連システム・外部連携**：Db2データベース、VSAMファイルとの連携。

**権限による制御**：本機能は保険ポリシー更新権限を持つオペレーターのみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 自動車保険詳細画面 | 主画面 | PF4キー押下時にLGUPOL01プログラムをCICS LINKで呼び出し、自動車保険情報を更新する |

## 機能種別

CRUD操作（Update）/ データ更新処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01UMOT'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 存在するポリシー番号 |
| CA-LASTCHANGED | X(26) | Yes | 最終更新タイムスタンプ | 照会時取得値と一致 |
| CA-ISSUE-DATE | X(10) | Yes | 発効日 | 日付形式 |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日 | 日付形式 |
| CA-BROKERID | 9(10) | No | ブローカーID | - |
| CA-BROKERSREF | X(10) | No | ブローカー参照番号 | - |
| CA-M-MAKE | X(15) | Yes | メーカー | - |
| CA-M-MODEL | X(15) | Yes | モデル | - |
| CA-M-VALUE | 9(6) | Yes | 車両価値 | - |
| CA-M-REGNUMBER | X(7) | Yes | 登録番号 | - |
| CA-M-COLOUR | X(8) | No | 色 | - |
| CA-M-CC | 9(4) | No | 排気量(cc) | - |
| CA-M-MANUFACTURED | X(10) | No | 製造年 | - |
| CA-M-PREMIUM | 9(6) | Yes | 保険料 | - |
| CA-M-ACCIDENTS | 9(6) | No | 事故件数 | - |

### 入力データソース

- 画面入力（自動車保険詳細画面 SSMAPM2）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-LASTCHANGED | X(26) | 新しい最終更新タイムスタンプ |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 POLICYテーブル（更新）
- Db2 MOTORテーブル（更新）
- VSAMファイル（KSDSPOLY）（更新）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ ヘッダー28バイト + 自動車保険データ137バイトを確認
3. LGUPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
4. POLICYテーブルのOPEN CURSOR（FOR UPDATE）
   └─ SELECT FOR UPDATEで排他ロック取得
5. タイムスタンプ比較（楽観的ロック）
   └─ COMMAREAのCA-LASTCHANGEDとDb2のDB2-LASTCHANGEDを比較
6. MOTORテーブルのUPDATE
   └─ 自動車固有情報を更新
7. POLICYテーブルのUPDATE
   └─ 共通情報を更新、新タイムスタンプを設定
8. LGUPVS01プログラム呼び出し
   └─ VSAMファイルを更新
9. CURSORのCLOSE
10. 結果の返却
    └─ 新タイムスタンプとリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F[LGUPDB01呼出]
    F --> G[OPEN POLICY_CURSOR]
    G --> H{SQLCODE判定}
    H -->|-913| I[RC=90 ロック競合]
    H -->|0| J[FETCH POLICY_CURSOR]
    J --> K{FETCH成功?}
    K -->|SQLCODE=100| L[RC=01 データなし]
    K -->|Yes| M{タイムスタンプ一致?}
    M -->|No| N[RC=02 競合検出]
    M -->|Yes| O[UPDATE MOTOR]
    O --> P{SQLCODE=0?}
    P -->|No| Q[RC=90/01 エラー]
    P -->|Yes| R[UPDATE POLICY]
    R --> S[SELECT新タイムスタンプ]
    S --> T{SQLCODE=0?}
    T -->|No| U[SYNCPOINT ROLLBACK]
    T -->|Yes| V[LGUPVS01呼出]
    V --> W[VSAMファイル更新]
    W --> X[CLOSE CURSOR]
    X --> Y[RC=00で正常終了]
    E --> Z[終了]
    I --> Z
    L --> Z
    N --> Z
    Q --> Z
    U --> Z
    Y --> Z
    C --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 楽観的ロック | タイムスタンプが一致しない場合は更新を拒否（'02'エラー） | 常時 |
| BR-002 | 排他ロック | SELECT FOR UPDATEで対象行をロック | 更新時 |
| BR-003 | タイムスタンプ更新 | CURRENT TIMESTAMPで新しいタイムスタンプを自動設定 | 更新成功時 |
| BR-004 | トランザクション整合性 | 全ての更新が成功しないとロールバック | 常時 |

### 計算ロジック

- 新タイムスタンプ: CURRENT TIMESTAMP（Db2現在タイムスタンプ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ロック取得 | POLICY | SELECT FOR UPDATE | 排他ロック取得 |
| ポリシー情報更新 | POLICY | UPDATE | 保険ポリシー共通情報の更新 |
| 自動車情報更新 | MOTOR | UPDATE | 自動車保険固有情報の更新 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT FOR UPDATE | ISSUEDATE, EXPIRYDATE, LASTCHANGED, BROKERID, BROKERSREFERENCE | WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT AND POLICYNUMBER = :DB2-POLICYNUM-INT | ロック取得用 |
| UPDATE | ISSUEDATE | :CA-ISSUE-DATE | WHERE CURRENT OF POLICY_CURSOR |
| UPDATE | EXPIRYDATE | :CA-EXPIRY-DATE | 同上 |
| UPDATE | LASTCHANGED | CURRENT TIMESTAMP | 同上 |
| UPDATE | BROKERID | :DB2-BROKERID-INT | 同上 |
| UPDATE | BROKERSREFERENCE | :CA-BROKERSREF | 同上 |

#### MOTOR

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | MAKE | :CA-M-MAKE | WHERE POLICYNUMBER = :DB2-POLICYNUM-INT |
| UPDATE | MODEL | :CA-M-MODEL | 同上 |
| UPDATE | VALUE | :DB2-M-VALUE-INT | 同上 |
| UPDATE | REGNUMBER | :CA-M-REGNUMBER | 同上 |
| UPDATE | COLOUR | :CA-M-COLOUR | 同上 |
| UPDATE | CC | :DB2-M-CC-SINT | 同上 |
| UPDATE | YEAROFMANUFACTURE | :CA-M-MANUFACTURED | 同上 |
| UPDATE | PREMIUM | :DB2-M-PREMIUM-INT | 同上 |
| UPDATE | ACCIDENTS | :DB2-M-ACCIDENTS-INT | 同上 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 01 | 業務エラー | データが存在しない（SQLCODE=100） | 正しい顧客番号/ポリシー番号を指定 |
| 02 | 業務エラー | タイムスタンプ不一致（楽観的ロック競合） | 再照会して最新データで更新 |
| 90 | DB2エラー | ロック競合/その他SQLエラー | エラーログ確認、時間を置いて再実行 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |

### リトライ仕様

- タイムスタンプ不一致（'02'エラー）: 再照会後に更新を再試行
- ロック競合（SQLCODE=-913）: 時間を置いて再試行

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: SYNCPOINT ROLLBACKで明示的ロールバック（UPDATE失敗時）
- カーソル: WITH HOLDオプションでSYNCPOINT後もカーソルを保持

## パフォーマンス要件

- レスポンス時間: 1秒以内
- SELECT FOR UPDATEにより排他ロックを取得するため、長時間のトランザクションは避ける

## セキュリティ考慮事項

- 保険ポリシー更新には適切な権限管理が必要
- 楽観的ロックにより同時更新の競合を防止
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録
- 更新前の照会（F005）実行が必須

## 備考

- LGUPOL01: ビジネスロジック層（LGUPDB01を呼び出し）
- LGUPDB01: Db2データアクセス層（POLICY/MOTORテーブルUPDATE、LGUPVS01呼び出し）
- LGUPVS01: VSAMデータアクセス層（KSDSPOLYファイル更新）
- 自動車保険完全データ長: WS-FULL-MOTOR-LEN = 137バイト
- カーソル名: POLICY_CURSOR（WITH HOLD FOR UPDATE）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造。`CA-REQUEST-ID='01UMOT'`、`CA-LASTCHANGED`（楽観的ロック用タイムスタンプ）、`CA-MOTOR`（更新データ）が重要 |
| 1-2 | lgpolicy.cpy | `base/src/lgpolicy.cpy` | `WS-FULL-MOTOR-LEN`（137バイト）、`DB2-LASTCHANGED`（DB2側タイムスタンプ）の定義 |

**読解のコツ**: 楽観的ロックでは`CA-LASTCHANGED`（照会時取得）と`DB2-LASTCHANGED`（DB2現在値）を比較する。

#### Step 2: エントリーポイント（ビジネスロジック層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgupol01.cbl | `base/src/lgupol01.cbl` | **MAINLINE SECTION**（83-150行目）: リクエストID別の長さチェックとLGUPDB01呼び出し |

**主要処理フロー**:
1. **99-103行目**: COMMAREAなしの場合はABEND('LGCA')
2. **113-141行目**: リクエストID別のCOMMAREA長チェック
   - `'01UMOT'`（131-137行目）: ヘッダー28 + 自動車保険137バイトを確認
3. **143行目**: `PERFORM UPDATE-POLICY-DB2-INFO`でLGUPDB01呼び出し
4. **155-160行目**: CICS LINKでLGUPDB01を呼び出し

#### Step 3: データアクセス層（DB2 UPDATE処理）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgupdb01.cbl | `base/src/lgupdb01.cbl` | **最も重要なファイル**。楽観的ロック、MOTOR/POLICY UPDATE、VSAM呼び出し |

**カーソル定義**（128-143行目）:
- `POLICY_CURSOR`: WITH HOLD FOR UPDATE
- SELECT FOR UPDATEで排他ロック取得

**主要処理フロー - UPDATE-POLICY-DB2-INFO**（251-381行目）:
1. **254-270行目**: OPEN POLICY_CURSOR
   - SQLCODE=-913: ロック競合、RC='90'
2. **273行目**: FETCH POLICY_CURSOR
3. **278行目**: **タイムスタンプ比較**（楽観的ロック）
   - `CA-LASTCHANGED = DB2-LASTCHANGED`なら更新続行
   - 不一致: RC='02'（競合検出）
4. **296-298行目**: `'01UMOT'`の場合`PERFORM UPDATE-MOTOR-DB2-INFO`
5. **317-326行目**: UPDATE POLICYで共通情報更新（WHERE CURRENT OF CURSOR）
6. **329-334行目**: 新タイムスタンプ取得（SELECT LASTCHANGED）
7. **336-342行目**: エラー時SYNCPOINT ROLLBACK
8. **209-212行目**: CICS LINKでLGUPVS01呼び出し

**UPDATE-MOTOR-DB2-INFO**（460-495行目）:
- **463-466行目**: 数値フィールドをDB2整数型に変換
- **469-483行目**: MOTORテーブルの9項目をUPDATE

#### Step 4: VSAM処理層

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgupvs01.cbl | `base/src/lgupvs01.cbl` | KSDSPOLYファイルのREAD FOR UPDATE → REWRITE処理 |

**主要処理フロー**:
1. **102-104行目**: リクエストID、ポリシー番号、顧客番号をキーに設定
2. **127-131行目**: 自動車保険データ（MAKE, MODEL, VALUE, REGNUMBER）を移動
3. **139-153行目**: CICS READ FILE (UPDATE) でロック取得
   - 失敗時: RC='81'、ABEND('LGV3')
4. **155-166行目**: CICS REWRITE FILEで更新
   - 失敗時: RC='82'、ABEND('LGV4')

### プログラム呼び出し階層図

```
画面操作（PF4キー押下 + 更新データ入力）
    │
    ▼
LGUPOL01 (lgupol01.cbl)  ─────────────────┐
    │ CICS LINK                           │ エラー時
    ▼                                     ▼
LGUPDB01 (lgupdb01.cbl)              LGSTSQ (lgstsq.cbl)
    │                                     │
    ├─ OPEN POLICY_CURSOR                 └─ TDQ/TSQ書込
    │      └─ SELECT FOR UPDATE (POLICY)
    │
    ├─ FETCH + タイムスタンプ比較
    │      └─ 不一致: RC='02'
    │
    ├─ UPDATE MOTOR
    │
    ├─ UPDATE POLICY
    │      └─ CURRENT TIMESTAMP設定
    │
    ├─ SELECT 新タイムスタンプ
    │      └─ エラー時 SYNCPOINT ROLLBACK
    │
    ├─ CICS LINK ──▶ LGUPVS01 (lgupvs01.cbl)
    │                    │
    │                    ├─ CICS READ FILE (UPDATE)
    │                    └─ CICS REWRITE FILE
    │
    └─ CLOSE POLICY_CURSOR
```

### データフロー図

```
[入力]                    [処理]                         [出力]

COMMAREA ─────────▶ LGUPOL01 ─────▶ LGUPDB01
 │                                      │
 ├─ CA-REQUEST-ID                       ├─ OPEN CURSOR (FOR UPDATE)
 │  ('01UMOT')                          │
 ├─ CA-CUSTOMER-NUM                     ├─ FETCH → タイムスタンプ比較
 ├─ CA-POLICY-NUM                       │    │
 ├─ CA-LASTCHANGED ◀──────────────────▶ DB2-LASTCHANGED
 │  (照会時取得)                        │    │ 一致?
 ├─ CA-ISSUE-DATE                       │    ▼
 ├─ CA-EXPIRY-DATE                      ├─▶ MOTOR (Db2) [UPDATE]
 ├─ CA-BROKERID                         │
 ├─ CA-M-MAKE                           ├─▶ POLICY (Db2) [UPDATE]
 ├─ CA-M-MODEL                          │       └─ CURRENT TIMESTAMP
 ├─ CA-M-VALUE                          │
 ├─ ...                                 ▼
 └─ CA-M-ACCIDENTS                LGUPVS01 ───────────▶ KSDSPOLY (VSAM)
                                       │                 [REWRITE]
                                       ▼
                                  COMMAREA
                                       │
                                       ├─ CA-RETURN-CODE
                                       └─ CA-LASTCHANGED（新値）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgupol01.cbl | `base/src/lgupol01.cbl` | COBOLプログラム | ビジネスロジック層（エントリーポイント） |
| lgupdb01.cbl | `base/src/lgupdb01.cbl` | COBOLプログラム | Db2データアクセス層（楽観的ロック＋UPDATE） |
| lgupvs01.cbl | `base/src/lgupvs01.cbl` | COBOLプログラム | VSAMデータアクセス層（REWRITE処理） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA構造定義 |
| lgpolicy.cpy | `base/src/lgpolicy.cpy` | コピーブック | ポリシー/自動車保険データ長定義 |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面定義（SSMAPM2が自動車保険詳細） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | COBOLプログラム | エラーログ共通機能 |
