# 機能設計書 F007-自動車保険削除

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける自動車保険削除機能の詳細設計を定義する。既存の自動車保険ポリシーをDb2データベースおよびVSAMファイルから削除する機能である。

### 本機能の処理概要

本機能は、既に登録されている自動車保険ポリシーを論理的または物理的に削除するための基幹機能を提供する。

**業務上の目的・背景**：保険契約の解約、誤登録の取り消し、テストデータのクリーンアップなど、ポリシーの削除が必要となる場面がある。本機能は、指定されたポリシーを確実に削除し、関連するデータ（MOTORテーブル、POLICYテーブル、VSAMファイル）の整合性を維持する。削除処理は不可逆であるため、慎重な運用が求められる。

**機能の利用シーン**：顧客からの解約申し出時、または管理者によるデータクリーンアップ時に、自動車保険詳細画面でPF3キーを押下して削除を実行する。削除前に必ず照会（F005）で対象データを確認することを推奨。

**主要な処理内容**：
1. リクエストID('01DMOT')とCOMMAREAの検証
2. LGDPOL01プログラムを呼び出しビジネスロジックを実行
3. LGDPDB01プログラムでMOTORテーブルからDELETE
4. POLICYテーブルからDELETE
5. LGDPVS01プログラムでVSAMファイル（KSDSPOLY）からDELETE
6. 処理結果を呼び出し元に返却

**関連システム・外部連携**：Db2データベース、VSAMファイルとの連携。

**権限による制御**：本機能は保険ポリシー削除権限を持つ管理者のみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 自動車保険詳細画面 | 主画面 | PF3キー押下時にLGDPOL01プログラムをCICS LINKで呼び出し、自動車保険ポリシーを削除する |

## 機能種別

CRUD操作（Delete）/ データ削除処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01DMOT'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 存在するポリシー番号 |

### 入力データソース

- 画面入力（自動車保険詳細画面 SSMAPM2）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 POLICYテーブル（削除）
- Db2 MOTORテーブル（削除）
- VSAMファイル（KSDSPOLY）（削除）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ ヘッダー28バイト以上を確認
3. リクエストIDの検証と大文字変換
   └─ UPPER-CASE関数で大文字に変換
4. LGDPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
5. MOTORテーブルからDELETE（LGDPDB01）
   └─ ポリシー番号をキーに削除
6. POLICYテーブルからDELETE（LGDPDB01）
   └─ 顧客番号とポリシー番号をキーに削除
7. VSAMファイルからDELETE（LGDPVS01）
   └─ KSDSPOLYファイルからレコードを削除
8. 結果の返却
   └─ リターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F[リクエストID大文字変換]
    F --> G{REQUEST-ID='01DMOT'?}
    G -->|No| H[RC=99で終了]
    G -->|Yes| I[LGDPDB01呼出]
    I --> J[DELETE MOTOR]
    J --> K{SQLCODE判定}
    K -->|0| L[DELETE POLICY]
    K -->|100| M[RC=01 データなし]
    K -->|Other| N[RC=90 エラー]
    L --> O{SQLCODE判定}
    O -->|0| P[LGDPVS01呼出]
    O -->|Other| Q[ABEND LGSQでロールバック]
    P --> R[VSAMファイルDELETE]
    R --> S[RC=00で正常終了]
    E --> T[終了]
    H --> T
    M --> T
    N --> T
    Q --> T
    S --> T
    C --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 削除順序 | MOTOR→POLICY→VSAMの順で削除（FK制約対応） | 常時 |
| BR-002 | 存在確認 | 指定されたポリシーが存在しない場合は'01'エラー | 削除時 |
| BR-003 | トランザクション整合性 | 全ての削除が成功しないとロールバック | 常時 |
| BR-004 | リクエストID大文字変換 | 小文字で入力されたリクエストIDを大文字に変換 | 常時 |

### 計算ロジック

- 計算ロジックなし（純粋な削除処理）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 自動車情報削除 | MOTOR | DELETE | 自動車保険固有情報の削除 |
| ポリシー情報削除 | POLICY | DELETE | 保険ポリシー共通情報の削除 |

### テーブル別操作詳細

#### MOTOR

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | (全項目) | WHERE POLICYNUMBER = :DB2-POLICYNUM-INT | 外部キー制約のため先に削除 |

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | (全項目) | WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT AND POLICYNUMBER = :DB2-POLICYNUM-INT | MOTOR削除後に実行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 01 | 業務エラー | データが存在しない（SQLCODE=100） | 正しい顧客番号/ポリシー番号を指定 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |
| LGSQ | DB2エラー | POLICY削除失敗 | ABENDでロールバック |

### リトライ仕様

- SQLエラー時はリトライなし
- ABEND('LGSQ')によりトランザクション全体がロールバック

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: ABEND('LGSQ')発生時、MOTORテーブルの削除も含めてロールバック
- 注意: POLICY削除失敗時は、MOTOR削除も含めてロールバックされる

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 主キーによる削除のため高速

## セキュリティ考慮事項

- ポリシー削除は不可逆な操作であるため、管理者権限が必要
- 削除前の照会（F005）実行を運用ルールとして必須化することを推奨
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録
- 監査ログとして削除操作の記録を保持することを推奨

## 備考

- LGDPOL01: ビジネスロジック層（LGDPDB01を呼び出し）
- LGDPDB01: Db2データアクセス層（MOTOR/POLICYテーブルDELETE、LGDPVS01呼び出し）
- LGDPVS01: VSAMデータアクセス層（KSDSPOLYファイル削除）
- 削除はMOTOR→POLICYの順序で実行（外部キー制約対応）
- リクエストIDはFUNCTION UPPER-CASEで大文字変換される

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-CUSTOMER-NUM、CA-POLICY-NUM、CA-RETURN-CODEのデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | DB2-CUSTOMERNUM-INT、DB2-POLICYNUM-INTの定義を確認 |
| 3 | lgdpol01.cbl | base/src/lgdpol01.cbl | ビジネスロジック層のエントリポイント、UPPER-CASE変換とリクエストID検証 |
| 4 | lgdpdb01.cbl | base/src/lgdpdb01.cbl | Db2アクセス層、DELETE SQLの実行とLGDPVS01の呼び出し |
| 5 | lgdpvs01.cbl | base/src/lgdpvs01.cbl | VSAMアクセス層、KSDSPOLYファイルからのレコード削除 |
| 6 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

削除処理で使用する主要フィールド:
- `CA-REQUEST-ID`: '01DMOT'（自動車保険削除を示す識別子）
- `CA-CUSTOMER-NUM`: 削除対象の顧客番号（9桁）
- `CA-POLICY-NUM`: 削除対象のポリシー番号（10桁）
- `CA-RETURN-CODE`: 処理結果（'00'=成功, '01'=データなし, '90'=DBエラー等）

#### Step 2: エントリポイントの理解（lgdpol01.cbl）
**読むべき箇所**: 95-130行目

```
95-99行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

107-110行目: COMMAREA長チェック
  - 28バイト未満の場合はRC='98'で終了

117行目: リクエストIDの大文字変換（重要）
  - FUNCTION UPPER-CASE(CA-REQUEST-ID)で小文字を大文字に変換

119-130行目: リクエストID検証
  - '01DEND', '01DMOT', '01DHOU', '01DCOM'以外はRC='99'
  - 検証OKならDELETE-POLICY-DB2-INFO（141-144行目）でLGDPDB01を呼び出し
```

#### Step 3: Db2アクセス層の理解（lgdpdb01.cbl）
**読むべき箇所**: 148-204行目

```
148-153行目: データ変換
  - CA-CUSTOMER-NUM → DB2-CUSTOMERNUM-INT（整数型に変換）
  - CA-POLICY-NUM → DB2-POLICYNUM-INT（整数型に変換）

160-172行目: リクエストID検証とVSAM呼び出し
  - 検証OKならDELETE-POLICY-DB2-INFO実行後、LGDPVS01を呼び出し

186-204行目: DELETE-POLICY-DB2-INFO（削除SQL）
  - DELETE FROM POLICY WHERE CUSTOMERNUMBER = :host AND POLICYNUMBER = :host
  - 外部キー制約によりMOTORテーブルのレコードも連動して削除される
  - SQLCODE ≠ 0 の場合はRC='90'でエラー終了
```

#### Step 4: VSAMアクセス層の理解（lgdpvs01.cbl）
**読むべき箇所**: 77-91行目

```
77-79行目: キー設定
  - WF-Request-ID: リクエストIDの4文字目（'M'）
  - WF-Customer-Num: 顧客番号
  - WF-Policy-Num: ポリシー番号

81-91行目: VSAM削除
  - EXEC CICS DELETE FILE('KSDSPOLY')
  - Ridfld(WF-Policy-Key): 21バイトのキーで対象レコードを特定
  - エラー時はRC='81'を設定
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

各プログラムでエラー発生時にLGSTSQを呼び出してログを記録:
- lgdpol01.cbl: 154-186行目
- lgdpdb01.cbl: 212-245行目
- lgdpvs01.cbl: 99-132行目

### プログラム呼出し階層

```
SSMAPM2（自動車保険詳細画面）
  ↓ PF3キー押下
LGDPOL01（ビジネスロジック層）
  ├── リクエストID検証（'01DMOT'）
  ├── UPPER-CASE変換
  └── CICS LINK
        ↓
      LGDPDB01（Db2アクセス層）
        ├── DELETE FROM POLICY（FK制約でMOTORも削除）
        └── CICS LINK
              ↓
            LGDPVS01（VSAMアクセス層）
              └── CICS DELETE FILE('KSDSPOLY')
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01DMOT'
  CA-CUSTOMER-NUM=顧客番号
  CA-POLICY-NUM=ポリシー番号
        ↓
[LGDPOL01] リクエストID検証・大文字変換
        ↓
[LGDPDB01] DELETE FROM POLICY → 外部キー制約でMOTORも削除
        ↓
[LGDPVS01] DELETE FILE('KSDSPOLY')
        ↓
[COMMAREA出力]
  CA-RETURN-CODE='00'（成功）/'81'（VSAMエラー）/'90'（DBエラー）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgdpol01.cbl | ビジネスロジック層 |
| COBOL | lgdpdb01.cbl | Db2アクセス層 |
| COBOL | lgdpvs01.cbl | VSAMアクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義 |
| BMS | ssmap.bms | 画面定義（SSMAPM2） |
