# 機能設計書 F008-養老保険登録

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける養老保険登録機能の詳細設計を定義する。新規の養老保険（Endowment）ポリシーをDb2データベースおよびVSAMファイルに登録する機能である。

### 本機能の処理概要

本機能は、顧客に対して新規の養老保険ポリシーを作成・登録するための基幹機能を提供する。

**業務上の目的・背景**：養老保険は、生命保険と貯蓄機能を組み合わせた保険商品であり、満期時に保険金が支払われる。本機能は、顧客が新規に養老保険に加入する際、被保険者情報（氏名）、保険条件（保険期間、保険金額）、運用オプション（利益付き、株式、管理基金）をシステムに登録し、一意のポリシー番号を発行する。可変長データ（PADDINGDATA）にも対応する。

**機能の利用シーン**：顧客が新規に養老保険の契約を希望する際、オペレーターが養老保険追加画面からPF4キーを押下し、顧客番号と保険詳細を入力して登録を実行する。

**主要な処理内容**：
1. リクエストID('01AEND')とCOMMAREAの検証
2. LGAPOL01プログラムを呼び出しビジネスロジックを実行
3. LGAPDB01プログラムでPOLICYテーブルとENDOWMENTテーブルにINSERT
4. Db2のIDENTITY機能で自動採番されたポリシー番号を取得
5. LGAPVS01プログラムでVSAMファイル（KSDSPOLY）に登録
6. 処理結果とポリシー番号を呼び出し元に返却

**関連システム・外部連携**：Db2データベース、VSAMファイルとの連携。

**権限による制御**：本機能は保険ポリシー作成権限を持つオペレーターのみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 養老保険追加画面 | 主画面 | PF4キー押下時にLGAPOL01プログラムをCICS LINKで呼び出し、養老保険ポリシーを新規登録する |

## 機能種別

CRUD操作（Create）/ データ登録処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01AEND'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-ISSUE-DATE | X(10) | Yes | 発効日 | 日付形式（YYYY-MM-DD） |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日 | 日付形式 |
| CA-BROKERID | 9(10) | No | ブローカーID | - |
| CA-BROKERSREF | X(10) | No | ブローカー参照番号 | - |
| CA-PAYMENT | 9(6) | No | 支払額 | - |
| CA-E-WITH-PROFITS | X(1) | Yes | 利益付きフラグ | Y/N |
| CA-E-EQUITIES | X(1) | Yes | 株式オプション | Y/N |
| CA-E-MANAGED-FUND | X(1) | Yes | 管理基金オプション | Y/N |
| CA-E-FUND-NAME | X(10) | No | ファンド名 | - |
| CA-E-TERM | 9(2) | Yes | 保険期間（年） | - |
| CA-E-SUM-ASSURED | 9(6) | Yes | 保険金額 | - |
| CA-E-LIFE-ASSURED | X(31) | Yes | 被保険者名 | - |
| CA-E-PADDING-DATA | X(可変) | No | パディングデータ（VARCHAR） | - |

### 入力データソース

- 画面入力（養老保険追加画面 SSMAPM1A）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-POLICY-NUM | 9(10) | 発行されたポリシー番号 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 POLICYテーブル
- Db2 ENDOWMENTテーブル
- VSAMファイル（KSDSPOLY）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ ヘッダー28バイト + 養老保険データ124バイトを確認
3. LGAPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
4. POLICYテーブルへのINSERT（LGAPDB01）
   └─ ポリシー共通情報を登録、ポリシー番号を自動採番
5. ENDOWMENTテーブルへのINSERT（LGAPDB01）
   └─ 養老保険固有情報を登録（VARCHAR対応）
6. VSAMファイルへの書き込み（LGAPVS01）
   └─ KSDSPOLYファイルにポリシーレコードを登録
7. 結果の返却
   └─ ポリシー番号とリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F{REQUEST-ID='01AEND'?}
    F -->|No| G[RC=99で終了]
    F -->|Yes| H[LGAPDB01呼出]
    H --> I[POLICYテーブルINSERT]
    I --> J{SQLCODE判定}
    J -->|0| K[IDENTITY_VAL_LOCAL取得]
    J -->|-530| L[RC=70 FK違反]
    J -->|Other| M[RC=90 エラー]
    K --> N{VARCHARデータあり?}
    N -->|Yes| O[INSERT with PADDINGDATA]
    N -->|No| P[INSERT without PADDINGDATA]
    O --> Q{SQLCODE=0?}
    P --> Q
    Q -->|Yes| R[LGAPVS01呼出]
    Q -->|No| S[ABEND LGSQでロールバック]
    R --> T[VSAMファイル書込]
    T --> U[RC=00で正常終了]
    E --> V[終了]
    G --> V
    L --> V
    M --> V
    S --> V
    U --> V
    C --> V
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客存在確認 | 登録前に顧客番号の存在を外部キー制約で確認 | 常時 |
| BR-002 | ポリシー番号自動採番 | IDENTITY列によりポリシー番号を自動発行 | 常時 |
| BR-003 | タイムスタンプ設定 | CURRENT TIMESTAMPで最終更新日時を自動設定 | 登録時 |
| BR-004 | ポリシータイプ設定 | 養老保険は'E'（Endowment）をPOLICYTYPEに設定 | 常時 |
| BR-005 | VARCHAR対応 | PADDINGDATAはCOMMAREA長に応じて可変長で登録 | 常時 |
| BR-006 | トランザクション整合性 | POLICYとENDOWMENTの両方が成功しないとロールバック | 常時 |

### 計算ロジック

- ポリシー番号: Db2 IDENTITY_VAL_LOCAL()関数で取得
- 最終更新日時: CURRENT TIMESTAMP（Db2現在タイムスタンプ）
- VARCHAR長: WS-VARY-LEN = EIBCALEN - WS-REQUIRED-CA-LEN

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ポリシー情報登録 | POLICY | INSERT | 保険ポリシー共通情報の登録 |
| 養老保険情報登録 | ENDOWMENT | INSERT | 養老保険固有情報の登録 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | DEFAULT | IDENTITY列で自動採番 |
| INSERT | CUSTOMERNUMBER | :DB2-CUSTOMERNUM-INT | |
| INSERT | ISSUEDATE | :CA-ISSUE-DATE | |
| INSERT | EXPIRYDATE | :CA-EXPIRY-DATE | |
| INSERT | POLICYTYPE | 'E' | Endowment固定 |
| INSERT | LASTCHANGED | CURRENT TIMESTAMP | |
| INSERT | BROKERID | :DB2-BROKERID-INT | |
| INSERT | BROKERSREFERENCE | :CA-BROKERSREF | |
| INSERT | PAYMENT | :DB2-PAYMENT-INT | |

#### ENDOWMENT

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | :DB2-POLICYNUM-INT | POLICYから取得 |
| INSERT | WITHPROFITS | :CA-E-WITH-PROFITS | 利益付きフラグ |
| INSERT | EQUITIES | :CA-E-EQUITIES | 株式オプション |
| INSERT | MANAGEDFUND | :CA-E-MANAGED-FUND | 管理基金 |
| INSERT | FUNDNAME | :CA-E-FUND-NAME | ファンド名 |
| INSERT | TERM | :DB2-E-TERM-SINT | 保険期間 |
| INSERT | SUMASSURED | :DB2-E-SUMASSURED-INT | 保険金額 |
| INSERT | LIFEASSURED | :CA-E-LIFE-ASSURED | 被保険者名 |
| INSERT | PADDINGDATA | :WS-VARY-FIELD | VARCHAR、可変長 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 70 | 業務エラー | 顧客番号が存在しない（SQLCODE=-530） | 正しい顧客番号を指定 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |
| LGSQ | DB2エラー | ENDOWMENTテーブルINSERT失敗 | ABENDでロールバック |

### リトライ仕様

- SQLエラー時はリトライなし
- ABEND('LGSQ')によりトランザクション全体がロールバック

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: ABEND('LGSQ')発生時、POLICYテーブルへの登録も含めてロールバック
- 注意: ENDOWMENTテーブルINSERT失敗時は、POLICYテーブルINSERTも含めてロールバックされる

## パフォーマンス要件

- レスポンス時間: 1秒以内
- IDENTITY列使用によりシーケンス取得が高速
- VARCHAR（PADDINGDATA）のサイズが大きい場合は若干遅延する可能性あり

## セキュリティ考慮事項

- 保険ポリシー作成には適切な権限管理が必要
- 顧客番号の外部キー制約により、存在しない顧客への登録を防止
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録

## 備考

- LGAPOL01: ビジネスロジック層（LGAPDB01を呼び出し）
- LGAPDB01: Db2データアクセス層（POLICY/ENDOWMENTテーブルINSERT、LGAPVS01呼び出し）
- LGAPVS01: VSAMデータアクセス層（KSDSPOLYファイル書込）
- 養老保険固有の長さ定義: WS-FULL-ENDOW-LEN = 124バイト
- PADDINGDATAは最大32611バイトのVARCHAR型

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-CUSTOMER-NUM、CA-E-*（養老保険固有フィールド）のデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | WS-FULL-ENDOW-LEN（124バイト）、DB2ホスト変数の定義を確認 |
| 3 | lgapol01.cbl | base/src/lgapol01.cbl | ビジネスロジック層のエントリポイント、COMMAREA検証 |
| 4 | lgapdb01.cbl | base/src/lgapdb01.cbl | Db2アクセス層、POLICY/ENDOWMENTテーブルINSERT、VARCHAR処理 |
| 5 | lgapvs01.cbl | base/src/lgapvs01.cbl | VSAMアクセス層、KSDSPOLYファイルへの書き込み |
| 6 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

養老保険登録で使用する主要フィールド:
- `CA-REQUEST-ID`: '01AEND'（養老保険登録を示す識別子）
- `CA-CUSTOMER-NUM`: 登録対象の顧客番号
- `CA-E-WITH-PROFITS`: 利益付きフラグ（Y/N）
- `CA-E-EQUITIES`: 株式オプション（Y/N）
- `CA-E-MANAGED-FUND`: 管理基金オプション（Y/N）
- `CA-E-FUND-NAME`: ファンド名
- `CA-E-TERM`: 保険期間（年）
- `CA-E-SUM-ASSURED`: 保険金額
- `CA-E-LIFE-ASSURED`: 被保険者名
- `CA-E-PADDING-DATA`: 可変長データ（VARCHAR）

#### Step 2: エントリポイントの理解（lgapol01.cbl）
**読むべき箇所**: 98-124行目

```
98-102行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

109行目: 必要COMMAREA長の計算開始
  - WS-CA-HEADER-LEN（28バイト）を加算

113-116行目: 長さチェック
  - 不足時はRC='98'で終了

121-124行目: LGAPDB01呼び出し
  - CICS LINKでDb2アクセス層を呼び出し
```

#### Step 3: Db2アクセス層の理解（lgapdb01.cbl）
**読むべき箇所**: 184-397行目

```
184-207行目: リクエストID評価と長さ計算
  - '01AEND'の場合: WS-FULL-ENDOW-LEN（124バイト）を加算
  - DB2-POLICYTYPE = 'E'（Endowment）を設定

210-213行目: COMMAREA長チェック
  - 不足時はRC='98'で終了

219行目: INSERT-POLICY実行

223-241行目: ポリシータイプ別処理
  - '01AEND'の場合、INSERT-ENDOW（226行目）を実行

243-246行目: LGAPVS01呼び出し
  - VSAM書き込み層を呼び出し

261-322行目: INSERT-POLICY手続き
  - 268-288行目: POLICYテーブルINSERT（IDENTITY列で自動採番）
  - 290-305行目: SQLCODE判定（-530=FK違反→RC='70'）
  - 308-311行目: IDENTITY_VAL_LOCAL()でポリシー番号取得
  - 316-321行目: LASTCHANGED取得

327-397行目: INSERT-ENDOW手続き（養老保険固有）
  - 329-331行目: 数値フィールドの整数変換
  - 339-340行目: VARCHAR長計算（EIBCALEN - WS-REQUIRED-CA-LEN）
  - 342-386行目: VARCHARデータ有無による2種類のINSERT
    - 342-366行目: PADDINGDATA有りのINSERT
    - 367-386行目: PADDINGDATA無しのINSERT
  - 389-395行目: エラー時ABEND('LGSQ')でロールバック
```

#### Step 4: VSAMアクセス層の理解（lgapvs01.cbl）
**読むべき箇所**: 99-147行目

```
99-101行目: キー設定
  - WF-Request-ID: リクエストIDの4文字目（'E'）
  - WF-Customer-Num: 顧客番号
  - WF-Policy-Num: ポリシー番号

103-132行目: ポリシータイプ別データ設定
  - 110-115行目: 'E'（Endowment）の場合
    - WF-E-WITH-PROFITS, WF-E-EQUITIES等を設定

135-147行目: VSAM書き込み
  - EXEC CICS WRITE FILE('KSDSPOLY')
  - 64バイト固定長でレコード書き込み
  - エラー時はRC='80'を設定
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

各プログラムでエラー発生時にLGSTSQを呼び出してログを記録:
- lgapol01.cbl: 137-169行目
- lgapdb01.cbl: 562-595行目
- lgapvs01.cbl: 155-188行目

### プログラム呼出し階層

```
SSMAPM1A（養老保険追加画面）
  ↓ PF4キー押下
LGAPOL01（ビジネスロジック層）
  ├── COMMAREA検証
  └── CICS LINK
        ↓
      LGAPDB01（Db2アクセス層）
        ├── INSERT-POLICY（POLICYテーブル）
        │     └── IDENTITY_VAL_LOCAL()でポリシー番号取得
        ├── INSERT-ENDOW（ENDOWMENTテーブル）
        │     └── VARCHAR(PADDINGDATA)対応
        └── CICS LINK
              ↓
            LGAPVS01（VSAMアクセス層）
              └── CICS WRITE FILE('KSDSPOLY')
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01AEND'
  CA-CUSTOMER-NUM=顧客番号
  CA-E-WITH-PROFITS, CA-E-EQUITIES, etc.
  CA-E-PADDING-DATA（可変長）
        ↓
[LGAPOL01] COMMAREA検証
        ↓
[LGAPDB01]
  ├── INSERT INTO POLICY → ポリシー番号自動採番
  └── INSERT INTO ENDOWMENT（VARCHAR対応）
        ↓
[LGAPVS01] WRITE FILE('KSDSPOLY')
        ↓
[COMMAREA出力]
  CA-POLICY-NUM=採番されたポリシー番号
  CA-LASTCHANGED=タイムスタンプ
  CA-RETURN-CODE='00'（成功）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgapol01.cbl | ビジネスロジック層 |
| COBOL | lgapdb01.cbl | Db2アクセス層 |
| COBOL | lgapvs01.cbl | VSAMアクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義（長さ定数含む） |
| BMS | ssmap.bms | 画面定義（SSMAPM1A） |
