# 機能設計書 F009-養老保険照会

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける養老保険照会機能の詳細設計を定義する。顧客番号とポリシー番号を指定して養老保険の詳細情報をDb2データベースから取得する機能である。

### 本機能の処理概要

本機能は、既存の養老保険ポリシーの詳細情報を照会・表示するための基幹機能を提供する。

**業務上の目的・背景**：保険業務において、契約内容の確認、保険金請求の処理、契約更新の際の情報確認など、様々な場面で保険ポリシー情報の参照が必要となる。本機能は、顧客番号とポリシー番号をキーとして養老保険の詳細（被保険者、保険金額、保険期間、運用オプション等）を迅速に取得し、業務効率の向上を支援する。可変長データ（PADDINGDATA）にも対応する。

**機能の利用シーン**：顧客からの問い合わせ対応時、保険金請求処理時、契約更新処理時など、養老保険詳細画面でPF5キーを押下して照会を実行する。

**主要な処理内容**：
1. リクエストID('01IEND')とCOMMAREAの検証
2. LGIPOL01プログラムを呼び出しビジネスロジックを実行
3. LGIPDB01プログラムでPOLICYテーブルとENDOWMENTテーブルをJOINしてSELECT
4. VARCHARデータ（PADDINGDATA）も含めて取得
5. 取得した情報をCOMMAREAに設定
6. 処理結果を呼び出し元に返却

**関連システム・外部連携**：Db2データベースとの連携のみ。

**権限による制御**：本機能は保険ポリシー閲覧権限を持つオペレーターが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 養老保険詳細画面 | 主画面 | PF5キー押下時にLGIPOL01プログラムをCICS LINKで呼び出し、養老保険の詳細情報を取得・表示する |

## 機能種別

CRUD操作（Read）/ データ参照処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01IEND'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 存在するポリシー番号 |

### 入力データソース

- 画面入力（養老保険詳細画面 SSMAPM1）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-ISSUE-DATE | X(10) | 発効日 |
| CA-EXPIRY-DATE | X(10) | 満期日 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ |
| CA-BROKERID | 9(10) | ブローカーID |
| CA-BROKERSREF | X(10) | ブローカー参照番号 |
| CA-PAYMENT | 9(6) | 支払額 |
| CA-E-WITH-PROFITS | X(1) | 利益付きフラグ |
| CA-E-EQUITIES | X(1) | 株式オプション |
| CA-E-MANAGED-FUND | X(1) | 管理基金オプション |
| CA-E-FUND-NAME | X(10) | ファンド名 |
| CA-E-TERM | 9(2) | 保険期間（年） |
| CA-E-SUM-ASSURED | 9(6) | 保険金額 |
| CA-E-LIFE-ASSURED | X(31) | 被保険者名 |
| CA-E-PADDING-DATA | X(可変) | パディングデータ（VARCHAR） |

### 出力先

- CICS通信領域（COMMAREA）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. LGIPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
3. リクエストIDの判定（UPPER-CASEで変換）
   └─ '01IEND'の場合、GET-ENDOW-DB2-INFOを実行
4. POLICY/ENDOWMENTテーブルのJOIN SELECT（LGIPDB01）
   └─ 顧客番号とポリシー番号をキーに保険情報を取得
   └─ PADDINGDATA（VARCHAR）と長さも取得
5. COMMAREAの長さ検証
   └─ VARCHARデータ含めて返却データが格納可能か確認
6. 結果の返却
   └─ 保険詳細情報とリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D[LGIPDB01呼出]
    D --> E[REQUEST-ID大文字変換]
    E --> F{REQUEST-ID判定}
    F -->|'01IEND'| G[GET-ENDOW-DB2-INFO]
    F -->|Other| H[RC=99で終了]
    G --> I[POLICY/ENDOWMENT JOIN SELECT]
    I --> J{SQLCODE判定}
    J -->|0| K[VARCHAR長チェック]
    J -->|100| L[RC=01 データなし]
    J -->|Other| M[RC=90 エラー]
    K --> N{COMMAREA長さ確認}
    N -->|NG| O[RC=98で終了]
    N -->|OK| P[データをCOMMAREAに設定]
    P --> Q[PADDINGDATAをCOMMAREAに設定]
    Q --> R[データ終端マーク'FINAL'設定]
    R --> S[RC=00で正常終了]
    H --> T[終了]
    L --> T
    M --> T
    O --> T
    S --> T
    C --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客ポリシー紐付け | 指定された顧客番号とポリシー番号の組み合わせが一致するレコードのみ返却 | 常時 |
| BR-002 | データ終端マーク | 返却データの末尾（VARCHARデータの後）に'FINAL'マークを付与 | 正常終了時 |
| BR-003 | NULL値処理 | BROKERID/BROKERSREF/PAYMENT/PADDINGDATAはNULL許容。インジケータ変数で判定 | 照会時 |
| BR-004 | VARCHAR長計算 | PADDINGDATAの長さを取得し、COMMAREA長の検証に使用 | 照会時 |

### 計算ロジック

- 必要COMMAREA長: WS-CA-HEADERTRAILER-LEN + WS-FULL-ENDOW-LEN + DB2-E-PADDING-LEN
- データ終端位置: END-POLICY-POS = 1 + DB2-E-PADDING-LEN

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 保険情報取得 | POLICY, ENDOWMENT | SELECT(JOIN) | 養老保険詳細情報の取得 |

### テーブル別操作詳細

#### POLICY, ENDOWMENT (JOIN)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ISSUEDATE | FROM POLICY | |
| SELECT | EXPIRYDATE | FROM POLICY | |
| SELECT | LASTCHANGED | FROM POLICY | |
| SELECT | BROKERID | FROM POLICY | NULL許容（インジケータ使用） |
| SELECT | BROKERSREFERENCE | FROM POLICY | NULL許容 |
| SELECT | PAYMENT | FROM POLICY | NULL許容 |
| SELECT | WITHPROFITS | FROM ENDOWMENT | 利益付きフラグ |
| SELECT | EQUITIES | FROM ENDOWMENT | 株式オプション |
| SELECT | MANAGEDFUND | FROM ENDOWMENT | 管理基金 |
| SELECT | FUNDNAME | FROM ENDOWMENT | ファンド名 |
| SELECT | TERM | FROM ENDOWMENT | 保険期間 |
| SELECT | SUMASSURED | FROM ENDOWMENT | 保険金額 |
| SELECT | LIFEASSURED | FROM ENDOWMENT | 被保険者名 |
| SELECT | PADDINGDATA | FROM ENDOWMENT | VARCHAR、NULL許容 |
| SELECT | LENGTH(PADDINGDATA) | FROM ENDOWMENT | VARCHAR長 |

**WHERE条件**:
```sql
WHERE POLICY.POLICYNUMBER = ENDOWMENT.POLICYNUMBER
  AND POLICY.CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT
  AND POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT
```

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足（VARCHARデータ含む） | 十分な長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 01 | 業務エラー | データが存在しない（SQLCODE=100） | 正しい顧客番号/ポリシー番号を指定 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |

### リトライ仕様

- 参照処理のためリトライ不要
- エラー時は適切なリターンコードで終了

## トランザクション仕様

- トランザクションID: SSC1
- 参照のみの処理のため、コミット/ロールバックの影響なし

## パフォーマンス要件

- レスポンス時間: 1秒以内（VARCHARデータサイズによる）
- 主キーによる単一行SELECT のため高速
- 大きなVARCHARデータがある場合は若干遅延する可能性あり

## セキュリティ考慮事項

- 保険ポリシー情報の閲覧には適切な権限管理が必要
- 顧客番号とポリシー番号の組み合わせでアクセス制御
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録

## 備考

- LGIPOL01: ビジネスロジック層（LGIPDB01を呼び出し）
- LGIPDB01: Db2データアクセス層（POLICY/ENDOWMENTテーブルSELECT）
- 養老保険完全データ長: WS-FULL-ENDOW-LEN = 124バイト
- ヘッダー・トレーラー長: WS-CA-HEADERTRAILER-LEN = 33バイト
- PADDINGDATAがNULLの場合、インジケータ変数（IND-E-PADDINGDATA）で判定

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-CUSTOMER-NUM、CA-POLICY-NUM、CA-E-*（養老保険フィールド）のデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | DB2-ENDOWMENT構造体、WS-FULL-ENDOW-LEN、DB2-E-PADDINGDATA定義を確認 |
| 3 | lgipol01.cbl | base/src/lgipol01.cbl | ビジネスロジック層のエントリポイント |
| 4 | lgipdb01.cbl | base/src/lgipdb01.cbl | Db2アクセス層、POLICY/ENDOWMENT JOIN SELECT、VARCHAR/NULL処理 |
| 5 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

養老保険照会で使用する主要フィールド:
- `CA-REQUEST-ID`: '01IEND'（養老保険照会を示す識別子）
- `CA-CUSTOMER-NUM`: 照会対象の顧客番号
- `CA-POLICY-NUM`: 照会対象のポリシー番号
- `CA-E-WITH-PROFITS`, `CA-E-EQUITIES`, `CA-E-MANAGED-FUND`: 運用オプション（出力）
- `CA-E-TERM`: 保険期間（出力）
- `CA-E-SUM-ASSURED`: 保険金額（出力）
- `CA-E-LIFE-ASSURED`: 被保険者名（出力）
- `CA-E-PADDING-DATA`: 可変長データ（出力）

#### Step 2: エントリポイントの理解（lgipol01.cbl）
**読むべき箇所**: 79-96行目

```
79-83行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

86-88行目: 初期化
  - CA-RETURN-CODE = '00'

91-94行目: LGIPDB01呼び出し
  - CICS LINKでDb2アクセス層を呼び出し（32500バイトCOMMAREA）
```

#### Step 3: Db2アクセス層の理解（lgipdb01.cbl）
**読むべき箇所**: 251-432行目

```
251-255行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

263-267行目: データ変換
  - CA-CUSTOMER-NUM → DB2-CUSTOMERNUM-INT
  - CA-POLICY-NUM → DB2-POLICYNUM-INT

275行目: リクエストIDの大文字変換（重要）
  - FUNCTION UPPER-CASE(CA-REQUEST-ID)

277-310行目: リクエストID評価
  - '01IEND'の場合: GET-ENDOW-DB2-INFO実行（281行目）

327-432行目: GET-ENDOW-DB2-INFO手続き（養老保険照会の核心）
  - 330-368行目: POLICY/ENDOWMENT JOIN SELECT
    - ISSUEDATE, EXPIRYDATE, LASTCHANGED（POLICYから）
    - BROKERID, BROKERSREF, PAYMENT（NULL許容、インジケータ使用）
    - WITHPROFITS, EQUITIES, MANAGEDFUND等（ENDOWMENTから）
    - PADDINGDATA と LENGTH(PADDINGDATA)（VARCHAR対応）

  - 370行目: SQLCODE判定
    - 0: 成功
    - 100: データなし（RC='01'）
    - その他: エラー（RC='90'）

  - 374-375行目: 必要COMMAREA長の計算
    - WS-CA-HEADERTRAILER-LEN + WS-FULL-ENDOW-LEN

  - 383-386行目: VARCHAR長の加算
    - IND-E-PADDINGDATAL ≠ -1 の場合、DB2-E-PADDING-LENを加算

  - 390-392行目: COMMAREA長チェック
    - 不足時はRC='98'で終了

  - 397-413行目: データ移動
    - NULLチェック（インジケータ変数 ≠ -1）
    - DB2-POLICY-COMMON → CA-POLICY-COMMON
    - DB2-ENDOW-FIXED → CA-ENDOWMENT
    - DB2-E-PADDINGDATA → CA-E-PADDING-DATA

  - 417行目: データ終端マーク
    - 'FINAL'をCA-E-PADDING-DATAの末尾に設定
```

#### Step 4: インジケータ変数の理解（lgipdb01.cbl）
**読むべき箇所**: 203-207行目

```
203-207行目: インジケータ変数定義
  - IND-BROKERID: BROKERID列のNULL判定
  - IND-BROKERSREF: BROKERSREFERENCE列のNULL判定
  - IND-PAYMENT: PAYMENT列のNULL判定
  - IND-E-PADDINGDATA: PADDINGDATA列のNULL判定
  - IND-E-PADDINGDATAL: LENGTH(PADDINGDATA)のNULL判定

使用方法:
  - インジケータ = -1: 値はNULL
  - インジケータ ≠ -1: 値は有効
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

各プログラムでエラー発生時にLGSTSQを呼び出してログを記録:
- lgipol01.cbl: 107-139行目
- lgipdb01.cbl: 997-1030行目

### プログラム呼出し階層

```
SSMAPM1（養老保険詳細画面）
  ↓ PF5キー押下
LGIPOL01（ビジネスロジック層）
  ├── COMMAREA検証
  └── CICS LINK
        ↓
      LGIPDB01（Db2アクセス層）
        ├── リクエストID大文字変換
        ├── リクエストID評価（'01IEND'）
        └── GET-ENDOW-DB2-INFO
              ├── SELECT POLICY JOIN ENDOWMENT
              ├── NULLインジケータ処理
              ├── VARCHAR長計算・データ移動
              └── 'FINAL'マーク設定
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01IEND'
  CA-CUSTOMER-NUM=顧客番号
  CA-POLICY-NUM=ポリシー番号
        ↓
[LGIPOL01] COMMAREA検証
        ↓
[LGIPDB01]
  ├── リクエストID大文字変換
  └── SELECT FROM POLICY, ENDOWMENT
        WHERE POLICY.POLICYNUMBER = ENDOWMENT.POLICYNUMBER
          AND CUSTOMERNUMBER = ? AND POLICYNUMBER = ?
        ↓
[COMMAREA出力]
  CA-ISSUE-DATE, CA-EXPIRY-DATE（発効日、満期日）
  CA-LASTCHANGED（タイムスタンプ）
  CA-BROKERID, CA-BROKERSREF, CA-PAYMENT（NULL許容）
  CA-E-WITH-PROFITS, CA-E-EQUITIES, CA-E-MANAGED-FUND（運用オプション）
  CA-E-TERM, CA-E-SUM-ASSURED, CA-E-LIFE-ASSURED（保険詳細）
  CA-E-PADDING-DATA（可変長データ + 'FINAL'マーク）
  CA-RETURN-CODE='00'（成功）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgipol01.cbl | ビジネスロジック層 |
| COBOL | lgipdb01.cbl | Db2アクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義（DB2-ENDOWMENT含む） |
| BMS | ssmap.bms | 画面定義（SSMAPM1） |
