---
generated_at: 2026-01-06 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：F001-顧客登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **レスポンス時間要件**：根拠不足（ソースコードからは読み取れない非機能要件）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgacus01.cbl` - 顧客登録ビジネスロジック
- E-02: `base/src/lgacdb01.cbl` - Db2顧客データ登録
- E-03: `base/src/lgacdb02.cbl` - セキュリティデータ登録
- E-04: `base/src/lgacvs01.cbl` - VSAM顧客データ登録
- E-05: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-06: `base/src/lgpolicy.cpy` - ポリシー/顧客長さ定義
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGACUS01がビジネスロジック層として機能する | E-01 L119: PERFORM INSERT-CUSTOMER, L134: EXEC CICS LINK Program(LGACDB01) | ○ |
| C-02 | LGACDB01がDb2への顧客データ登録を行う | E-02 L216-287: INSERT-CUSTOMER セクション | ○ |
| C-03 | 名前付きカウンタGENACUSTNUMから顧客番号を取得 | E-02 L38: GENAcount PIC X(16) Value 'GENACUSTNUM', L199-211: Obtain-CUSTOMER-Number | ○ |
| C-04 | カウンタ取得失敗時はIDENTITY_VAL_LOCAL()を使用 | E-02 L280-282: SET :DB2-CUSTOMERNUM-INT = IDENTITY_VAL_LOCAL() | ○ |
| C-05 | CUSTOMERテーブルに10項目をINSERT | E-02 L222-244: INSERT INTO CUSTOMER | ○ |
| C-06 | LGACVS01がVSAMファイルKSDSCUSTに書き込む | E-04 L68-74: Exec CICS Write File('KSDSCUST') | ○ |
| C-07 | LGACDB02がCUSTOMER_SECUREテーブルに登録 | E-03 L166-176: INSERT INTO CUSTOMER_SECURE | ○ |
| C-08 | 初期パスワードは固定MD5ハッシュ値 | E-02 L181-182: move '5732fec825535eeafb8fac50fee3a8aa' To D2-CUSTSECR-PASS | ○ |
| C-09 | セキュリティ状態は'N'で初期化 | E-02 L184: Move 'N' To D2-CUSTSECR-STATE | ○ |
| C-10 | COMMAREAなしでABEND('LGCA')発生 | E-01 L95-99: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-11 | COMMAREA長さ不足で'98'エラー | E-01 L112-115: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN MOVE '98' TO CA-RETURN-CODE | ○ |
| C-12 | VSAMエラー時にABEND('LGV0')発生 | E-04 L75-80: If WS-RESP Not = DFHRESP(NORMAL) ... EXEC CICS ABEND ABCODE('LGV0') | ○ |
| C-13 | エラー時にLGSTSQプログラムでログ出力 | E-01 L159-162: EXEC CICS LINK PROGRAM('LGSTSQ') | ○ |
| C-14 | CA-CUSTOMER-NUMは9(10)型 | E-05 L12: 03 CA-CUSTOMER-NUM PIC 9(10) | ○ |
| C-15 | CA-RETURN-CODEは9(2)型 | E-05 L11: 03 CA-RETURN-CODE PIC 9(2) | ○ |
| C-16 | 顧客データ長は72バイト | E-06 L17: 03 WS-CUSTOMER-LEN PIC S9(4) COMP VALUE +72 | ○ |
| C-17 | ヘッダー長は18バイト | E-01 L56: 03 WS-CA-HEADER-LEN PIC S9(4) COMP VALUE +18 | ○ |
| C-18 | 画面No.1からオプション2で呼び出し | E-08 行2: 顧客メニュー画面, F001, オプション2選択時 | ○ |
| C-19 | トランザクションIDはSSC1 | E-07 行2: SSC1 | ○ |
| C-20 | VSAM書込時のレコードサイズは225バイト | E-04 L49: CUSTOMER-RECORD-SIZE PIC S9(4) BINARY VALUE 0225 | ○ |
| C-21 | 名前付きカウンタのプール名はGENA | E-02 L39: GENApool PIC X(8) Value 'GENA' | ○ |
| C-22 | D2-REQUEST-IDは'02ACUS'を使用 | E-02 L180: Move '02ACUS' To D2-REQUEST-ID | ○ |
| C-23 | パスワード変更回数は'0000'で初期化 | E-02 L183: Move '0000' To D2-CUSTSECR-COUNT | ○ |
| C-24 | SQLエラー時は'90'リターンコード | E-02 L246-248: MOVE '90' TO CA-RETURN-CODE | ○ |
| C-25 | レスポンス時間1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンス時間要件はソースコードからは確認できない非機能要件
  - 候補：システム要件定義書 / 性能要件書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 1: 中リスク - 初期パスワードが固定値のため、セキュリティ観点での確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 初期パスワードの固定値使用がセキュリティポリシーに適合しているか確認
- [ ] レスポンス時間要件の根拠を確認（非機能要件書等）
- [ ] VSAM/Db2の整合性維持方法が業務要件を満たしているか確認
