---
generated_at: 2026-01-06 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F010-養老保険更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgupol01.cbl` - ポリシー更新ビジネスロジック
- E-02: `base/src/lgupdb01.cbl` - Db2ポリシーデータ更新
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `base/src/lgpolicy.cpy` - ポリシー長さ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGUPOL01がビジネスロジック層として機能する | E-01 L157-160: EXEC CICS LINK Program(LGUPDB01) | ○ |
| C-02 | リクエストID'01UEND'で養老保険更新を識別 | E-01 L115-121: WHEN '01UEND' ... ADD WS-FULL-ENDOW-LEN | ○ |
| C-03 | COMMAREAなしでABEND('LGCA')発生 | E-01 L99-103: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-04 | COMMAREA長さ不足で'98'エラー | E-01 L118-121: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN MOVE '98' | ○ |
| C-05 | SELECT FOR UPDATEでカーソルを宣言 | E-02 L128-143: DECLARE POLICY_CURSOR CURSOR WITH HOLD FOR SELECT ... FOR UPDATE OF | ○ |
| C-06 | CURSOR OPENでロック取得 | E-02 L255-257: EXEC SQL OPEN POLICY_CURSOR | ○ |
| C-07 | SQLCODE=-913でロック競合'90' | E-02 L262-265: When -913 MOVE '90' TO CA-RETURN-CODE | ○ |
| C-08 | タイムスタンプ比較による楽観的ロック | E-02 L278: IF CA-LASTCHANGED EQUAL TO DB2-LASTCHANGED | ○ |
| C-09 | タイムスタンプ不一致で'02'エラー | E-02 L346: MOVE '02' TO CA-RETURN-CODE | ○ |
| C-10 | ENDOWMENTテーブルの7項目をUPDATE | E-02 L394-406: UPDATE ENDOWMENT SET WITHPROFITS, EQUITIES, ... WHERE POLICYNUMBER | ○ |
| C-11 | POLICYテーブルをWHERE CURRENT OFでUPDATE | E-02 L318-326: UPDATE POLICY SET ... WHERE CURRENT OF POLICY_CURSOR | ○ |
| C-12 | CURRENT TIMESTAMPで新タイムスタンプ設定 | E-02 L322: LASTCHANGED = CURRENT TIMESTAMP | ○ |
| C-13 | 新タイムスタンプをSELECTで取得 | E-02 L329-334: SELECT LASTCHANGED INTO :CA-LASTCHANGED | ○ |
| C-14 | UPDATE失敗でSYNCPOINT ROLLBACK | E-02 L338: EXEC CICS SYNCPOINT ROLLBACK | ○ |
| C-15 | LGUPVS01を呼び出してVSAM更新 | E-02 L209-212: EXEC CICS LINK Program(LGUPVS01) | ○ |
| C-16 | CURSOR CLOSE処理 | E-02 L362-367: EXEC SQL CLOSE POLICY_CURSOR | ○ |
| C-17 | 養老保険完全データ長は124バイト | E-04 L24: 03 WS-FULL-ENDOW-LEN PIC S9(4) COMP VALUE +124 | ○ |
| C-18 | ヘッダー長は28バイト | E-01 L62: 03 WS-CA-HEADER-LEN PIC S9(4) COMP VALUE +28 | ○ |
| C-19 | トランザクションIDはSSC1 | E-05 行11: SSC1 | ○ |
| C-20 | 画面No.4からPF4で呼び出し | E-06 行11: 養老保険詳細画面, F010, PF4キー押下時 | ○ |
| C-21 | SQLCODE=100でデータなし'01' | E-02 L351-352: IF SQLCODE EQUAL 100 MOVE '01' TO CA-RETURN-CODE | ○ |
| C-22 | DB2-E-TERM-SINTに保険期間を変換 | E-02 L390: MOVE CA-E-TERM TO DB2-E-TERM-SINT | ○ |
| C-23 | DB2-E-SUMASSURED-INTに保険金額を変換 | E-02 L391: MOVE CA-E-SUM-ASSURED TO DB2-E-SUMASSURED-INT | ○ |
| C-24 | カーソルはWITH HOLDオプション | E-02 L128: DECLARE POLICY_CURSOR CURSOR WITH HOLD FOR | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - 楽観的ロック実装の正確性確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 楽観的ロック（タイムスタンプ比較）の実装が正確か確認
- [ ] SELECT FOR UPDATEとWITH HOLDの組み合わせが適切か確認
- [ ] SYNCPOINT ROLLBACKのタイミングが適切か確認
- [ ] PADDINGDATAが更新対象外であることが業務要件に適合しているか確認
- [ ] 更新前の照会（F009）実行が運用手順に含まれているか確認
