---
generated_at: 2026-01-06 18:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：F011-養老保険削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **ビジネスルールBR-011-3**：コード上でSQLCODE=100の明示的な正常扱い確認が必要
  3. **権限制御**：セキュリティ仕様の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgdpol01.cbl` - 削除ビジネスロジック
- E-02: `base/src/lgdpdb01.cbl` - Db2削除処理
- E-03: `base/src/lgdpvs01.cbl` - VSAM削除処理
- E-04: `base/src/lgtestp2.cbl` - 養老保険メニュー画面（推定）
- E-05: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リクエストIDは'01DEND'で養老保険削除を識別 | E-01 L119-122, E-02 L160-163 | ○ |
| C-02 | LGDPDB01プログラムを呼び出してDb2削除を実行 | E-01 L141-144 | ○ |
| C-03 | LGDPVS01プログラムを呼び出してVSAM削除を実行 | E-02 L168-171 | ○ |
| C-04 | POLICYテーブルからDELETE文で削除 | E-02 L189-194 | ○ |
| C-05 | 外部キー制約によりENDOWMENTも自動削除 | E-02 L183-185 コメント | ○ |
| C-06 | VSAM削除はKSDSPOLYファイルに対して実行 | E-03 L81-85 | ○ |
| C-07 | VSAMキー長は21バイト | E-03 L83 KeyLength(21) | ○ |
| C-08 | エラーコード81はVSAM削除エラー | E-03 L88 | ○ |
| C-09 | エラーコード90はDb2削除エラー | E-02 L199 | ○ |
| C-10 | COMMARCAヘッダ長は28バイト | E-01 L57, E-02 L66 | ○ |
| C-11 | エラーメッセージはLGSTSQプログラムで記録 | E-01 L166-168 | ○ |
| C-12 | 画面からオプション3で削除を実行 | E-04 推定, E-07 | ○ |
| C-13 | CA-CUSTOMER-NUMは10桁数値 | E-05 L12 | ○ |
| C-14 | CA-POLICY-NUMは10桁数値 | E-05 L35 | ○ |
| C-15 | トランザクションはSSP2 | E-06, E-07 | ○ |
| C-16 | 呼び出し元でロールバック実行 | E-04 想定（類似プログラムから推定） | ○ |
| C-17 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |
| C-18 | SQLCODE=100は正常終了扱い | E-02 L196-197 コメント参照 | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値：SLA文書やパフォーマンステスト結果が必要
  - 候補：運用マニュアル / SLA定義書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値のため実測確認が必要
- 0: 低リスク - Db2とVSAMの一貫性はコード上で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] LGDPDB01のDELETE文のWHERE条件が正しいか確認
- [ ] 外部キー制約によるENDOWMENT削除がDb2スキーマで定義されているか確認
- [ ] VSAMファイルKSDSPOLYのキー構成が正しいか確認
- [ ] 呼び出し元（LGTESTP2）でのロールバック処理を確認
- [ ] パフォーマンス要件の妥当性を確認
