---
generated_at: 2026-01-06 18:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：F013-住宅保険照会

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **NULL値処理のインジケータ変数**：実装詳細の確認
  3. **終了マーカーの正確な位置**：COMMAREA構造との整合性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgipol01.cbl` - 照会ビジネスロジック
- E-02: `base/src/lgipdb01.cbl` - Db2照会処理
- E-03: `base/src/lgtestp3.cbl` - 住宅保険メニュー画面
- E-04: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リクエストIDは'01IHOU'で住宅保険照会を識別 | E-02 L283, E-03 L67 | ○ |
| C-02 | LGIPDB01プログラムを呼び出してDb2照会を実行 | E-01 L91-94 | ○ |
| C-03 | POLICYとHOUSEテーブルをJOINしてSELECT | E-02 L444-476 | ○ |
| C-04 | SQLCODE=100でデータなしを判定 | E-02 L512-514 | ○ |
| C-05 | エラーコード01はデータなし | E-02 L514 | ○ |
| C-06 | エラーコード90はDb2照会エラー | E-02 L516-519 | ○ |
| C-07 | 画面からオプション1で照会を実行 | E-03 L66-90 | ○ |
| C-08 | オプション4（更新）の前処理として呼び出される | E-03 L155-165 | ○ |
| C-09 | BROKERID、BROKERSREF、PAYMENTはNULL許容 | E-02 L460-462 インジケータ変数 | ○ |
| C-10 | 終了マーカーとして'FINAL'を設定 | E-02 L508 | ○ |
| C-11 | CA-H-PROPERTYTYPEに物件種別を設定 | E-02 L463 | ○ |
| C-12 | 数値型からCOBOL数値型への変換処理 | E-02 L500-501 | ○ |
| C-13 | COMMAREA長不足時はRC='98' | E-02 L487-489 | ○ |
| C-14 | 顧客番号とポリシー番号を条件に検索 | E-02 L472-475 | ○ |
| C-15 | データをCOMMAREAに設定 | E-02 L503-504 | ○ |
| C-16 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値：SLA文書やパフォーマンステスト結果が必要
  - 候補：運用マニュアル / SLA定義書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 照会処理は読み取り専用で安全
- 0: 低リスク - JOIN処理はインデックス使用で効率的
- 0: 低リスク - 単一レコード取得のため問題発生しにくい

## 6) レビュアーチェックリスト（最小）
- [ ] SELECT文のJOIN条件が正しいか確認
- [ ] NULL許容項目のインジケータ変数処理を確認
- [ ] COMMAREA長計算ロジックを確認
- [ ] パフォーマンス要件の妥当性を確認
