---
generated_at: 2026-01-06 18:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：F014-住宅保険更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **ロック待ちタイムアウト処理**：実装詳細の確認
  3. **VSAM更新失敗時のロールバック**：実装有無の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgupol01.cbl` - 更新ビジネスロジック
- E-02: `base/src/lgupdb01.cbl` - Db2更新処理
- E-03: `base/src/lgupvs01.cbl` - VSAM更新処理（推定）
- E-04: `base/src/lgtestp3.cbl` - 住宅保険メニュー画面
- E-05: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リクエストIDは'01UHOU'で住宅保険更新を識別 | E-01 L123, E-04 L183 | ○ |
| C-02 | LGUPDB01プログラムを呼び出してDb2更新を実行 | E-01 L157-160 | ○ |
| C-03 | SELECT FOR UPDATEでレコードをロック | E-02 L128-143 | ○ |
| C-04 | タイムスタンプ比較で楽観的ロックを実施 | E-02 L278 | ○ |
| C-05 | タイムスタンプ不一致時はRC='02' | E-02 L346 | ○ |
| C-06 | HOUSEテーブルをUPDATE | E-02 L431-442 | ○ |
| C-07 | POLICYテーブルをUPDATE | E-02 L318-326 | ○ |
| C-08 | LASTCHANGEDはCURRENT TIMESTAMPで更新 | E-02 L322 | ○ |
| C-09 | 更新後のLASTCHANGEDをSELECTで取得 | E-02 L329-334 | ○ |
| C-10 | POLICY UPDATE失敗時にSYNCPOINT ROLLBACK | E-02 L338 | ○ |
| C-11 | カーソルはWITH HOLDで定義 | E-02 L129 | ○ |
| C-12 | LGUPVS01を呼び出してVSAM更新 | E-02 L209-212 | ○ |
| C-13 | 画面からオプション4で更新を実行 | E-04 L155-214 | ○ |
| C-14 | まず照会してから更新を実行 | E-04 L156-165 | ○ |
| C-15 | エラーコード01はデータなし | E-02 L351-352 | ○ |
| C-16 | エラーコード90はDb2更新エラー | E-02 L353-356 | ○ |
| C-17 | SQLCODE=-913はロック競合 | E-02 L262-265 | ○ |
| C-18 | HOUSE UPDATE条件はPOLICYNUMBER | E-02 L441 | ○ |
| C-19 | 必要なCOMMAREA長を検証 | E-01 L123-129 | ○ |
| C-20 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値：SLA文書やパフォーマンステスト結果が必要
  - 候補：運用マニュアル / SLA定義書 / 性能テスト結果
- LGUPVS01の詳細実装：ファイルが存在するが詳細確認が必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ロック待ちタイムアウト時の挙動確認が必要
- 1: 中リスク - VSAM更新失敗時のDb2ロールバック処理の有無
- 0: 低リスク - 楽観的ロックは正しく実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] SELECT FOR UPDATEのカラムリストが正しいか確認
- [ ] タイムスタンプ比較ロジックが正しいか確認
- [ ] HOUSEテーブルUPDATE文のカラムリストが正しいか確認
- [ ] ロールバック処理の範囲と条件を確認
- [ ] パフォーマンス要件の妥当性を確認
