---
generated_at: 2026-01-06 18:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：F016-商業用不動産保険登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **リスク保険料の計算ロジック**：自動計算の有無確認
  3. **COMMERCIALテーブルの全カラムリスト**：DDL確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgapol01.cbl` - 登録ビジネスロジック
- E-02: `base/src/lgapdb01.cbl` - Db2登録処理
- E-03: `base/src/lgapvs01.cbl` - VSAM登録処理
- E-04: `base/src/lgtestp4.cbl` - 商業用不動産保険メニュー画面
- E-05: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リクエストIDは'01ACOM'で商業用不動産保険登録を識別 | E-02 L193, E-04 L157 | ○ |
| C-02 | LGAPDB01プログラムを呼び出してDb2登録を実行 | E-01 L121-124 | ○ |
| C-03 | LGAPVS01プログラムを呼び出してVSAM登録を実行 | E-02 L243-246 | ○ |
| C-04 | POLICYテーブルへINSERT文で登録 | E-02 L268-288 | ○ |
| C-05 | ポリシー番号はIDENTITY_VAL_LOCAL()で取得 | E-02 L308-310 | ○ |
| C-06 | COMMERCIALテーブルへINSERT文で登録 | E-02 L480-520（推定） | ○ |
| C-07 | VSAM書込はKSDSPOLYファイルに対して実行 | E-03 L135-141 | ○ |
| C-08 | VSAMキー長は21バイト | E-03 L139 KeyLength(21) | ○ |
| C-09 | エラーコード70は顧客不在（SQLCODE=-530） | E-02 L295-298 | ○ |
| C-10 | エラーコード80はVSAM書込エラー | E-03 L144 | ○ |
| C-11 | エラーコード90はDb2登録エラー | E-02 L300-303 | ○ |
| C-12 | COMMERCIAL INSERT失敗時はABEND発行 | E-02 L525-527（推定） | ○ |
| C-13 | 画面からオプション2で登録を実行 | E-04 L156-195 | ○ |
| C-14 | 呼び出し元でロールバック実行 | E-04 L183 | ○ |
| C-15 | ポリシータイプは'C'で設定 | E-02 L194 | ○ |
| C-16 | CA-B-Addressは255バイト | E-05 L78 | ○ |
| C-17 | CA-B-Postcodeは8バイト | E-05 L79 | ○ |
| C-18 | CA-B-FirePerilは4桁数値 | E-05 L84 | ○ |
| C-19 | CA-B-FirePremiumは8桁数値 | E-05 L85 | ○ |
| C-20 | CA-B-Statusは4桁数値 | E-05 L92 | ○ |
| C-21 | 4種類のリスク保険料を個別管理 | E-05 L84-91 | ○ |
| C-22 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値：SLA文書やパフォーマンステスト結果が必要
  - 候補：運用マニュアル / SLA定義書 / 性能テスト結果
- COMMERCIALテーブルのDDL：正確なカラム定義の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは全てソースコードで確認済み
- 1: 中リスク - VSAM書込失敗時のDb2ロールバック処理の有無
- 0: 低リスク - 顧客存在確認は外部キー制約で保証

## 6) レビュアーチェックリスト（最小）
- [ ] LGAPDB01のCOMMERCIAL INSERT文のカラムリストが正しいか確認
- [ ] COMMERCIALテーブルのカラム名とデータ型が正しいか確認
- [ ] 4種類のリスク保険料フィールドのデータ型を確認
- [ ] VSAM書込失敗時のエラーハンドリングが適切か確認
- [ ] パフォーマンス要件の妥当性を確認
