---
generated_at: 2026-01-06 18:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：F017-商業用不動産保険照会

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **一覧照会の件数制限ロジック**：実装詳細の確認
  3. **カーソルの属性**：INSENSITIVE SCROLL属性の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgipol01.cbl` - 照会ビジネスロジック
- E-02: `base/src/lgipdb01.cbl` - Db2照会処理
- E-03: `base/src/lgtestp4.cbl` - 商業用不動産保険メニュー画面
- E-04: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リクエストID '01ICOM'で単一ポリシー照会 | E-02 L291, E-03 L87 | ○ |
| C-02 | リクエストID '02ICOM'でポリシー番号照会 | E-02 L295, E-03 L97 | ○ |
| C-03 | リクエストID '03ICOM'で顧客別一覧照会 | E-02 L299, E-03 L106 | ○ |
| C-04 | リクエストID '05ICOM'で郵便番号照会 | E-02 L303, E-03 L115 | ○ |
| C-05 | LGIPDB01プログラムを呼び出してDb2照会を実行 | E-01 L91-94 | ○ |
| C-06 | Cust_Cursorカーソルの定義 | E-02 L89-118 | ○ |
| C-07 | Zip_Cursorカーソルの定義 | E-02 L121-149 | ○ |
| C-08 | カーソルはINSENSITIVE SCROLL属性 | E-02 L90, L122 | ○ |
| C-09 | 一覧照会は最大20件まで | E-02 L907-909 | ○ |
| C-10 | エラーコード88はカーソルCLOSEエラー | E-02 L855-858 | ○ |
| C-11 | エラーコード89はカーソルOPENエラー | E-02 L843-846 | ○ |
| C-12 | エラーコード01はデータなし | E-02 L712-714 | ○ |
| C-13 | 画面からオプション1で照会を実行 | E-03 L73-154 | ○ |
| C-14 | 画面で検索条件により自動的にリクエストIDを設定 | E-03 L74-120 | ○ |
| C-15 | POLICYとCOMMERCIALテーブルをJOIN | E-02 L113-117, L145-148 | ○ |
| C-16 | 終了マーカーとして'FINAL'を設定 | E-02 L708 | ○ |
| C-17 | CA-B-Addressに物件住所を設定 | E-02 L655 | ○ |
| C-18 | 数値型からCOBOL数値型への変換処理 | E-02 L693-701 | ○ |
| C-19 | COMMAREA長不足時はRC='98' | E-02 L689-691 | ○ |
| C-20 | 03ICOMでCust_CursorをOPEN/FETCHループ | E-02 L835-861 | ○ |
| C-21 | 05ICOMでZip_CursorをOPEN/FETCHループ | E-02 L919-942 | ○ |
| C-22 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値：SLA文書やパフォーマンステスト結果が必要
  - 候補：運用マニュアル / SLA定義書 / 性能テスト結果
- 一覧照会の件数制限の業務要件根拠

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 照会処理は読み取り専用で安全
- 0: 低リスク - カーソル処理は適切に実装されている
- 1: 中リスク - 大量データ時のパフォーマンス確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 4種類の検索モードの条件判定が正しいか確認
- [ ] カーソル定義のJOIN条件が正しいか確認
- [ ] 一覧照会の件数制限ロジックが適切か確認
- [ ] エラーコードの設定が漏れなく実装されているか確認
- [ ] パフォーマンス要件の妥当性を確認
