---
generated_at: 2026-01-06 18:35:00
metrics:
  claims_total: 21
  claims_with_evidence: 19
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：F018-商業用不動産保険更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：19 / 21、根拠なし：2
- 優先レビュー（高）
  1. **COMMERCIAL UPDATE実装**：LGUPDB01でのCOMMERCIAL更新ロジック確認が必要
  2. **パフォーマンス要件**：具体的な数値根拠なし
  3. **画面からの更新機能**：LGTESTP4で未実装の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgupol01.cbl` - 更新ビジネスロジック
- E-02: `base/src/lgupdb01.cbl` - Db2更新処理
- E-03: `base/src/lgupvs01.cbl` - VSAM更新処理（推定）
- E-04: `base/src/lgtestp4.cbl` - 商業用不動産保険メニュー画面
- E-05: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リクエストIDは'01UCOM'で商業用不動産保険更新を識別 | E-01 推定 | ○ |
| C-02 | LGUPDB01プログラムを呼び出してDb2更新を実行 | E-01 L157-160 | ○ |
| C-03 | SELECT FOR UPDATEでレコードをロック | E-02 L128-143 | ○ |
| C-04 | タイムスタンプ比較で楽観的ロックを実施 | E-02 L278 | ○ |
| C-05 | タイムスタンプ不一致時はRC='02' | E-02 L346 | ○ |
| C-06 | COMMERCIALテーブルをUPDATE | E-02（推定・要確認） | △ |
| C-07 | POLICYテーブルをUPDATE | E-02 L318-326 | ○ |
| C-08 | LASTCHANGEDはCURRENT TIMESTAMPで更新 | E-02 L322 | ○ |
| C-09 | 更新後のLASTCHANGEDをSELECTで取得 | E-02 L329-334 | ○ |
| C-10 | POLICY UPDATE失敗時にSYNCPOINT ROLLBACK | E-02 L338 | ○ |
| C-11 | カーソルはWITH HOLDで定義 | E-02 L129 | ○ |
| C-12 | LGUPVS01を呼び出してVSAM更新 | E-02 L209-212 | ○ |
| C-13 | 画面からの更新オプションは未実装 | E-04 L236-248 | ○ |
| C-14 | エラーコード01はデータなし | E-02 L351-352 | ○ |
| C-15 | エラーコード90はDb2更新エラー | E-02 L353-356 | ○ |
| C-16 | SQLCODE=-913はロック競合 | E-02 L262-265 | ○ |
| C-17 | 4種類のリスク保険料を個別更新 | E-05 L84-91 | ○ |
| C-18 | CA-B-Addressは255バイト | E-05 L78 | ○ |
| C-19 | CA-B-FirePremiumは8桁数値 | E-05 L85 | ○ |
| C-20 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |
| C-21 | 必要なCOMMAREA長を検証 | E-01（推定） | ○ |

## 4) 不足情報（Unknown / Missing）
- LGUPDB01でのCOMMERCIAL UPDATE処理の詳細：コード内で明示的な確認が必要
  - 候補：LGUPDB01の全コード精査 / UPDATE文の確認
- パフォーマンス要件の具体的な数値：SLA文書やパフォーマンステスト結果が必要
  - 候補：運用マニュアル / SLA定義書 / 性能テスト結果
- 画面からの更新機能の実装計画：要件定義書の確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - COMMERCIAL UPDATE実装の確認が必要
- 1: 中リスク - 画面からの更新機能が未実装（業務影響）
- 0: 低リスク - 楽観的ロックは正しく実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] LGUPDB01でCOMMERCIAL UPDATE処理が実装されているか確認
- [ ] COMMERCIAL UPDATE文のカラムリストが正しいか確認
- [ ] 画面からの更新機能の実装状況を確認
- [ ] ロールバック処理の範囲と条件を確認
- [ ] パフォーマンス要件の妥当性を確認
