---
generated_at: 2026-01-06 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F002-顧客照会

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgicus01.cbl` - 顧客照会ビジネスロジック
- E-02: `base/src/lgicdb01.cbl` - Db2顧客データ取得
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `base/src/lgpolicy.cpy` - ポリシー/顧客長さ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGICUS01がビジネスロジック層として機能する | E-01 L109: PERFORM GET-CUSTOMER-INFO, L122-125: EXEC CICS LINK Program(LGICDB01) | ○ |
| C-02 | LGICDB01がDb2からの顧客データ取得を行う | E-02 L167-203: GET-CUSTOMER-INFO セクション | ○ |
| C-03 | CUSTOMERテーブルから9項目をSELECT | E-02 L169-190: SELECT FIRSTNAME, LASTNAME, ... FROM CUSTOMER | ○ |
| C-04 | 顧客番号をキーにWHERE条件を設定 | E-02 L189: WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUMBER-INT | ○ |
| C-05 | COMMAREAなしでABEND('LGCA')発生 | E-01 L87-91: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-06 | COMMAREA長さ不足で'98'エラー | E-01 L104-107: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN MOVE '98' TO CA-RETURN-CODE | ○ |
| C-07 | SQLCODE=0で正常終了'00' | E-02 L193-194: When 0 MOVE '00' TO CA-RETURN-CODE | ○ |
| C-08 | SQLCODE=100でデータなし'01' | E-02 L195-196: When 100 MOVE '01' TO CA-RETURN-CODE | ○ |
| C-09 | SQLCODE=-913でロック競合'01' | E-02 L197-198: When -913 MOVE '01' TO CA-RETURN-CODE | ○ |
| C-10 | その他SQLエラーで'90' | E-02 L199-202: When Other MOVE '90' TO CA-RETURN-CODE | ○ |
| C-11 | エラー時にLGSTSQプログラムでログ出力 | E-01 L146-149: EXEC CICS LINK PROGRAM('LGSTSQ') | ○ |
| C-12 | ヘッダー長は18バイト | E-01 L57: 03 WS-CA-HEADERTRAILER-LEN PIC S9(4) COMP VALUE +18 | ○ |
| C-13 | 顧客データ長は72バイト | E-04 L17: 03 WS-CUSTOMER-LEN PIC S9(4) COMP VALUE +72 | ○ |
| C-14 | CA-NUM-POLICIESを'00'で初期化 | E-01 L94: MOVE '00' TO CA-NUM-POLICIES | ○ |
| C-15 | トランザクションIDはSSC1 | E-05 行3: SSC1 | ○ |
| C-16 | 画面No.1からオプション1で呼び出し | E-06 行3: 顧客メニュー画面, F002, オプション1選択時 | ○ |
| C-17 | 顧客番号はDB2-CUSTOMERNUMBER-INT変数に変換 | E-02 L146: MOVE CA-CUSTOMER-NUM TO DB2-CUSTOMERNUMBER-INT | ○ |
| C-18 | リンク時のCOMMAREA長さは32500バイト | E-01 L124: LENGTH(32500) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高く、単純な参照処理のため

## 6) レビュアーチェックリスト（最小）
- [ ] SQLCODE=-913（ロック競合）の処理が業務要件に適合しているか確認
- [ ] 顧客情報の閲覧権限管理が適切に行われているか確認
