---
generated_at: 2026-01-06 18:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：F020-システム初期化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **セキュリティ制御**：CICSセキュリティ設定の確認が必要
  3. **トランザクションID**：定義確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/src/lgsetup.cbl` - システム初期化プログラム
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CICS RECEIVEでトランザクションデータを受信 | E-01 L128-131 | ○ |
| C-02 | 最大顧客番号のデフォルト値は11 | E-01 L53 | ○ |
| C-03 | GENAERRS TSQを削除 | E-01 L138-140 | ○ |
| C-04 | GENASTRT TSQを削除 | E-01 L142-144 | ○ |
| C-05 | GENASTAT TSQを削除 | E-01 L146-148 | ○ |
| C-06 | GENACNTL TSQを削除・再作成 | E-01 L150-176 | ○ |
| C-07 | 最小顧客番号は1固定 | E-01 L52 | ○ |
| C-08 | GENACUSTNUM Named Counterを再定義 | E-01 L179-187 | ○ |
| C-09 | GENACUSTNUMの初期値は最大顧客番号 | E-01 L185 | ○ |
| C-10 | 業務カウンタは値0で定義 | E-01 L195, etc | ○ |
| C-11 | 約40種類のカウンタを処理 | E-01 L189-516 | ○ |
| C-12 | TSQ削除エラーは無視 | E-01 L139 Resp使用 | ○ |
| C-13 | Counter削除エラーは無視 | E-01 L181 Resp使用 | ○ |
| C-14 | CICS SEND TEXTで結果表示 | E-01 L520-525 | ○ |
| C-15 | CICS RETURNで終了 | E-01 L527-528 | ○ |
| C-16 | カウンタプールはGENA | E-01 L55 | ○ |
| C-17 | GENACNTLに3項目書き込み | E-01 L157-176 | ○ |
| C-18 | 見出しは'**** GENAPP CNTL' | E-01 L44 | ○ |
| C-19 | RECEIVE長さは80バイト | E-01 L28 | ○ |
| C-20 | パフォーマンス要件は5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値：運用マニュアルや性能テスト結果が必要
  - 候補：運用マニュアル / 性能テスト結果
- トランザクションID「LGSF」の定義：CICS CSD定義の確認が必要
- セキュリティ設定：CICSセキュリティ定義の確認が必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 管理者専用機能のセキュリティ設定確認が必要
- 0: 低リスク - 処理ロジックはソースコードで明確に確認可能
- 1: 中リスク - 誤操作による統計情報消失リスク

## 6) レビュアーチェックリスト（最小）
- [ ] トランザクションID「LGSF」がCSD定義されているか確認
- [ ] CICSセキュリティでアクセス制御が設定されているか確認
- [ ] Named Counterプール「GENA」が定義されているか確認
- [ ] 業務カウンタの命名規則と用途が正しいか確認
- [ ] パフォーマンス要件の妥当性を確認
