---
generated_at: 2026-01-06 17:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F021-VSAMファイル顧客取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgicvs01.cbl` - LGICVS01プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `base/src/lgtestc1.cbl` - LGTESTC1プログラムソースコード（呼び出し元）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGICVS01である | E-01 (行17: PROGRAM-ID. LGICVS01) | ○ |
| C-02 | VSAMファイルKSDSCUSTから顧客情報を取得する | E-01 (行199: Exec CICS Read File('KSDSCUST')) | ○ |
| C-03 | GENACNTLキューを使用して顧客番号範囲を管理 | E-01 (行63: STSQ-NAME PIC X(8) Value 'GENACNTL') | ○ |
| C-04 | 初期値は0001000001 | E-01 (行123-124: Move 0001000001 to WS-Cust-Low/High) | ○ |
| C-05 | 乱数生成にFunction Randomを使用 | E-01 (行193-196: Function Random(EIBTASKN)) | ○ |
| C-06 | GTEQ指定でVSAM読み取り | E-01 (行199-206: GTEQ指定) | ○ |
| C-07 | ENQ/DEQで排他制御 | E-01 (行129-131, 189-191: ENQ/DEQ Resource) | ○ |
| C-08 | TSQからLOW CUSTOMER値を読み取り | E-01 (行146-148: Read-Msg-Msg(1:12) = 'LOW CUSTOMER') | ○ |
| C-09 | TSQからHIGH CUSTOMER値を読み取り | E-01 (行150-154: Read-Msg-Msg(1:13) = 'HIGH CUSTOMER') | ○ |
| C-10 | トランザクションコードはLGCF | E-02 (行22: LGCF) | ○ |
| C-11 | COMMエリア経由で結果を返却 | E-01 (行218-222: Move Write-Msg-High To COMMA-Data-High) | ○ |
| C-12 | 画面にテキスト表示も可能 | E-01 (行211-217: EXEC CICS SEND TEXT) | ○ |
| C-13 | KeyLength=10でVSAM読み取り | E-01 (行203: KeyLength(F10)) | ○ |
| C-14 | 関連プログラムにLGTESTC1が含まれる | E-02, E-03 | ○ |
| C-15 | テスト用・自動化用の機能 | E-02 (行22: テスト用・自動化用の顧客番号取得) | ○ |
| C-16 | TSQ存在確認でQIDERR判定 | E-01 (行137: If WS-RESP = DFHRESP(NORMAL)) | ○ |
| C-17 | TSQ初期値書き込みを実行 | E-01 (行163-187: WRITEQ TS QUEUE) | ○ |
| C-18 | システム管理機能分類 | E-02 (行22: システム管理) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] VSAM KSDSCUSTファイルの実際のレコード構造を確認
- [ ] GENACNTLキューの初期化タイミングを確認
- [ ] 同時実行時のENQ/DEQ競合の影響を確認
