---
generated_at: 2026-01-06 17:56:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F022-VSAMファイルポリシー取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipvs01.cbl` - LGIPVS01プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGIPVS01である | E-01 (行13: PROGRAM-ID. LGIPVS01) | ○ |
| C-02 | VSAMファイルKSDSPOLYから情報を取得 | E-01 (行111: Exec CICS Read File('KSDSPOLY')) | ○ |
| C-03 | Generic指定でVSAM読み取り | E-01 (行116: Generic) | ○ |
| C-04 | GTEQ指定でVSAM読み取り | E-01 (行118: GTEQ) | ○ |
| C-05 | KeyLength=11でパーシャルキー検索 | E-01 (行115: KeyLength(F11)) | ○ |
| C-06 | ポリシータイプが1桁 | E-01 (行47: PART-KEY-Type PIC X) | ○ |
| C-07 | 顧客番号が10桁 | E-01 (行48: PART-KEY-Num PIC 9(10)) | ○ |
| C-08 | 出力テキスト"Policy Key=" | E-01 (行39: WRITE-MSG-Text PIC X(11) Value 'Policy Key=') | ○ |
| C-09 | エラー時"Policy Bad="を返却 | E-01 (行123: Move 'Policy Bad=' To Write-Msg-Text) | ○ |
| C-10 | エラー時に番号13を設定 | E-01 (行124-125: Move 13 To WRITE-Msg-CustNum/PolNum) | ○ |
| C-11 | トランザクションコードはLGPF | E-02 (行23: LGPF) | ○ |
| C-12 | COMMエリア経由で結果を返却 | E-01 (行138-140: Move to COMMA-Data) | ○ |
| C-13 | 画面にテキスト表示も可能 | E-01 (行131-136: EXEC CICS SEND TEXT) | ○ |
| C-14 | テスト用・自動化用の機能 | E-02 (行23: テスト用・自動化用のポリシー情報取得) | ○ |
| C-15 | システム管理機能分類 | E-02 (行23: システム管理) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] VSAM KSDSPOLYファイルの実際のレコード構造を確認
- [ ] ポリシータイプコード（M/E/H/C）の定義を確認
- [ ] パーシャルキー検索の動作を確認
