---
generated_at: 2026-01-06 17:57:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F023-トランザクション統計更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgastat1.cbl` - LGASTAT1プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `base/event-bindings/Transaction_Counters.evbind` - イベントバインディング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGASTAT1である | E-01 (行7: PROGRAM-ID. LGASTAT1) | ○ |
| C-02 | イベントコンテナDFHEP.DATA.00001から取得 | E-01 (行26: WS-CHANname1 PIC X(16) value 'DFHEP.DATA.00001') | ○ |
| C-03 | イベントコンテナDFHEP.DATA.00002から取得 | E-01 (行27: WS-CHANname2 PIC X(16) value 'DFHEP.DATA.00002') | ○ |
| C-04 | 名前付きカウンタプールはGENA | E-01 (行52: GENApool PIC X(8) Value 'GENA') | ○ |
| C-05 | 統計TSQはGENASTRT | E-01 (行23: WS-Qname PIC X(8) value 'GENASTRT') | ○ |
| C-06 | 02ACUSを01ACUSに正規化 | E-01 (行122-123: If GENAcounter = '02ACUS' Move '01ACUS') | ○ |
| C-07 | 02ICOM/03ICOM/05ICOMを01ICOMに正規化 | E-01 (行124-126) | ○ |
| C-08 | リターンコード00以外を99に変換 | E-01 (行127: If GENAType Not = '00' Move '99' To GENAtype) | ○ |
| C-09 | カウンタ名形式はGENA+6桁+2桁 | E-01 (行38-42: GENAcount構造) | ○ |
| C-10 | COMMエリアからのフォールバック | E-01 (行93-98: Move CA-REQUEST-ID/CA-RETURN-CODE) | ○ |
| C-11 | EIBCALEN=0でRETURN | E-01 (行93-94: IF EIBCALEN IS EQUAL TO ZERO EXEC CICS RETURN) | ○ |
| C-12 | TSQ存在確認でQIDERR判定 | E-01 (行106: If WS-RESP = DFHRESP(QIDERR)) | ○ |
| C-13 | TSQ初期化で日時情報を書き込み | E-01 (行107-119: ASKTIME/FORMATTIME/WRITEQ) | ○ |
| C-14 | Get Counterで値を取得 | E-01 (行129-133: Exec CICS Get Counter) | ○ |
| C-15 | トランザクションコードはLGST | E-02 (行24: LGST) | ○ |
| C-16 | イベントアダプタトリガーによる統計収集 | E-02 (行24: イベントアダプタトリガーによる統計収集) | ○ |
| C-17 | システム管理機能分類 | E-02 (行24: システム管理) | ○ |
| C-18 | GENAOTHERカウンタ名 | E-01 (行54: GENAOTHER PIC X(9) Value 'GENAOTHER') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] イベントバインディング定義（Transaction_Counters.evbind）の設定を確認
- [ ] 名前付きカウンタサーバーの設定を確認
- [ ] GENASTRTキューの初期化タイミングを確認
