---
generated_at: 2026-01-06 17:58:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F024-統計データ収集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgwebst5.cbl` - LGWEBST5プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGWEBST5である | E-01 (行11: PROGRAM-ID. LGWEBST5) | ○ |
| C-02 | 名前付きカウンタプールはGENA | E-01 (行198: GENApool PIC X(8) Value 'GENA') | ○ |
| C-03 | TSQプレフィックスはGENA | E-01 (行47: TSQpre Pic X(4)) | ○ |
| C-04 | 60秒間隔で再スケジュール | E-01 (行761-765: Start Transid('SSST') After Minutes(1)) | ○ |
| C-05 | トランザクションコードはSSST | E-01 (行761: Transid('SSST')), E-02 (行25: SSST) | ○ |
| C-06 | 顧客照会カウンタGENA01ICUS00 | E-01 (行199: GENACNT100 PIC X(16) Value 'GENA01ICUS00') | ○ |
| C-07 | 顧客照会エラーGENA01ICUS99 | E-01 (行200: GENACNT199 PIC X(32) Value 'GENA01ICUS99') | ○ |
| C-08 | 顧客登録カウンタGENA01ACUS00 | E-01 (行201: GENACNT200 PIC X(16) Value 'GENA01ACUS00') | ○ |
| C-09 | 自動車保険照会カウンタ | E-01 (行203-204) | ○ |
| C-10 | 成功/エラー件数の集計 | E-01 (行670-673: CountSuccess/Counterrors) | ○ |
| C-11 | 経過時間計算ロジック | E-01 (行742-751: 時*3600+分*60+秒の計算) | ○ |
| C-12 | TSQ初期値120秒 | E-01 (行727: Move '120000' To WS-OLDV) | ○ |
| C-13 | Query Counterで値取得 | E-01 (行268-272: Exec CICS Query Counter) | ○ |
| C-14 | TSQ構造（現在値、前回値、差分） | E-01 (行782-800: Tran-Rate-Counts処理) | ○ |
| C-15 | APPLID取得 | E-01 (行703-705: EXEC CICS ASSIGN APPLID) | ○ |
| C-16 | GENAOTHERカウンタ | E-01 (行233: GENACNTI99 PIC X(16) Value 'GENAOTHER') | ○ |
| C-17 | システム管理機能分類 | E-02 (行25: システム管理) | ○ |
| C-18 | 照会/登録/更新/削除の集計 | E-01 (行683-699: CountInq/CountAdd/CountUpd/CountDel) | ○ |
| C-19 | 養老保険カウンタ群 | E-01 (行211-218) | ○ |
| C-20 | 住宅保険カウンタ群 | E-01 (行219-226) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 60秒間隔の再スケジュールが正常に動作することを確認
- [ ] 名前付きカウンタサーバーの設定を確認
- [ ] TSQの容量・保持期間を確認
