---
generated_at: 2026-01-06 17:59:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F025-エラーメッセージ記録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgstsq.cbl` - LGSTSQプログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGSTSQである | E-01 (行10: PROGRAM-ID. LGSTSQ) | ○ |
| C-02 | デフォルトキュー名はGENAERRS | E-01 (行82: MOVE 'GENAERRS' TO STSQ-NAME) | ○ |
| C-03 | TDQ CSMTに書き込み | E-01 (行40: STDQ-NAME PIC X(4) VALUE 'CSMT', 行94-99: WRITEQ TD) | ○ |
| C-04 | Q=形式でキュー名指定可能 | E-01 (行83-88: IF WRITE-MSG-MSG(1:2) = 'Q=') | ○ |
| C-05 | SYSIDを付加 | E-01 (行60-62: EXEC CICS ASSIGN SYSID) | ○ |
| C-06 | TSQ書き込みはNOSUSPEND | E-01 (行108: NOSUSPEND) | ○ |
| C-07 | COMMエリアからメッセージ取得 | E-01 (行70: MOVE COMMA-DATA TO WRITE-MSG-MSG) | ○ |
| C-08 | RECEIVEでメッセージ取得 | E-01 (行73-79: EXEC CICS RECEIVE) | ○ |
| C-09 | Invokingprogで呼び出し方法判定 | E-01 (行64-66: EXEC CICS ASSIGN INVOKINGPROG) | ○ |
| C-10 | 直接実行時は画面にスペース表示 | E-01 (行113-119: EXEC CICS SEND TEXT FROM(FILLER-X)) | ○ |
| C-11 | メッセージ最大90文字 | E-01 (行28: WRITE-MSG-MSG PIC X(90)) | ○ |
| C-12 | キュー名4文字サフィックス | E-01 (行84: MOVE WRITE-MSG-MSG(3:4) TO STSQ-EXT) | ○ |
| C-13 | TSQへのWRITEQ TS | E-01 (行105-111: EXEC CICS WRITEQ TS QUEUE) | ○ |
| C-14 | システム管理機能分類 | E-02 (行26: システム管理) | ○ |
| C-15 | GENAERRSキューにエラー情報を格納 | E-02 (行26: GENAERRSキューにエラー情報を格納) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CSMT TDQの定義・設定を確認
- [ ] GENAERRSキューの容量・保持期間を確認
- [ ] エラーログに機密情報が含まれていないことを確認
