---
generated_at: 2026-01-06 18:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F026-顧客メニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgtestc1.cbl` - LGTESTC1プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGTESTC1である | E-01 (行11: PROGRAM-ID. LGTESTC1) | ○ |
| C-02 | 画面マップはSSMAPC1 | E-01 (行64-68: SEND MAP ('SSMAPC1')) | ○ |
| C-03 | マップセットはSSMAP | E-01 (行66: MAPSET ('SSMAP')) | ○ |
| C-04 | トランザクションコードはSSC1 | E-01 (行232: TRANSID('SSC1')) | ○ |
| C-05 | オプション1で顧客照会 | E-01 (行86-111: WHEN '1', LINK PROGRAM('LGICUS01')) | ○ |
| C-06 | オプション2で顧客登録 | E-01 (行113-146: WHEN '2', LINK PROGRAM('LGACUS01')) | ○ |
| C-07 | オプション4で顧客更新 | E-01 (行148-207: WHEN '4', LINK PROGRAM('LGUCUS01')) | ○ |
| C-08 | COMMエリア長32500 | E-01 (行90-91: COMMAREA(COMM-AREA) LENGTH(32500)) | ○ |
| C-09 | 登録失敗時ロールバック | E-01 (行133: Exec CICS Syncpoint Rollback End-Exec) | ○ |
| C-10 | GENACNTL TSQ更新 | E-01 (行137: Perform WRITE-GENACNTL, 行283-347) | ○ |
| C-11 | 郵便番号大文字変換 | E-01 (行126-127: Move Function UPPER-CASE(CA-POSTCODE)) | ○ |
| C-12 | PF3で終了 | E-01 (行73: PF3(ENDIT)) | ○ |
| C-13 | CLEARで画面クリア | E-01 (行73: CLEAR(CLEARIT)) | ○ |
| C-14 | 初回判定EIBCALEN | E-01 (行55-56: IF EIBCALEN > 0 GO TO A-GAIN) | ○ |
| C-15 | ENQ/DEQでTSQ排他制御 | E-01 (行285-287, 343-345) | ○ |
| C-16 | 照会エラー時NO-DATA | E-01 (行267-269: Move 'No data was returned.') | ○ |
| C-17 | 登録エラー時NO-ADD | E-01 (行263-265: Move 'Error Adding Customer') | ○ |
| C-18 | 更新エラー時NO-UPD | E-01 (行259-261: Move 'Error Updating Customer') | ○ |
| C-19 | 画面機能分類 | E-02 (行27: 画面) | ○ |
| C-20 | 画面機能マッピング | E-03 (行2-5: 顧客メニュー画面とF001,F002,F003,F026の関連) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] BMS画面定義（SSMAPC1）の内容を確認
- [ ] 顧客情報の入力バリデーションを確認
- [ ] GENACNTLキューの排他制御が正しく動作することを確認
