---
generated_at: 2026-01-06 18:01:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F027-自動車保険メニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgtestp1.cbl` - LGTESTP1プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGTESTP1である | E-01 (行11: PROGRAM-ID. LGTESTP1) | ○ |
| C-02 | 画面マップはSSMAPP1 | E-01 (行47-50: SEND MAP ('SSMAPP1')) | ○ |
| C-03 | マップセットはSSMAP | E-01 (行48: MAPSET ('SSMAP')) | ○ |
| C-04 | トランザクションコードはSSP1 | E-01 (行259: TRANSID('SSP1')) | ○ |
| C-05 | オプション1でポリシー照会 | E-01 (行68-95: WHEN '1', LINK PROGRAM('LGIPOL01')) | ○ |
| C-06 | オプション2でポリシー登録 | E-01 (行97-133: WHEN '2', LINK PROGRAM('LGAPOL01')) | ○ |
| C-07 | オプション3でポリシー削除 | E-01 (行135-167: WHEN '3', LINK PROGRAM('LGDPOL01')) | ○ |
| C-08 | オプション4でポリシー更新 | E-01 (行169-234: WHEN '4', LINK PROGRAM('LGUPOL01')) | ○ |
| C-09 | リクエストID 01IMOT（照会） | E-01 (行69: Move '01IMOT' To CA-REQUEST-ID) | ○ |
| C-10 | リクエストID 01AMOT（登録） | E-01 (行98: Move '01AMOT' To CA-REQUEST-ID) | ○ |
| C-11 | リクエストID 01DMOT（削除） | E-01 (行136: Move '01DMOT' To CA-REQUEST-ID) | ○ |
| C-12 | リクエストID 01UMOT（更新） | E-01 (行200: Move '01UMOT' To CA-REQUEST-ID) | ○ |
| C-13 | 登録/削除失敗時ロールバック | E-01 (行120, 144: Exec CICS Syncpoint Rollback) | ○ |
| C-14 | エラーコード70で顧客不存在 | E-01 (行287-290: When 70 'Customer does not exist') | ○ |
| C-15 | COMMエリア長32500 | E-01 (行73-74: COMMAREA(COMM-AREA) LENGTH(32500)) | ○ |
| C-16 | PF3で終了 | E-01 (行56: PF3(ENDIT)) | ○ |
| C-17 | 画面機能分類 | E-02 (行28: 画面) | ○ |
| C-18 | 画面機能マッピング | E-03 (行6-10: 自動車保険ポリシーメニュー画面とF004-F007,F027の関連) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] BMS画面定義（SSMAPP1）の内容を確認
- [ ] 自動車保険固有項目（車両情報等）の入力バリデーションを確認
- [ ] 各業務プログラム（LGIPOL01等）との連携を確認
