---
generated_at: 2026-01-06 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F003-顧客更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgucus01.cbl` - 顧客更新ビジネスロジック
- E-02: `base/src/lgucdb01.cbl` - Db2顧客データ更新
- E-03: `base/src/lgucvs01.cbl` - VSAM顧客データ更新
- E-04: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGUCUS01がビジネスロジック層として機能する | E-01 L116: PERFORM UPDATE-CUSTOMER-INFO, L128: EXEC CICS LINK Program(LGUCDB01) | ○ |
| C-02 | LGUCDB01がDb2の顧客データ更新を行う | E-02 L152-181: UPDATE-CUSTOMER-INFO セクション | ○ |
| C-03 | リクエストID'01UCUS'の検証を行う | E-01 L110-113: If CA-REQUEST-ID NOT = '01UCUS' MOVE '99' TO CA-RETURN-CODE | ○ |
| C-04 | CUSTOMERテーブルの9項目をUPDATE | E-02 L155-169: UPDATE CUSTOMER SET FIRSTNAME, LASTNAME, ... | ○ |
| C-05 | 顧客番号をキーにWHERE条件を設定 | E-02 L168: WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT | ○ |
| C-06 | LGUCVS01を呼び出してVSAMを更新 | E-02 L136-139: EXEC CICS LINK Program(LGUCVS01) | ○ |
| C-07 | VSAMファイルをREAD FOR UPDATEで読み込み | E-03 L69-76: Exec CICS Read File('KSDSCUST') ... Update | ○ |
| C-08 | VSAMファイルをREWRITEで更新 | E-03 L85-89: Exec CICS ReWrite File('KSDSCUST') | ○ |
| C-09 | COMMAREAなしでABEND('LGCA')発生 | E-01 L99-103: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-10 | VSAMリードエラーで'81'とABEND('LGV1') | E-03 L77-83: MOVE '81' TO CA-RETURN-CODE ... EXEC CICS ABEND ABCODE('LGV1') | ○ |
| C-11 | VSAMリライトエラーで'82'とABEND('LGV2') | E-03 L90-96: MOVE '82' TO CA-RETURN-CODE ... EXEC CICS ABEND ABCODE('LGV2') | ○ |
| C-12 | SQLCODE=100でデータなし'01' | E-02 L173-174: IF SQLCODE EQUAL 100 MOVE '01' TO CA-RETURN-CODE | ○ |
| C-13 | その他SQLエラーで'90' | E-02 L175-179: ELSE MOVE '90' TO CA-RETURN-CODE | ○ |
| C-14 | エラー時にLGSTSQプログラムでログ出力 | E-01 L152-155: EXEC CICS LINK PROGRAM('LGSTSQ') | ○ |
| C-15 | トランザクションIDはSSC1 | E-05 行4: SSC1 | ○ |
| C-16 | 画面No.1からオプション4で呼び出し | E-06 行4: 顧客メニュー画面, F003, オプション4選択時 | ○ |
| C-17 | リクエストID不正で'99'エラー | E-01 L111: MOVE '99' TO CA-RETURN-CODE | ○ |
| C-18 | VSAM書込のレコードサイズは225バイト | E-03 L50: CUSTOMER-RECORD-SIZE PIC S9(4) BINARY VALUE 0225 | ○ |
| C-19 | 顧客番号をDB2-CUSTOMERNUM-INTに変換 | E-02 L129: MOVE CA-CUSTOMER-NUM TO DB2-CUSTOMERNUM-INT | ○ |
| C-20 | CA-NUM-POLICIESを'00'で初期化 | E-01 L106: MOVE '00' TO CA-NUM-POLICIES | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - Db2とVSAMの二重更新による整合性維持の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Db2とVSAMの更新順序と障害時の整合性維持が適切か確認
- [ ] ABEND発生時のロールバック範囲が業務要件に適合しているか確認
- [ ] 更新前の照会（F002）実行が運用手順に含まれているか確認
