---
generated_at: 2026-01-06 18:04:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F030-商業用不動産保険メニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgtestp4.cbl` - LGTESTP4プログラムソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プログラム名はLGTESTP4である | E-01 (行11: PROGRAM-ID. LGTESTP4) | ○ |
| C-02 | 画面マップはSSMAPP4 | E-01 (行52-55: SEND MAP ('SSMAPP4')) | ○ |
| C-03 | マップセットはSSMAP | E-01 (行53: MAPSET ('SSMAP')) | ○ |
| C-04 | トランザクションコードはSSP4 | E-01 (行259: TRANSID('SSP4')) | ○ |
| C-05 | オプション1でポリシー照会 | E-01 (行73-154: WHEN '1', LINK PROGRAM('LGIPOL01')) | ○ |
| C-06 | オプション2でポリシー登録 | E-01 (行156-195: WHEN '2', LINK PROGRAM('LGAPOL01')) | ○ |
| C-07 | オプション3でポリシー削除 | E-01 (行197-234: WHEN '3', LINK PROGRAM('LGDPOL01')) | ○ |
| C-08 | 更新機能（オプション4）なし | E-01 (オプション4の処理ブロックが存在しない) | ○ |
| C-09 | リクエストID 01ICOM（顧客+ポリシー照会） | E-01 (行87: Move '01ICOM' To CA-REQUEST-ID) | ○ |
| C-10 | リクエストID 02ICOM（ポリシーのみ照会） | E-01 (行97-98: Move '02ICOM' To CA-REQUEST-ID) | ○ |
| C-11 | リクエストID 03ICOM（顧客のみ照会） | E-01 (行106-107: Move '03ICOM' To CA-REQUEST-ID) | ○ |
| C-12 | リクエストID 05ICOM（郵便番号照会） | E-01 (行115-116: Move '05ICOM' To CA-REQUEST-ID) | ○ |
| C-13 | リクエストID 01ACOM（登録） | E-01 (行157: Move '01ACOM' To CA-REQUEST-ID) | ○ |
| C-14 | リクエストID 01DCOM（削除） | E-01 (行198: Move '01DCOM' To CA-REQUEST-ID) | ○ |
| C-15 | 登録/削除失敗時ロールバック | E-01 (行183, 206: Exec CICS Syncpoint Rollback) | ○ |
| C-16 | エラーコード70で顧客不存在 | E-01 (行287-290: When 70 'Customer does not exist') | ○ |
| C-17 | COMMエリア長32500 | E-01 (行122-123: COMMAREA(COMM-AREA) LENGTH(32500)) | ○ |
| C-18 | PF3で終了 | E-01 (行61: PF3(ENDIT)) | ○ |
| C-19 | 画面機能分類 | E-02 (行31: 画面) | ○ |
| C-20 | 画面機能マッピング | E-03 (行21-24: 商業用不動産保険ポリシーメニュー画面とF016,F017,F019,F030の関連) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] BMS画面定義（SSMAPP4）の内容を確認
- [ ] 商業用不動産保険固有項目（リスク情報等）の入力バリデーションを確認
- [ ] 複数検索条件（01ICOM/02ICOM/03ICOM/05ICOM）の動作を確認
- [ ] 更新機能が不要な業務要件であることを確認
