---
generated_at: 2026-01-06 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F004-自動車保険登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgapol01.cbl` - ポリシー追加ビジネスロジック
- E-02: `base/src/lgapdb01.cbl` - Db2ポリシーデータ登録
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `base/src/lgpolicy.cpy` - ポリシー長さ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGAPOL01がビジネスロジック層として機能する | E-01 L121-124: EXEC CICS Link Program(LGAPDB01) | ○ |
| C-02 | リクエストID'01AMOT'で自動車保険を識別 | E-02 L195-196: WHEN '01AMOT' ... MOVE 'M' TO DB2-POLICYTYPE | ○ |
| C-03 | ポリシータイプ'M'をPOLICYTYPEに設定 | E-02 L196: MOVE 'M' TO DB2-POLICYTYPE | ○ |
| C-04 | COMMAREAなしでABEND('LGCA')発生 | E-01 L98-101: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-05 | COMMAREA長さ不足で'98'エラー | E-01 L113-116: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN MOVE '98' | ○ |
| C-06 | 不正なリクエストIDで'99'エラー | E-02 L203-205: WHEN OTHER MOVE '99' TO CA-RETURN-CODE | ○ |
| C-07 | POLICYテーブルに9項目をINSERT | E-02 L268-288: INSERT INTO POLICY (POLICYNUMBER, CUSTOMERNUMBER, ...) | ○ |
| C-08 | IDENTITY_VAL_LOCAL()でポリシー番号取得 | E-02 L308-311: SET :DB2-POLICYNUM-INT = IDENTITY_VAL_LOCAL() | ○ |
| C-09 | MOTORテーブルに10項目をINSERT | E-02 L449-471: INSERT INTO MOTOR (POLICYNUMBER, MAKE, MODEL, ...) | ○ |
| C-10 | SQLCODE=-530で外部キー違反'70' | E-02 L295-298: When -530 MOVE '70' TO CA-RETURN-CODE | ○ |
| C-11 | その他SQLエラーで'90' | E-02 L300-303: When Other MOVE '90' TO CA-RETURN-CODE | ○ |
| C-12 | MOTORテーブルINSERT失敗でABEND('LGSQ') | E-02 L477-478: EXEC CICS ABEND ABCODE('LGSQ') | ○ |
| C-13 | LGAPVS01を呼び出してVSAMに登録 | E-02 L243-246: EXEC CICS Link Program(LGAPVS01) | ○ |
| C-14 | CURRENT TIMESTAMPで最終更新日時設定 | E-02 L284: LASTCHANGED, ... VALUES ... CURRENT TIMESTAMP | ○ |
| C-15 | 自動車保険データ長は137バイト | E-04 L26: 03 WS-FULL-MOTOR-LEN PIC S9(4) COMP VALUE +137 | ○ |
| C-16 | ヘッダー長は28バイト | E-01 L59: 03 WS-CA-HEADER-LEN PIC S9(4) COMP VALUE +28 | ○ |
| C-17 | トランザクションIDはSSC1 | E-05 行5: SSC1 | ○ |
| C-18 | 画面No.6からPF4で呼び出し | E-06 行5: 自動車保険追加画面, F004, PF4キー押下時 | ○ |
| C-19 | DB2-M-VALUE-INTに車両価値を変換 | E-02 L443: MOVE CA-M-VALUE TO DB2-M-VALUE-INT | ○ |
| C-20 | DB2-M-CC-SINTに排気量を変換 | E-02 L444: MOVE CA-M-CC TO DB2-M-CC-SINT | ○ |
| C-21 | DB2-M-PREMIUM-INTに保険料を変換 | E-02 L445: MOVE CA-M-PREMIUM TO DB2-M-PREMIUM-INT | ○ |
| C-22 | DB2-M-ACCIDENTS-INTに事故件数を変換 | E-02 L446: MOVE CA-M-ACCIDENTS TO DB2-M-ACCIDENTS-INT | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - POLICY/MOTORの二段階INSERTによるトランザクション整合性の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 外部キー違反（SQLCODE=-530）の処理が業務要件に適合しているか確認
- [ ] ABEND('LGSQ')によるロールバック範囲が適切か確認
- [ ] 車両価値・保険料の数値変換が正確か確認
