---
generated_at: 2026-01-06 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F005-自動車保険照会

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgipol01.cbl` - ポリシー照会ビジネスロジック
- E-02: `base/src/lgipdb01.cbl` - Db2ポリシーデータ取得
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `base/src/lgpolicy.cpy` - ポリシー長さ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGIPOL01がビジネスロジック層として機能する | E-01 L91-94: EXEC CICS LINK Program(LGIPDB01) | ○ |
| C-02 | リクエストID'01IMOT'で自動車保険照会を識別 | E-02 L287-289: WHEN '01IMOT' ... PERFORM GET-MOTOR-DB2-INFO | ○ |
| C-03 | COMMAREAなしでABEND('LGCA')発生 | E-01 L79-83: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-04 | POLICY/MOTOR JOIN SELECTで15項目取得 | E-02 L532-570: SELECT ISSUEDATE, ... FROM POLICY,MOTOR WHERE | ○ |
| C-05 | 顧客番号でWHERE条件を設定 | E-02 L566-567: POLICY.CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT | ○ |
| C-06 | ポリシー番号でWHERE条件を設定 | E-02 L568-569: POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT | ○ |
| C-07 | SQLCODE=0で正常処理 | E-02 L572: IF SQLCODE = 0 | ○ |
| C-08 | SQLCODE=100でデータなし'01' | E-02 L610-612: IF SQLCODE EQUAL 100 MOVE '01' TO CA-RETURN-CODE | ○ |
| C-09 | その他SQLエラーで'90' | E-02 L613-617: ELSE MOVE '90' TO CA-RETURN-CODE | ○ |
| C-10 | COMMAREA長さ不足で'98'エラー | E-02 L581-583: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN MOVE '98' | ○ |
| C-11 | データ終端に'FINAL'マーク設定 | E-02 L606: MOVE 'FINAL' TO CA-M-FILLER(1:5) | ○ |
| C-12 | BROKERIDはNULL許容（インジケータ使用） | E-02 L551: :DB2-BROKERID-INT INDICATOR :IND-BROKERID | ○ |
| C-13 | 自動車保険完全データ長は137バイト | E-04 L26: 03 WS-FULL-MOTOR-LEN PIC S9(4) COMP VALUE +137 | ○ |
| C-14 | ヘッダー・トレーラー長は33バイト | E-02 L73: 03 WS-CA-HEADERTRAILER-LEN PIC S9(4) COMP VALUE +33 | ○ |
| C-15 | トランザクションIDはSSC1 | E-05 行6: SSC1 | ○ |
| C-16 | 画面No.7からPF5で呼び出し | E-06 行6: 自動車保険詳細画面, F005, PF5キー押下時 | ○ |
| C-17 | DB2-M-CC-SINTからDB2-M-CCへ変換 | E-02 L594: MOVE DB2-M-CC-SINT TO DB2-M-CC | ○ |
| C-18 | DB2-M-VALUE-INTからDB2-M-VALUEへ変換 | E-02 L595: MOVE DB2-M-VALUE-INT TO DB2-M-VALUE | ○ |
| C-19 | DB2-M-PREMIUM-INTからCA-M-PREMIUMへ変換 | E-02 L598: MOVE DB2-M-PREMIUM-INT TO CA-M-PREMIUM | ○ |
| C-20 | DB2-M-ACCIDENTS-INTからCA-M-ACCIDENTSへ変換 | E-02 L599: MOVE DB2-M-ACCIDENTS-INT TO CA-M-ACCIDENTS | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高く、単純な参照処理のため

## 6) レビュアーチェックリスト（最小）
- [ ] NULL値処理（インジケータ変数）が適切に行われているか確認
- [ ] データ終端マーク'FINAL'の位置が正しいか確認
