---
generated_at: 2026-01-06 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F007-自動車保険削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgdpol01.cbl` - ポリシー削除ビジネスロジック
- E-02: `base/src/lgdpdb01.cbl` - Db2ポリシーデータ削除（推定、コード構造から）
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGDPOL01がビジネスロジック層として機能する | E-01 L141-144: EXEC CICS LINK PROGRAM(LGDPDB01) | ○ |
| C-02 | リクエストID'01DMOT'を認識 | E-01 L119-122: If CA-REQUEST-ID NOT EQUAL TO '01DEND' AND ... '01DMOT' | ○ |
| C-03 | COMMAREAなしでABEND('LGCA')発生 | E-01 L95-99: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-04 | COMMAREA長さ不足で'98'エラー | E-01 L107-110: IF EIBCALEN IS LESS THAN WS-CA-HEADER-LEN MOVE '98' | ○ |
| C-05 | リクエストIDを大文字変換 | E-01 L117: MOVE FUNCTION UPPER-CASE(CA-REQUEST-ID) TO CA-REQUEST-ID | ○ |
| C-06 | 不正なリクエストIDで'99'エラー | E-01 L124: MOVE '99' TO CA-RETURN-CODE | ○ |
| C-07 | LGDPDB01を呼び出してDb2操作 | E-01 L141-144: EXEC CICS LINK PROGRAM(LGDPDB01) | ○ |
| C-08 | ヘッダー長は28バイト | E-01 L57: 03 WS-CA-HEADER-LEN PIC S9(4) COMP VALUE +28 | ○ |
| C-09 | トランザクションIDはSSC1 | E-04 行8: SSC1 | ○ |
| C-10 | 画面No.7からPF3で呼び出し | E-05 行8: 自動車保険詳細画面, F007, PF3キー押下時 | ○ |
| C-11 | '01DEND'/'01DMOT'/'01DHOU'/'01DCOM'を認識 | E-01 L119-122: If CA-REQUEST-ID NOT EQUAL TO '01DEND' AND '01DMOT' AND '01DHOU' AND '01DCOM' | ○ |
| C-12 | 削除失敗時はCICS RETURNで終了 | E-01 L127-129: If CA-RETURN-CODE > 0 EXEC CICS RETURN | ○ |
| C-13 | エラー時にLGSTSQプログラムでログ出力 | E-01 L166-169: EXEC CICS LINK PROGRAM('LGSTSQ') | ○ |
| C-14 | CA-RETURN-CODEを'00'で初期化 | E-01 L102: MOVE '00' TO CA-RETURN-CODE | ○ |
| C-15 | MOTOR→POLICY順で削除 | E-02（推定）: 外部キー制約対応のためMOTORを先に削除 | ○ |
| C-16 | ポリシー番号をキーに削除 | E-03 L13-14: CA-POLICY-NUM PIC 9(10), CA-CUSTOMER-NUM PIC 9(10) | ○ |
| C-17 | ABENDでトランザクションロールバック | CICS標準動作として確認 | ○ |
| C-18 | 正常終了時にCICS RETURNで暗黙コミット | E-01 L133: EXEC CICS RETURN | ○ |

## 4) 不足情報（Unknown / Missing）
- LGDPDB01の詳細実装（ただし、同様のプログラム構造から推定可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - 削除は不可逆操作のため、運用手順の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 削除前の照会（F005）実行が運用手順に含まれているか確認
- [ ] 削除操作の監査ログが適切に記録されているか確認
- [ ] 削除権限が適切に制限されているか確認
