---
generated_at: 2026-01-06 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F008-養老保険登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgapol01.cbl` - ポリシー追加ビジネスロジック
- E-02: `base/src/lgapdb01.cbl` - Db2ポリシーデータ登録
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `base/src/lgpolicy.cpy` - ポリシー長さ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGAPOL01がビジネスロジック層として機能する | E-01 L121-124: EXEC CICS Link Program(LGAPDB01) | ○ |
| C-02 | リクエストID'01AEND'で養老保険を識別 | E-02 L186-188: WHEN '01AEND' ... MOVE 'E' TO DB2-POLICYTYPE | ○ |
| C-03 | ポリシータイプ'E'をPOLICYTYPEに設定 | E-02 L188: MOVE 'E' TO DB2-POLICYTYPE | ○ |
| C-04 | COMMAREAなしでABEND('LGCA')発生 | E-01 L98-101: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-05 | POLICYテーブルに9項目をINSERT | E-02 L268-288: INSERT INTO POLICY (POLICYNUMBER, CUSTOMERNUMBER, ...) | ○ |
| C-06 | IDENTITY_VAL_LOCAL()でポリシー番号取得 | E-02 L308-311: SET :DB2-POLICYNUM-INT = IDENTITY_VAL_LOCAL() | ○ |
| C-07 | ENDOWMENTテーブルに8-9項目をINSERT | E-02 L347-386: INSERT INTO ENDOWMENT (POLICYNUMBER, WITHPROFITS, ...) | ○ |
| C-08 | VARCHAR長を計算 | E-02 L339-340: SUBTRACT WS-REQUIRED-CA-LEN FROM EIBCALEN GIVING WS-VARY-LEN | ○ |
| C-09 | VARCHARデータあり時はPADDINGDATA含めてINSERT | E-02 L342-366: IF WS-VARY-LEN IS GREATER THAN ZERO ... INSERT ... PADDINGDATA | ○ |
| C-10 | VARCHARデータなし時はPADDINGDATA除いてINSERT | E-02 L367-386: ELSE ... INSERT without PADDINGDATA | ○ |
| C-11 | SQLCODE=-530で外部キー違反'70' | E-02 L295-298: When -530 MOVE '70' TO CA-RETURN-CODE | ○ |
| C-12 | その他SQLエラーで'90' | E-02 L300-303: When Other MOVE '90' TO CA-RETURN-CODE | ○ |
| C-13 | ENDOWMENTテーブルINSERT失敗でABEND('LGSQ') | E-02 L393: EXEC CICS ABEND ABCODE('LGSQ') | ○ |
| C-14 | LGAPVS01を呼び出してVSAMに登録 | E-02 L243-246: EXEC CICS Link Program(LGAPVS01) | ○ |
| C-15 | CURRENT TIMESTAMPで最終更新日時設定 | E-02 L284: LASTCHANGED, ... VALUES ... CURRENT TIMESTAMP | ○ |
| C-16 | 養老保険データ長は124バイト | E-04 L24: 03 WS-FULL-ENDOW-LEN PIC S9(4) COMP VALUE +124 | ○ |
| C-17 | PADDINGDATAは最大32611バイト | E-04 L62: 03 DB2-E-PADDINGDATA PIC X(32611) | ○ |
| C-18 | トランザクションIDはSSC1 | E-05 行9: SSC1 | ○ |
| C-19 | 画面No.3からPF4で呼び出し | E-06 行9: 養老保険追加画面, F008, PF4キー押下時 | ○ |
| C-20 | DB2-E-TERM-SINTに保険期間を変換 | E-02 L330: MOVE CA-E-TERM TO DB2-E-TERM-SINT | ○ |
| C-21 | DB2-E-SUMASSURED-INTに保険金額を変換 | E-02 L331: MOVE CA-E-SUM-ASSURED TO DB2-E-SUMASSURED-INT | ○ |
| C-22 | ヘッダー長は28バイト | E-01 L59: 03 WS-CA-HEADER-LEN PIC S9(4) COMP VALUE +28 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - VARCHAR（PADDINGDATA）の大きなサイズ使用時のパフォーマンス確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] VARCHAR（PADDINGDATA）の使用方法が業務要件に適合しているか確認
- [ ] 大きなVARCHARデータ使用時のパフォーマンス影響を確認
- [ ] 外部キー違反（SQLCODE=-530）の処理が業務要件に適合しているか確認
