---
generated_at: 2026-01-06 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：F009-養老保険照会

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/lgipol01.cbl` - ポリシー照会ビジネスロジック
- E-02: `base/src/lgipdb01.cbl` - Db2ポリシーデータ取得
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義
- E-04: `base/src/lgpolicy.cpy` - ポリシー長さ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGIPOL01がビジネスロジック層として機能する | E-01 L91-94: EXEC CICS LINK Program(LGIPDB01) | ○ |
| C-02 | リクエストID'01IEND'で養老保険照会を識別 | E-02 L279-281: WHEN '01IEND' ... PERFORM GET-ENDOW-DB2-INFO | ○ |
| C-03 | リクエストIDをUPPER-CASEで変換 | E-02 L275: MOVE FUNCTION UPPER-CASE(CA-REQUEST-ID) TO WS-REQUEST-ID | ○ |
| C-04 | COMMAREAなしでABEND('LGCA')発生 | E-01 L79-83: IF EIBCALEN IS EQUAL TO ZERO ... EXEC CICS ABEND ABCODE('LGCA') | ○ |
| C-05 | POLICY/ENDOWMENT JOIN SELECTで15項目+LENGTH取得 | E-02 L329-368: SELECT ISSUEDATE, ... PADDINGDATA, LENGTH(PADDINGDATA) | ○ |
| C-06 | 顧客番号でWHERE条件を設定 | E-02 L364-365: POLICY.CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT | ○ |
| C-07 | ポリシー番号でWHERE条件を設定 | E-02 L366-367: POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT | ○ |
| C-08 | SQLCODE=0で正常処理 | E-02 L370: IF SQLCODE = 0 | ○ |
| C-09 | SQLCODE=100でデータなし'01' | E-02 L421-423: IF SQLCODE EQUAL 100 MOVE '01' TO CA-RETURN-CODE | ○ |
| C-10 | その他SQLエラーで'90' | E-02 L424-428: ELSE MOVE '90' TO CA-RETURN-CODE | ○ |
| C-11 | COMMAREA長さ不足で'98'エラー | E-02 L390-392: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN MOVE '98' | ○ |
| C-12 | データ終端に'FINAL'マーク設定 | E-02 L417: MOVE 'FINAL' TO CA-E-PADDING-DATA(END-POLICY-POS:5) | ○ |
| C-13 | BROKERIDはNULL許容（インジケータ使用） | E-02 L349: :DB2-BROKERID-INT INDICATOR :IND-BROKERID | ○ |
| C-14 | PADDINGDATAはNULL許容（インジケータ使用） | E-02 L359: :DB2-E-PADDINGDATA INDICATOR :IND-E-PADDINGDATA | ○ |
| C-15 | LENGTH(PADDINGDATA)を取得 | E-02 L360: :DB2-E-PADDING-LEN INDICATOR :IND-E-PADDINGDATAL | ○ |
| C-16 | VARCHAR長をCOMMAREA長検証に使用 | E-02 L383-385: IF IND-E-PADDINGDATAL NOT EQUAL MINUS-ONE ADD DB2-E-PADDING-LEN | ○ |
| C-17 | 養老保険完全データ長は124バイト | E-04 L24: 03 WS-FULL-ENDOW-LEN PIC S9(4) COMP VALUE +124 | ○ |
| C-18 | ヘッダー・トレーラー長は33バイト | E-02 L73: 03 WS-CA-HEADERTRAILER-LEN PIC S9(4) COMP VALUE +33 | ○ |
| C-19 | トランザクションIDはSSC1 | E-05 行10: SSC1 | ○ |
| C-20 | 画面No.4からPF5で呼び出し | E-06 行10: 養老保険詳細画面, F009, PF5キー押下時 | ○ |
| C-21 | DB2-E-TERM-SINTからDB2-E-TERMへ変換 | E-02 L404: MOVE DB2-E-TERM-SINT TO DB2-E-TERM | ○ |
| C-22 | DB2-E-SUMASSURED-INTからDB2-E-SUMASSUREDへ変換 | E-02 L405: MOVE DB2-E-SUMASSURED-INT TO DB2-E-SUMASSURED | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い
- 1: 中リスク - 大きなVARCHARデータ取得時のパフォーマンス確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] NULL値処理（インジケータ変数）が適切に行われているか確認
- [ ] データ終端マーク'FINAL'の位置（VARCHAR後）が正しいか確認
- [ ] COMMAREAサイズ検証が正確か確認（VARCHAR長含む）
