---
generated_at: 2026-01-06 15:57:22
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された画面一覧および画面遷移図の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠が確認されました
  2. SSP5（保険請求画面）のトランザクションIDは推定であるため、実環境での確認を推奨します
  3. 一部の機能（SSP4の更新、SSP5の削除・更新）がコメントアウトされている点の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/ssmap.bms` - BMSマップ定義ファイル（画面レイアウト定義）
- E-02: `base/Architecture.md` - アプリケーションアーキテクチャドキュメント
- E-03: `base/Reference.md` - リファレンスドキュメント（トランザクション・プログラム一覧）
- E-04: `base/src/lgtestc1.cbl` - 顧客メニュープレゼンテーションロジック
- E-05: `base/src/lgtestp1.cbl` - 自動車保険ポリシーメニュープレゼンテーションロジック
- E-06: `base/src/lgtestp2.cbl` - 養老保険ポリシーメニュープレゼンテーションロジック
- E-07: `base/src/lgtestp3.cbl` - 住宅保険ポリシーメニュープレゼンテーションロジック
- E-08: `base/src/lgtestp4.cbl` - 商業用不動産保険ポリシーメニュープレゼンテーションロジック
- E-09: `README.md` - プロジェクトREADME

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 顧客メニュー画面（SSMAPC1）が存在する | E-01 (SSMAPC1 DFHMDI定義、行13) | ○ |
| C-02 | 顧客メニュー画面のトランザクションIDはSSC1 | E-02 (行19)、E-03 (行52) | ○ |
| C-03 | 顧客メニュー画面のプログラムはLGTESTC1 | E-03 (行83)、E-04 (PROGRAM-ID) | ○ |
| C-04 | 自動車保険ポリシーメニュー画面（SSMAPP1）が存在する | E-01 (SSMAPP1 DFHMDI定義、行112) | ○ |
| C-05 | 自動車保険ポリシーメニューのトランザクションIDはSSP1 | E-02 (行20)、E-03 (行53) | ○ |
| C-06 | 自動車保険ポリシーメニューのプログラムはLGTESTP1 | E-03 (行84)、E-05 (PROGRAM-ID) | ○ |
| C-07 | 養老保険ポリシーメニュー画面（SSMAPP2）が存在する | E-01 (SSMAPP2 DFHMDI定義、行237) | ○ |
| C-08 | 養老保険ポリシーメニューのトランザクションIDはSSP2 | E-02 (行21)、E-03 (行54) | ○ |
| C-09 | 養老保険ポリシーメニューのプログラムはLGTESTP2 | E-03 (行85)、E-06 (PROGRAM-ID) | ○ |
| C-10 | 住宅保険ポリシーメニュー画面（SSMAPP3）が存在する | E-01 (SSMAPP3 DFHMDI定義、行346) | ○ |
| C-11 | 住宅保険ポリシーメニューのトランザクションIDはSSP3 | E-02 (行22)、E-03 (行55) | ○ |
| C-12 | 住宅保険ポリシーメニューのプログラムはLGTESTP3 | E-03 (行86)、E-07 (PROGRAM-ID) | ○ |
| C-13 | 商業用不動産保険ポリシーメニュー画面（SSMAPP4）が存在する | E-01 (SSMAPP4 DFHMDI定義、行449) | ○ |
| C-14 | 商業用不動産保険ポリシーメニューのトランザクションIDはSSP4 | E-02 (行23)、E-03 (行56) | ○ |
| C-15 | 商業用不動産保険ポリシーメニューのプログラムはLGTESTP4 | E-03 (行87)、E-08 (PROGRAM-ID) | ○ |
| C-16 | 保険請求メニュー画面（SSMAPP5）が存在する | E-01 (SSMAPP5 DFHMDI定義、行606) | ○ |
| C-17 | 各画面でCLEAR/PF3キーでトランザクション終了 | E-04〜E-08 (HANDLE AID CLEAR/PF3処理) | ○ |
| C-18 | 画面内オプション1〜4でビジネスロジック呼び出し | E-04〜E-08 (EVALUATE文でのオプション処理) | ○ |

## 4) 不足情報（Unknown / Missing）
- SSP5（保険請求メニュー画面）に対応するプレゼンテーションロジックプログラムのソースコードが確認できませんでした
  - 候補：LGTESTP5.cbl / 別途存在するプログラム / 未実装
- SSP5のトランザクションIDはReference.mdに記載がなく、画面レイアウト（INITIAL='SSP5'）から推定しています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面一覧の6画面全てがBMSマップファイルで確認済み
- 0: 低リスク - 5画面のトランザクションID・プログラム対応がドキュメントで確認済み
- 1: 中リスク - SSP5画面のプログラム対応およびトランザクションIDは推定

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の6画面が実環境のCICS定義と一致しているか確認
- [ ] SSP5（保険請求画面）のトランザクションIDとプログラム対応を実環境で確認
- [ ] 各画面の入力フィールドが実際の画面表示と一致しているか確認
- [ ] コメントアウトされている機能（SSP4更新、SSP5削除・更新）の運用方針を確認
