# 画面遷移図

本ドキュメントは、GenApp（General Insurance Application）の画面遷移関係を示します。

## 概要

GenAppは、CICS 3270端末ベースの保険業務アプリケーションです。各画面はCICSトランザクションとして独立して起動され、画面間の直接遷移は行われません。ユーザーは各トランザクションIDを入力することで対応する画面にアクセスします。

## 画面遷移図（システム全体）

```mermaid
flowchart TB
    subgraph Terminal["3270端末"]
        START[/"トランザクション入力"/]
    end

    subgraph CustomerMgmt["顧客管理"]
        SSC1["顧客メニュー画面<br/>(SSC1/SSMAPC1)"]
    end

    subgraph PolicyMgmt["保険ポリシー管理"]
        SSP1["自動車保険ポリシーメニュー<br/>(SSP1/SSMAPP1)"]
        SSP2["養老保険ポリシーメニュー<br/>(SSP2/SSMAPP2)"]
        SSP3["住宅保険ポリシーメニュー<br/>(SSP3/SSMAPP3)"]
        SSP4["商業用不動産保険ポリシーメニュー<br/>(SSP4/SSMAPP4)"]
    end

    subgraph ClaimMgmt["保険請求管理"]
        SSP5["保険請求メニュー画面<br/>(SSP5/SSMAPP5)"]
    end

    START -->|"SSC1"| SSC1
    START -->|"SSP1"| SSP1
    START -->|"SSP2"| SSP2
    START -->|"SSP3"| SSP3
    START -->|"SSP4"| SSP4
    START -->|"SSP5"| SSP5

    SSC1 -->|"CLEAR/PF3"| START
    SSP1 -->|"CLEAR/PF3"| START
    SSP2 -->|"CLEAR/PF3"| START
    SSP3 -->|"CLEAR/PF3"| START
    SSP4 -->|"CLEAR/PF3"| START
    SSP5 -->|"CLEAR/PF3"| START
```

## 顧客メニュー画面の機能遷移

```mermaid
flowchart LR
    subgraph SSC1Screen["顧客メニュー画面 (SSC1)"]
        INPUT[/"オプション選択"/]
        OPT1["1. 顧客照会"]
        OPT2["2. 顧客追加"]
        OPT4["4. 顧客更新"]
    end

    subgraph BusinessLogic["ビジネスロジック"]
        LGICUS01["LGICUS01<br/>顧客照会"]
        LGACUS01["LGACUS01<br/>顧客追加"]
        LGUCUS01["LGUCUS01<br/>顧客更新"]
    end

    INPUT -->|"1"| OPT1
    INPUT -->|"2"| OPT2
    INPUT -->|"4"| OPT4

    OPT1 --> LGICUS01
    OPT2 --> LGACUS01
    OPT4 --> LGUCUS01

    LGICUS01 --> SSC1Screen
    LGACUS01 --> SSC1Screen
    LGUCUS01 --> SSC1Screen
```

## ポリシー画面の機能遷移（共通パターン）

```mermaid
flowchart LR
    subgraph PolicyScreen["ポリシーメニュー画面"]
        INPUT[/"オプション選択"/]
        OPT1["1. ポリシー照会"]
        OPT2["2. ポリシー追加"]
        OPT3["3. ポリシー削除"]
        OPT4["4. ポリシー更新"]
    end

    subgraph BusinessLogic["ビジネスロジック"]
        LGIPOL01["LGIPOL01<br/>ポリシー照会"]
        LGAPOL01["LGAPOL01<br/>ポリシー追加"]
        LGDPOL01["LGDPOL01<br/>ポリシー削除"]
        LGUPOL01["LGUPOL01<br/>ポリシー更新"]
    end

    INPUT -->|"1"| OPT1
    INPUT -->|"2"| OPT2
    INPUT -->|"3"| OPT3
    INPUT -->|"4"| OPT4

    OPT1 --> LGIPOL01
    OPT2 --> LGAPOL01
    OPT3 --> LGDPOL01
    OPT4 --> LGUPOL01

    LGIPOL01 --> PolicyScreen
    LGAPOL01 --> PolicyScreen
    LGDPOL01 --> PolicyScreen
    LGUPOL01 --> PolicyScreen
```

## トランザクション・画面・プログラム対応表

| トランザクションID | 画面名 | BMSマップ | プレゼンテーションプログラム |
|---|---|---|---|
| SSC1 | 顧客メニュー画面 | SSMAPC1 | LGTESTC1 |
| SSP1 | 自動車保険ポリシーメニュー | SSMAPP1 | LGTESTP1 |
| SSP2 | 養老保険ポリシーメニュー | SSMAPP2 | LGTESTP2 |
| SSP3 | 住宅保険ポリシーメニュー | SSMAPP3 | LGTESTP3 |
| SSP4 | 商業用不動産保険ポリシーメニュー | SSMAPP4 | LGTESTP4 |
| SSP5 | 保険請求メニュー画面 | SSMAPP5 | （未確認） |

## 画面操作キー

各画面で共通して使用できる操作キー：

| キー | 機能 |
|---|---|
| ENTER | オプション実行 |
| CLEAR | トランザクション終了 |
| PF3 | トランザクション終了 |

## 備考

- 本アプリケーションは3270端末向けのCICSアプリケーションであり、画面間の直接遷移は基本的にありません
- 各画面はトランザクションIDを入力することで直接アクセスします
- 画面内での機能選択（1〜4）により、対応するビジネスロジックプログラムが呼び出されます
- SSP4（商業用不動産保険）の更新機能およびSSP5（保険請求）の削除・更新機能はソースコード上でコメントアウトされています
