---
generated_at: 2026-01-06 10:30:00
metrics:
  claims_total: 23
  claims_with_evidence: 23
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：23 / 23、根拠なし：0
- 優先レビュー（高）
  1. **保険請求メニュー画面**：対応するCOBOLプログラムが確認できず、機能マッピングから除外。実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgtestc1.cbl` - 顧客メニュープログラム
- E-02: `base/src/lgtestp1.cbl` - 自動車保険メニュープログラム
- E-03: `base/src/lgtestp2.cbl` - 養老保険メニュープログラム
- E-04: `base/src/lgtestp3.cbl` - 住宅保険メニュープログラム
- E-05: `base/src/lgtestp4.cbl` - 商業用不動産保険メニュープログラム
- E-06: `base/src/ssmap.bms` - BMS画面マップ定義
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 顧客メニュー画面からF001顧客登録を呼び出す | E-01 (LGACUS01へのLINK) | ○ |
| C-02 | 顧客メニュー画面からF002顧客照会を呼び出す | E-01 (LGICUS01へのLINK) | ○ |
| C-03 | 顧客メニュー画面からF003顧客更新を呼び出す | E-01 (LGUCUS01へのLINK) | ○ |
| C-04 | 顧客メニュー画面にF026顧客メニュー機能が関連 | E-01, E-06 (SSMAPC1画面表示) | ○ |
| C-05 | 自動車保険メニュー画面からF004自動車保険登録を呼び出す | E-02 (LGAPOL01へのLINK, 01AMOT) | ○ |
| C-06 | 自動車保険メニュー画面からF005自動車保険照会を呼び出す | E-02 (LGIPOL01へのLINK, 01IMOT) | ○ |
| C-07 | 自動車保険メニュー画面からF006自動車保険更新を呼び出す | E-02 (LGUPOL01へのLINK, 01UMOT) | ○ |
| C-08 | 自動車保険メニュー画面からF007自動車保険削除を呼び出す | E-02 (LGDPOL01へのLINK, 01DMOT) | ○ |
| C-09 | 自動車保険メニュー画面にF027自動車保険メニュー機能が関連 | E-02, E-06 (SSMAPP1画面表示) | ○ |
| C-10 | 養老保険メニュー画面からF008養老保険登録を呼び出す | E-03 (LGAPOL01へのLINK, 01AEND) | ○ |
| C-11 | 養老保険メニュー画面からF009養老保険照会を呼び出す | E-03 (LGIPOL01へのLINK, 01IEND) | ○ |
| C-12 | 養老保険メニュー画面からF010養老保険更新を呼び出す | E-03 (LGUPOL01へのLINK, 01UEND) | ○ |
| C-13 | 養老保険メニュー画面からF011養老保険削除を呼び出す | E-03 (LGDPOL01へのLINK, 01DEND) | ○ |
| C-14 | 養老保険メニュー画面にF028養老保険メニュー機能が関連 | E-03, E-06 (SSMAPP2画面表示) | ○ |
| C-15 | 住宅保険メニュー画面からF012住宅保険登録を呼び出す | E-04 (LGAPOL01へのLINK, 01AHOU) | ○ |
| C-16 | 住宅保険メニュー画面からF013住宅保険照会を呼び出す | E-04 (LGIPOL01へのLINK, 01IHOU) | ○ |
| C-17 | 住宅保険メニュー画面からF014住宅保険更新を呼び出す | E-04 (LGUPOL01へのLINK, 01UHOU) | ○ |
| C-18 | 住宅保険メニュー画面からF015住宅保険削除を呼び出す | E-04 (LGDPOL01へのLINK, 01DHOU) | ○ |
| C-19 | 住宅保険メニュー画面にF029住宅保険メニュー機能が関連 | E-04, E-06 (SSMAPP3画面表示) | ○ |
| C-20 | 商業用不動産保険メニュー画面からF016商業用不動産保険登録を呼び出す | E-05 (LGAPOL01へのLINK, 01ACOM) | ○ |
| C-21 | 商業用不動産保険メニュー画面からF017商業用不動産保険照会を呼び出す | E-05 (LGIPOL01へのLINK, 01ICOM) | ○ |
| C-22 | 商業用不動産保険メニュー画面からF019商業用不動産保険削除を呼び出す | E-05 (LGDPOL01へのLINK, 01DCOM) | ○ |
| C-23 | 商業用不動産保険メニュー画面にF030商業用不動産保険メニュー機能が関連 | E-05, E-06 (SSMAPP4画面表示) | ○ |

## 4) 不足情報（Unknown / Missing）
- 保険請求メニュー画面（SSMAPP5）に関連するCOBOLプログラムのソースコードが確認できなかった
  - 候補：画面一覧からSSP5トランザクションに対応するプログラムを確認する / 請求関連のLGxCLMxx系プログラムを探索する
- 商業用不動産保険のF018（更新機能）は画面のコメントでも「4. Policy Update」がコメントアウトされており、実装されていない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 顧客メニュー画面と顧客管理機能のマッピング（コード根拠が明確）
- 0: 低リスク - 各保険ポリシーメニュー画面と対応機能のマッピング（コード根拠が明確）
- 1: 中リスク - 保険請求メニュー画面と関連機能のマッピング（対応プログラム未確認）
- 1: 中リスク - 商業用不動産保険の更新機能（F018）がマッピングに含まれていない点（設計上コメントアウトされているため除外）

## 6) レビュアーチェックリスト（最小）
- [ ] 顧客メニュー画面（SSMAPC1）から呼び出される機能が正しくマッピングされているか
- [ ] 各保険ポリシーメニュー画面のオプション番号と機能の対応が正しいか
- [ ] 保険請求メニュー画面（SSMAPP5）の関連機能を追加調査する必要があるか
- [ ] 商業用不動産保険の更新機能（F018）を除外した理由が妥当か
