# 画面設計書 1-顧客メニュー画面

## 概要

本ドキュメントは、GenApp（General Insurance Application）システムにおける顧客メニュー画面（SSMAPC1）の画面設計を定義する。本画面は、保険業務の基盤となる顧客情報の管理（照会・登録・更新）を行うための主要インターフェースである。

### 本画面の処理概要

本画面は、顧客情報の照会・新規登録・更新を行うためのメニュー画面であり、CICS 3270端末から操作する。

**業務上の目的・背景**：保険契約の管理において、顧客情報は全ての業務の基盤となる。本画面は、新規顧客の登録、既存顧客情報の確認・修正を一元的に行うことで、保険ポリシーの発行や請求処理の前提となる顧客マスタデータの正確性を担保する。顧客番号は自動採番され、システム全体で一意に顧客を識別する。

**画面へのアクセス方法**：3270端末からトランザクションID「SSC1」を入力して直接アクセスする。CICSトランザクションとして独立して起動されるため、他画面からの直接遷移は行われない。

**主要な操作・処理内容**：
1. **顧客照会（オプション1）**：顧客番号を指定し、ENTERキーを押下することで該当顧客の詳細情報（氏名、生年月日、住所、電話番号、メールアドレス）をLGICUS01プログラム経由でDb2から取得・表示する
2. **顧客登録（オプション2）**：氏名、生年月日、住所情報等を入力し、ENTERキーを押下することでLGACUS01プログラム経由で新規顧客をDb2に登録する。顧客番号は自動採番される
3. **顧客更新（オプション4）**：顧客番号を指定して照会後、変更内容を入力しENTERキーを押下することで、LGUCUS01プログラム経由で顧客情報を更新する

**画面遷移**：本画面はトランザクション「SSC1」として独立起動する。CLEARキーで画面を初期化し、PF3キーでトランザクションを終了してCICS入力待ち状態に戻る。他画面への直接遷移機能はない。

**権限による表示制御**：本システムはCICS標準のセキュリティ機能に依存しており、画面レベルでの権限制御は実装されていない。トランザクションへのアクセス権限はCICSリソース定義で制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F001 | 顧客登録 | 主機能 | オプション2選択時にLGACUS01プログラムをCICS LINKで呼び出し、新規顧客をDb2/VSAMに登録する |
| F002 | 顧客照会 | 主機能 | オプション1選択時にLGICUS01プログラムをCICS LINKで呼び出し、顧客番号を指定して顧客情報を取得・表示する |
| F003 | 顧客更新 | 主機能 | オプション4選択時にまずLGICUS01で照会後、LGUCUS01プログラムをCICS LINKで呼び出し、顧客情報を更新する |
| F026 | 顧客メニュー | 主機能 | LGTESTC1プログラムが画面SSMAPC1を表示し、顧客操作（照会・登録・更新）のメニュー機能を提供する |

## 画面種別

メニュー / 登録 / 編集（複合画面）

## URL/ルーティング

- トランザクションID: SSC1
- BMSマップセット: SSMAP
- BMSマップ名: SSMAPC1
- プレゼンテーションプログラム: LGTESTC1

## 入出力項目

| 項目名 | フィールドID | 桁数 | 入力/出力 | 属性 | 説明 |
|--------|-------------|------|-----------|------|------|
| 顧客番号 | ENT1CNO | 10 | 入出力 | 数値、右寄せゼロ埋め | 照会・更新時のキー項目、登録時は自動採番 |
| 名（First Name） | ENT1FNA | 10 | 入出力 | 英数字 | 顧客の名（First Name） |
| 姓（Last Name） | ENT1LNA | 20 | 入出力 | 英数字 | 顧客の姓（Last Name） |
| 生年月日 | ENT1DOB | 10 | 入出力 | 日付（yyyy-mm-dd） | 顧客の生年月日 |
| 建物名 | ENT1HNM | 20 | 入出力 | 英数字 | 住所の建物名 |
| 番地 | ENT1HNO | 4 | 入出力 | 英数字 | 住所の番地 |
| 郵便番号 | ENT1HPC | 8 | 入出力 | 英数字 | 郵便番号（大文字変換される） |
| 電話番号（自宅） | ENT1HP1 | 20 | 入出力 | 英数字 | 自宅電話番号 |
| 電話番号（携帯） | ENT1HP2 | 20 | 入出力 | 英数字 | 携帯電話番号 |
| メールアドレス | ENT1HMO | 27 | 入出力 | 英数字 | Eメールアドレス |
| オプション選択 | ENT1OPT | 1 | 入力 | 数値、必須入力 | 操作選択（1:照会、2:登録、4:更新） |
| メッセージ | ERRFLD | 40 | 出力 | 表示専用 | 処理結果メッセージ表示領域 |

## 表示項目

| 項目名 | 位置 | 説明 |
|--------|------|------|
| トランザクションID | 行1、列1 | 「SSC1」固定表示 |
| 画面タイトル | 行1、列12 | 「General Insurance Customer Menu」固定表示 |
| メニュー選択肢 | 行4-7、列8 | 「1. Cust Inquiry」「2. Cust Add」「4. Cust Update」 |
| 各入力項目ラベル | 行4-13、列30 | 各フィールドのラベル表示 |
| 日付フォーマットヒント | 行7、列63 | 「(yyyy-mm-dd)」形式ガイド |
| オプション選択ラベル | 行22、列8 | 「Select Option」 |

## イベント仕様

### 1-オプション1選択（顧客照会）

**トリガー**: オプション欄に「1」を入力してENTERキー押下

**処理フロー**:
1. 画面から顧客番号（ENT1CNO）を取得
2. CA-REQUEST-IDに「01ICUS」を設定
3. LGICUS01プログラムをCICS LINKで呼び出し（COMMAREA長: 32500バイト）
4. LGICUS01からLGICDB01を呼び出し、Db2から顧客情報を取得
5. CA-RETURN-CODEが0より大きい場合、「No data was returned.」メッセージを表示
6. 正常時は取得した顧客情報を画面フィールドに設定して再表示

### 2-オプション2選択（顧客登録）

**トリガー**: オプション欄に「2」を入力してENTERキー押下

**処理フロー**:
1. 画面から顧客情報（氏名、生年月日、住所等）を取得
2. CA-REQUEST-IDに「01ACUS」を設定、CA-CUSTOMER-NUMに0を設定
3. 郵便番号を大文字に変換（FUNCTION UPPER-CASE使用）
4. LGACUS01プログラムをCICS LINKで呼び出し
5. LGACUS01からLGACDB01を呼び出し、Db2に新規顧客を登録
6. エラー時はSYNCPOINT ROLLBACKを実行し「Error Adding Customer」を表示
7. 正常時はGENACNTLキューを更新し、自動採番された顧客番号と「New Customer Inserted」を表示

### 3-オプション4選択（顧客更新）

**トリガー**: オプション欄に「4」を入力してENTERキー押下

**処理フロー**:
1. まずLGICUS01を呼び出して既存顧客情報を取得・表示
2. ユーザーが情報を修正してENTERキー押下
3. CA-REQUEST-IDに「01UCUS」を設定
4. 郵便番号を大文字に変換（FUNCTION UPPER-CASE使用）
5. LGUCUS01プログラムをCICS LINKで呼び出し
6. LGUCUS01からLGUCDB01を呼び出し、Db2の顧客情報を更新
7. エラー時は「Error Updating Customer」を表示
8. 正常時は「Customer details updated」を表示

### 4-CLEARキー押下

**トリガー**: CLEARキー押下

**処理フロー**:
1. 画面フィールドを初期化（DFHCOMMAREA初期化）
2. SSMAPC1マップを再表示（SEND MAP MAPONLY）
3. トランザクションSSC1を継続（RETURN TRANSID）

### 5-PF3キー押下

**トリガー**: PF3キー押下

**処理フロー**:
1. 「Transaction ended」メッセージを表示
2. CICSにRETURNしてトランザクション終了

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オプション1（照会） | CUSTOMER | SELECT | 顧客番号をキーに顧客情報を取得 |
| オプション2（登録） | CUSTOMER | INSERT | 新規顧客レコードを登録 |
| オプション4（更新） | CUSTOMER | UPDATE | 既存顧客レコードを更新 |

### テーブル別更新項目詳細

#### CUSTOMERテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | CUSTOMERNUMBER | WHERE条件として使用 | 主キー |
| SELECT | FIRSTNAME | 画面表示用に取得 | ENT1FNAに設定 |
| SELECT | LASTNAME | 画面表示用に取得 | ENT1LNAに設定 |
| SELECT | DATEOFBIRTH | 画面表示用に取得 | ENT1DOBに設定 |
| SELECT | HOUSENAME | 画面表示用に取得 | ENT1HNMに設定 |
| SELECT | HOUSENUMBER | 画面表示用に取得 | ENT1HNOに設定 |
| SELECT | POSTCODE | 画面表示用に取得 | ENT1HPCに設定 |
| SELECT | PHONEHOME | 画面表示用に取得 | ENT1HP1に設定 |
| SELECT | PHONEMOBILE | 画面表示用に取得 | ENT1HP2に設定 |
| SELECT | EMAILADDRESS | 画面表示用に取得 | ENT1HMOに設定 |
| INSERT | CUSTOMERNUMBER | 自動採番値 | GENACNTLキューで管理 |
| INSERT | FIRSTNAME | CA-FIRST-NAME | 画面入力値 |
| INSERT | LASTNAME | CA-LAST-NAME | 画面入力値 |
| INSERT | DATEOFBIRTH | CA-DOB | 画面入力値 |
| INSERT | HOUSENAME | CA-HOUSE-NAME | 画面入力値 |
| INSERT | HOUSENUMBER | CA-HOUSE-NUM | 画面入力値 |
| INSERT | POSTCODE | CA-POSTCODE | 大文字変換後 |
| INSERT | PHONEHOME | CA-PHONE-HOME | 画面入力値 |
| INSERT | PHONEMOBILE | CA-PHONE-MOBILE | 画面入力値 |
| INSERT | EMAILADDRESS | CA-EMAIL-ADDRESS | 画面入力値 |
| UPDATE | 全項目 | CA-*対応項目 | 顧客番号をキーに更新 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|---------|------|
| MSG001 | New Customer Inserted | 顧客登録成功時 | 成功 |
| MSG002 | Customer details updated | 顧客更新成功時 | 成功 |
| MSG003 | No data was returned. | 照会結果が0件の場合 | 警告 |
| MSG004 | Error Adding Customer | 顧客登録失敗時 | エラー |
| MSG005 | Error Updating Customer | 顧客更新失敗時 | エラー |
| MSG006 | Please enter a valid option | 無効なオプション入力時 | エラー |
| MSG007 | Transaction ended | PF3押下時 | 情報 |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| COMMEAREAなし | アベンドコード「LGCA」で異常終了（NODUMP） |
| COMMAREA長不足 | CA-RETURN-CODEに「98」を設定してリターン |
| 無効なリクエストID | CA-RETURN-CODEに「99」を設定してリターン |
| データ未検出 | 「No data was returned.」を表示して画面再表示 |
| 登録エラー | SYNCPOINT ROLLBACKを実行、エラーメッセージ表示後、画面を初期化して再表示 |
| 更新エラー | エラーメッセージ表示後、画面を初期化して再表示 |
| MAPFAIL | トランザクション終了 |

## 備考

- 顧客番号は10桁の数値で、右寄せゼロ埋め形式
- 郵便番号は入力時に自動的に大文字に変換される（FUNCTION UPPER-CASEを使用）
- オプション「3」は画面上に表示されていない（顧客削除機能は未実装）
- 顧客番号の採番はGENACNTLという名前のTSQ（Temporary Storage Queue）で管理される
- エラー発生時はLGSTSQプログラムを通じてエラーメッセージがCSMTキューに記録される
- 本画面はBMSマップセット「SSMAP」内のマップ「SSMAPC1」として定義されている
- ビジネスロジックプログラム（LGICUS01, LGACUS01, LGUCUS01）はCICS LINKコマンドで呼び出され、COMMエリア長は32500バイト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造（COMMAREA）を理解することが重要。顧客メニュー画面で扱うデータは全てこの構造を通じてビジネスロジックプログラムとやり取りされる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-REQUEST-ID（6桁）でリクエスト種別を識別、CA-CUSTOMER-NUM（10桁）で顧客番号を指定 |
| 1-2 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-CUSTOMER-REQUEST（行15-26）で顧客情報の詳細フィールド（氏名、住所、電話等）を定義 |

**読解のコツ**: COBOLのREDEFINES句により、CA-REQUEST-SPECIFICは複数のデータ構造として解釈可能。顧客操作ではCA-CUSTOMER-REQUEST部分を使用する。

#### Step 2: 画面レイアウト（BMS）を理解する

画面項目の配置と属性を定義するBMSマップを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | SSMAPC1マップ定義（行13-106）：画面サイズ24x80、フィールド配置 |

**主要フィールド定義**:
- **行29**: ENT1CNO - 顧客番号入力（10桁、右寄せゼロ埋め）
- **行36**: ENT1FNA - 名（First Name、10桁）
- **行42**: ENT1LNA - 姓（Last Name、20桁）
- **行49**: ENT1DOB - 生年月日（10桁、yyyy-mm-dd形式）
- **行100**: ENT1OPT - オプション選択（1桁、数値必須入力）
- **行105**: ERRFLD - エラーメッセージ表示領域（40桁）

#### Step 3: メインプログラム（プレゼンテーション層）を理解する

画面制御とビジネスロジック呼び出しを行うメインプログラムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestc1.cbl | `base/src/lgtestc1.cbl` | MAINLINE SECTION（行53-）：初回表示時のマップ送信処理 |
| 3-2 | lgtestc1.cbl | `base/src/lgtestc1.cbl` | A-GAIN（行70-）：AID処理（CLEAR/PF3キー）とマップ受信 |
| 3-3 | lgtestc1.cbl | `base/src/lgtestc1.cbl` | EVALUATE ENT1OPTO（行84-222）：オプション分岐処理の中核 |

**主要処理フロー**:
1. **行55-56**: EIBCALENチェック - 初回起動判定
2. **行64-68**: EXEC CICS SEND MAP - 初期画面表示
3. **行72-77**: HANDLE AID/CONDITION - キー操作とエラーハンドリング設定
4. **行79-81**: EXEC CICS RECEIVE MAP - 画面入力受信
5. **行84-222**: EVALUATE文 - オプション値による処理分岐
   - **行86-111**: WHEN '1' - 顧客照会（LGICUS01呼び出し）
   - **行113-146**: WHEN '2' - 顧客登録（LGACUS01呼び出し）
   - **行148-207**: WHEN '4' - 顧客更新（LGICUS01→LGUCUS01呼び出し）
   - **行209-220**: WHEN OTHER - 無効オプションエラー

#### Step 4: TSQによる顧客番号管理を理解する

新規顧客登録時の採番管理（GENACNTL）の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgtestc1.cbl | `base/src/lgtestc1.cbl` | WRITE-GENACNTL（行283-347）：TSQによる顧客番号ハイウォーターマーク管理 |

**主要処理フロー**:
- **行285-287**: ENQリソースロック取得（排他制御）
- **行290-316**: TSQの読み取りと「HIGH CUSTOMER」レコード更新
- **行321-340**: 新規TSQ作成（初回登録時）
- **行343-345**: DEQリソースロック解放

### プログラム呼び出し階層図

```
LGTESTC1（プレゼンテーションプログラム）
    │
    ├─ LGICUS01（顧客照会）──→ LGICDB01（Db2アクセス）
    │
    ├─ LGACUS01（顧客登録）──→ LGACDB01（Db2アクセス）
    │
    └─ LGUCUS01（顧客更新）──→ LGUCDB01（Db2アクセス）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

3270端末                  LGTESTC1                         CUSTOMERテーブル
    │                         │                                 │
    │ ①画面入力              │                                 │
    │  (ENT1CNO,             │                                 │
    │   ENT1FNA等)           │                                 │
    ├────────────────────▶    │                                 │
    │                         │ ②COMMAREA設定                  │
    │                         │   CA-REQUEST-ID                 │
    │                         │   CA-CUSTOMER-NUM               │
    │                         │                                 │
    │                         ├─────▶ LGICUS01/LGACUS01/LGUCUS01
    │                         │              │                  │
    │                         │              │ ③CICS LINK       │
    │                         │              ├─────────────────▶│
    │                         │              │                  │
    │                         │ ④結果受信   │                  │
    │                         │◀─────────────┤                  │
    │                         │              │                  │
    │ ⑤画面表示              │                                 │
    │◀────────────────────────┤                                 │
    │                         │                                 │
    │                    GENACNTL(TSQ)                          │
    │                    ※顧客番号採番用                         │
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestc1.cbl | `base/src/lgtestc1.cbl` | COBOLソース | 顧客メニュー画面制御プログラム |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面レイアウト定義（SSMAPC1部分） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | COBOLコピー句 | COMMAREA構造定義 |
| lgicus01.cbl | `base/src/lgicus01.cbl` | COBOLソース | 顧客照会ビジネスロジック |
| lgacus01.cbl | `base/src/lgacus01.cbl` | COBOLソース | 顧客登録ビジネスロジック |
| lgucus01.cbl | `base/src/lgucus01.cbl` | COBOLソース | 顧客更新ビジネスロジック |
| lgicdb01.cbl | `base/src/lgicdb01.cbl` | COBOLソース | 顧客照会Db2アクセス |
| lgacdb01.cbl | `base/src/lgacdb01.cbl` | COBOLソース | 顧客登録Db2アクセス |
| lgucdb01.cbl | `base/src/lgucdb01.cbl` | COBOLソース | 顧客更新Db2アクセス |
