# 画面設計書 2-自動車保険ポリシーメニュー画面

## 概要

本ドキュメントは、GenApp（General Insurance Application）システムにおける自動車保険ポリシーメニュー画面（SSMAPP1）の画面設計を定義する。本画面は、自動車保険ポリシーの照会・登録・削除・更新を行うためのインターフェースである。

### 本画面の処理概要

本画面は、自動車保険ポリシーの照会・新規登録・削除・更新を行うためのメニュー画面であり、CICS 3270端末から操作する。

**業務上の目的・背景**：自動車保険は一般保険業務の主要商品の一つであり、車両情報と連動したポリシー管理が必要である。本画面は、自動車保険ポリシーのライフサイクル全体（新規契約、内容照会、契約変更、契約解約）を一元的に管理するために提供されている。オペレーターは車両の詳細情報（メーカー、車種、価格、登録番号、色、排気量、製造日）と保険条件（発行日、有効期限、保険料、事故回数）を組み合わせてポリシーを管理できる。

**画面へのアクセス方法**：3270端末からトランザクションID「SSP1」を入力して直接アクセスする。CICSトランザクションとして独立して起動されるため、他画面からの直接遷移は行われない。

**主要な操作・処理内容**：
1. **ポリシー照会（オプション1）**：ポリシー番号と顧客番号を入力し、ENTERキーを押下することでLGIPOL01プログラム経由で該当ポリシーの詳細情報を取得・表示する
2. **ポリシー登録（オプション2）**：顧客番号と車両詳細、保険条件を入力し、ENTERキーを押下することでLGAPOL01プログラム経由で新規ポリシーを登録する
3. **ポリシー削除（オプション3）**：ポリシー番号と顧客番号を入力し、ENTERキーを押下することでLGDPOL01プログラム経由でポリシーを削除する
4. **ポリシー更新（オプション4）**：ポリシー番号と顧客番号を入力して照会後、変更内容を入力しENTERキーを押下することでLGUPOL01プログラム経由でポリシーを更新する

**画面遷移**：本画面はトランザクション「SSP1」として独立起動する。CLEARキーで画面を初期化し、PF3キーでトランザクションを終了してCICS入力待ち状態に戻る。他画面への直接遷移機能はない。

**権限による表示制御**：本システムはCICS標準のセキュリティ機能に依存しており、画面レベルでの権限制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F004 | 自動車保険登録 | 主機能 | オプション2選択時にLGAPOL01プログラムをCICS LINKで呼び出し、自動車保険ポリシーを新規作成する |
| F005 | 自動車保険照会 | 主機能 | オプション1選択時にLGIPOL01プログラムをCICS LINKで呼び出し、ポリシー詳細を照会・表示する |
| F006 | 自動車保険更新 | 主機能 | オプション4選択時にまずLGIPOL01で照会後、LGUPOL01プログラムをCICS LINKで呼び出し、ポリシーを更新する |
| F007 | 自動車保険削除 | 主機能 | オプション3選択時にLGDPOL01プログラムをCICS LINKで呼び出し、ポリシーを削除する |
| F027 | 自動車保険メニュー | 主機能 | LGTESTP1プログラムが画面SSMAPP1を表示し、自動車保険の操作メニュー機能を提供する |

## 画面種別

メニュー / 登録 / 照会 / 編集 / 削除（複合画面）

## URL/ルーティング

- トランザクションID: SSP1
- BMSマップセット: SSMAP
- BMSマップ名: SSMAPP1
- プレゼンテーションプログラム: LGTESTP1

## 入出力項目

| 項目名 | フィールドID | 桁数 | 入力/出力 | 属性 | 説明 |
|--------|-------------|------|-----------|------|------|
| ポリシー番号 | ENP1PNO | 10 | 入出力 | 数値、右寄せゼロ埋め | 照会・更新・削除時のキー項目、登録時は自動採番 |
| 顧客番号 | ENP1CNO | 10 | 入出力 | 数値、右寄せゼロ埋め | 必須、外部キー |
| 発行日 | ENP1IDA | 10 | 入出力 | 日付（yyyy-mm-dd） | ポリシー発行日 |
| 有効期限 | ENP1EDA | 10 | 入出力 | 日付（yyyy-mm-dd） | ポリシー有効期限 |
| 車メーカー | ENP1CMK | 20 | 入出力 | 英数字 | 車両メーカー名（COMMAREA15桁） |
| 車種 | ENP1CMO | 20 | 入出力 | 英数字 | 車両モデル名（COMMAREA15桁） |
| 車両価値 | ENP1VAL | 6 | 入出力 | 数値、右寄せゼロ埋め | 車両価格 |
| 登録番号 | ENP1REG | 7 | 入出力 | 英数字 | ナンバープレート |
| 車色 | ENP1COL | 8 | 入出力 | 英数字 | 車両の色 |
| 排気量 | ENP1CC | 8 | 入出力 | 数値、右寄せゼロ埋め | エンジン排気量（COMMAREA4桁） |
| 製造日 | ENP1MAN | 10 | 入出力 | 日付（yyyy-mm-dd） | 車両製造日 |
| 事故回数 | ENP1ACC | 6 | 入出力 | 数値、右寄せゼロ埋め | 事故発生回数 |
| 保険料 | ENP1PRE | 6 | 入出力 | 数値、右寄せゼロ埋め | 月額保険料 |
| オプション選択 | ENP1OPT | 1 | 入力 | 数値、必須入力 | 操作選択（1:照会、2:登録、3:削除、4:更新） |
| メッセージ | ERP1FLD | 40 | 出力 | 表示専用 | 処理結果メッセージ表示領域 |

## 表示項目

| 項目名 | 位置 | 説明 |
|--------|------|------|
| トランザクションID | 行1、列1 | 「SSP1」固定表示 |
| 画面タイトル | 行1、列12 | 「General Insurance Motor Policy Menu」固定表示 |
| メニュー選択肢 | 行4-7、列8 | 「1. Policy Inquiry」「2. Policy Add」「3. Policy Delete」「4. Policy Update」 |
| 各入力項目ラベル | 行4-17、列30 | 各フィールドのラベル表示 |
| 日付フォーマットヒント | 行6,8,13、列63 | 「(yyyy-mm-dd)」形式ガイド |
| オプション選択ラベル | 行22、列8 | 「Select Option」 |

## イベント仕様

### 1-オプション1選択（ポリシー照会）

**トリガー**: オプション欄に「1」を入力してENTERキー押下

**処理フロー**:
1. 画面から顧客番号（ENP1CNO）とポリシー番号（ENP1PNO）を取得
2. CA-REQUEST-IDに「01IMOT」を設定
3. LGIPOL01プログラムをCICS LINKで呼び出し（COMMAREA長: 32500バイト）
4. CA-RETURN-CODEが0より大きい場合、「No data was returned.」メッセージを表示
5. 正常時は取得したポリシー情報（車両詳細、保険条件）を画面フィールドに設定して再表示

### 2-オプション2選択（ポリシー登録）

**トリガー**: オプション欄に「2」を入力してENTERキー押下

**処理フロー**:
1. 画面からポリシー情報（顧客番号、発行日、有効期限、車両詳細等）を取得
2. CA-REQUEST-IDに「01AMOT」を設定
3. CA-PAYMENTとCA-BROKERIDに0、CA-BROKERSREFに空白を設定
4. 入力データをCOMMAREA（CA-MOTOR構造体）にマッピング
5. LGAPOL01プログラムをCICS LINKで呼び出し
6. CA-RETURN-CODEが70の場合、「Customer does not exist」を表示
7. その他エラー時はSYNCPOINT ROLLBACKを実行し「Error Adding Motor Policy」を表示
8. 正常時は自動採番されたポリシー番号と「New Motor Policy Inserted」を表示

### 3-オプション3選択（ポリシー削除）

**トリガー**: オプション欄に「3」を入力してENTERキー押下

**処理フロー**:
1. 画面から顧客番号（ENP1CNO）とポリシー番号（ENP1PNO）を取得
2. CA-REQUEST-IDに「01DMOT」を設定
3. LGDPOL01プログラムをCICS LINKで呼び出し
4. エラー時はSYNCPOINT ROLLBACKを実行し「Error Deleting Motor Policy」を表示
5. 正常時は画面のポリシー詳細フィールドをクリアし「Motor Policy Deleted」を表示

### 4-オプション4選択（ポリシー更新）

**トリガー**: オプション欄に「4」を入力してENTERキー押下

**処理フロー**:
1. まずCA-REQUEST-IDに「01IMOT」を設定し、LGIPOL01で既存データを照会・表示
2. ユーザーが情報を修正してENTERキー押下
3. CA-REQUEST-IDに「01UMOT」を設定
4. 修正データをCOMMAREAにマッピング
5. LGUPOL01プログラムをCICS LINKで呼び出し
6. エラー時は「Error Updating Motor Policy」を表示
7. 正常時は「Motor Policy Updated」を表示

### 5-CLEARキー押下

**トリガー**: CLEARキー押下

**処理フロー**:
1. 画面フィールドを初期化
2. SSMAPP1マップを再表示（SEND MAP MAPONLY）
3. トランザクションSSP1を継続

### 6-PF3キー押下

**トリガー**: PF3キー押下

**処理フロー**:
1. 「Transaction ended」メッセージを表示
2. CICSにRETURNしてトランザクション終了

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オプション1（照会） | POLICY, MOTOR | SELECT | ポリシー番号・顧客番号をキーにポリシー情報を取得 |
| オプション2（登録） | POLICY, MOTOR | INSERT | 新規自動車保険ポリシーレコードを登録 |
| オプション3（削除） | POLICY, MOTOR | DELETE | ポリシー番号をキーにポリシーを削除 |
| オプション4（更新） | POLICY, MOTOR | UPDATE | ポリシー番号をキーにポリシー情報を更新 |

### テーブル別更新項目詳細

#### POLICY/MOTORテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT/INSERT/UPDATE | CA-POLICY-NUM | ポリシー番号 | キー項目 |
| SELECT/INSERT/UPDATE | CA-CUSTOMER-NUM | 顧客番号 | 外部キー |
| INSERT/UPDATE | CA-ISSUE-DATE | 発行日 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-EXPIRY-DATE | 有効期限 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-M-MAKE | 車メーカー | 最大15桁 |
| INSERT/UPDATE | CA-M-MODEL | 車種 | 最大15桁 |
| INSERT/UPDATE | CA-M-VALUE | 車両価値 | 6桁数字 |
| INSERT/UPDATE | CA-M-REGNUMBER | 登録番号 | 7桁 |
| INSERT/UPDATE | CA-M-COLOUR | 車色 | 8桁 |
| INSERT/UPDATE | CA-M-CC | 排気量 | 4桁数字 |
| INSERT/UPDATE | CA-M-MANUFACTURED | 製造日 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-M-PREMIUM | 保険料 | 6桁数字 |
| INSERT/UPDATE | CA-M-ACCIDENTS | 事故回数 | 6桁数字 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|---------|------|
| MSG001 | New Motor Policy Inserted | ポリシー登録成功時 | 成功 |
| MSG002 | Motor Policy Updated | ポリシー更新成功時 | 成功 |
| MSG003 | Motor Policy Deleted | ポリシー削除成功時 | 成功 |
| MSG004 | No data was returned. | 照会結果が0件の場合 | 警告 |
| MSG005 | Customer does not exist | 登録時に顧客が存在しない場合（RC=70） | エラー |
| MSG006 | Error Adding Motor Policy | ポリシー登録失敗時 | エラー |
| MSG007 | Error Updating Motor Policy | ポリシー更新失敗時 | エラー |
| MSG008 | Error Deleting Motor Policy | ポリシー削除失敗時 | エラー |
| MSG009 | Please enter a valid option | 無効なオプション入力時 | エラー |
| MSG010 | Transaction ended | PF3押下時 | 情報 |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| COMMEAREAなし | アベンドコード「LGCA」で異常終了（NODUMP） |
| COMMAREA長不足 | CA-RETURN-CODEに「98」を設定してリターン |
| 無効なリクエストID | CA-RETURN-CODEに「99」を設定してリターン |
| 顧客不存在（RC=70） | 「Customer does not exist」を表示して画面再表示 |
| データ未検出 | 「No data was returned.」を表示して画面再表示 |
| 登録エラー | SYNCPOINT ROLLBACKを実行、エラーメッセージ表示後、画面を初期化して再表示 |
| 削除エラー | SYNCPOINT ROLLBACKを実行、エラーメッセージ表示後、画面を初期化して再表示 |
| 更新エラー | エラーメッセージ表示後、画面を初期化して再表示 |
| MAPFAIL | トランザクション終了 |

## 備考

- ポリシー番号・顧客番号は10桁の数値で、右寄せゼロ埋め形式
- 車メーカー・車種は画面表示20桁だが、COMMAREA上は15桁で定義されている
- 排気量は画面表示8桁だが、COMMAREA上は4桁で定義されている
- 登録時、顧客が存在しない場合はリターンコード70が返却される
- CA-MOTOR構造体（lgcmarea.cpy行65-75）にポリシー固有データが格納される
- ビジネスロジックプログラム（LGIPOL01, LGAPOL01, LGDPOL01, LGUPOL01）はCICS LINKコマンドで呼び出され、COMMエリア長は32500バイト
- 削除処理時、画面上の車両詳細フィールドはクリアされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造（COMMAREA）を理解することが重要。自動車保険ポリシーデータはCA-MOTOR構造体として定義されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-REQUEST-ID（6桁）とCA-POLICY-REQUEST構造（行34-44）でポリシー基本情報を定義 |
| 1-2 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-MOTOR（行65-75）で自動車保険固有フィールド（車種、価格、登録番号等）を定義 |

**読解のコツ**: CA-POLICY-SPECIFICはREDEFINES句により複数の保険種別（Motor/Endowment/House/Commercial）で共用。自動車保険ではCA-MOTORとして解釈する。

#### Step 2: 画面レイアウト（BMS）を理解する

画面項目の配置と属性を定義するBMSマップを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | SSMAPP1マップ定義（行112-231）：自動車保険ポリシーメニュー画面 |

**主要フィールド定義**:
- **行128**: ENP1PNO - ポリシー番号入力（10桁、右寄せゼロ埋め）
- **行135**: ENP1CNO - 顧客番号入力（10桁、右寄せゼロ埋め）
- **行142**: ENP1IDA - 発行日（10桁、yyyy-mm-dd形式）
- **行151**: ENP1EDA - 有効期限（10桁）
- **行160**: ENP1CMK - 車メーカー（20桁）
- **行167**: ENP1CMO - 車種（20桁）
- **行174**: ENP1VAL - 車両価値（6桁、右寄せゼロ埋め）
- **行225**: ENP1OPT - オプション選択（1桁、数値必須入力）
- **行230**: ERP1FLD - エラーメッセージ表示領域（40桁）

#### Step 3: メインプログラム（プレゼンテーション層）を理解する

画面制御とビジネスロジック呼び出しを行うメインプログラムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | MAINLINE SECTION（行30-）：初回表示時のマップ送信と初期値設定 |
| 3-2 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | A-GAIN（行52-）：AID処理とマップ受信 |
| 3-3 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | EVALUATE ENP1OPTO（行66-249）：オプション分岐処理の中核 |

**主要処理フロー**:
1. **行32-33**: EIBCALENチェック - 初回起動判定
2. **行35-43**: 初期化 - 画面とCOMMAREAの初期化、数値フィールドのゼロ埋め
3. **行47-50**: EXEC CICS SEND MAP - 初期画面表示
4. **行54-59**: HANDLE AID/CONDITION - キー操作とエラーハンドリング設定
5. **行61-63**: EXEC CICS RECEIVE MAP - 画面入力受信
6. **行66-249**: EVALUATE文 - オプション値による処理分岐
   - **行68-95**: WHEN '1' - ポリシー照会（LGIPOL01、リクエストID: 01IMOT）
   - **行97-133**: WHEN '2' - ポリシー登録（LGAPOL01、リクエストID: 01AMOT）
   - **行135-167**: WHEN '3' - ポリシー削除（LGDPOL01、リクエストID: 01DMOT）
   - **行169-234**: WHEN '4' - ポリシー更新（LGIPOL01→LGUPOL01、リクエストID: 01UMOT）
   - **行236-247**: WHEN OTHER - 無効オプションエラー

#### Step 4: エラー処理を理解する

各種エラー条件と処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | NO-ADD（行286-294）：登録エラー処理、RC=70は顧客不存在 |
| 4-2 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | ERROR-OUT（行308-318）：共通エラー処理、画面再表示と初期化 |

**主要処理フロー**:
- **行287-294**: CA-RETURN-CODE=70の場合は「Customer does not exist」を表示
- **行120, 144**: 登録・削除エラー時はSYNCPOINT ROLLBACKでトランザクション取消

### プログラム呼び出し階層図

```
LGTESTP1（プレゼンテーションプログラム）
    │
    ├─ LGIPOL01（ポリシー照会）──→ LGIPDB01（Db2アクセス）
    │
    ├─ LGAPOL01（ポリシー登録）──→ LGAPDB01（Db2アクセス）
    │
    ├─ LGDPOL01（ポリシー削除）──→ LGDPDB01（Db2アクセス）
    │
    └─ LGUPOL01（ポリシー更新）──→ LGUPDB01（Db2アクセス）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

3270端末                  LGTESTP1                      POLICY/MOTORテーブル
    │                         │                                 │
    │ ①画面入力              │                                 │
    │  (ENP1PNO, ENP1CNO,    │                                 │
    │   ENP1CMK等)           │                                 │
    ├────────────────────▶    │                                 │
    │                         │ ②COMMAREA設定                  │
    │                         │   CA-REQUEST-ID (01IMOT等)      │
    │                         │   CA-POLICY-NUM                 │
    │                         │   CA-MOTOR構造体                │
    │                         │                                 │
    │                         ├─────▶ LGIPOL01/LGAPOL01等       │
    │                         │              │                  │
    │                         │              │ ③CICS LINK       │
    │                         │              ├─────────────────▶│
    │                         │              │                  │
    │                         │ ④結果受信   │                  │
    │                         │◀─────────────┤                  │
    │                         │              │                  │
    │ ⑤画面表示              │                                 │
    │◀────────────────────────┤                                 │
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestp1.cbl | `base/src/lgtestp1.cbl` | COBOLソース | 自動車保険メニュー画面制御プログラム |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面レイアウト定義（SSMAPP1部分） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | COBOLコピー句 | COMMAREA構造定義（CA-MOTOR含む） |
| lgipol01.cbl | `base/src/lgipol01.cbl` | COBOLソース | ポリシー照会ビジネスロジック |
| lgapol01.cbl | `base/src/lgapol01.cbl` | COBOLソース | ポリシー登録ビジネスロジック |
| lgdpol01.cbl | `base/src/lgdpol01.cbl` | COBOLソース | ポリシー削除ビジネスロジック |
| lgupol01.cbl | `base/src/lgupol01.cbl` | COBOLソース | ポリシー更新ビジネスロジック |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | COBOLソース | ポリシー照会Db2アクセス |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | COBOLソース | ポリシー登録Db2アクセス |
| lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | COBOLソース | ポリシー削除Db2アクセス |
| lgupdb01.cbl | `base/src/lgupdb01.cbl` | COBOLソース | ポリシー更新Db2アクセス |
