# 画面設計書 3-養老保険ポリシーメニュー画面

## 概要

本ドキュメントは、GenApp（General Insurance Application）システムにおける養老保険ポリシーメニュー画面（SSMAPP2）の画面設計を定義する。本画面は、養老保険（Endowment/Life）ポリシーの照会・登録・削除・更新を行うためのインターフェースである。

### 本画面の処理概要

本画面は、養老保険ポリシーの照会・新規登録・削除・更新を行うためのメニュー画面であり、CICS 3270端末から操作する。

**業務上の目的・背景**：養老保険は貯蓄性のある生命保険商品であり、満期時の保証額や運用方法（ファンド名、利益配当、株式投資、マネージドファンド）の管理が重要である。本画面は、養老保険ポリシーのライフサイクル全体（新規契約、内容照会、契約変更、契約解約）を一元的に管理するために提供されている。オペレーターは被保険者情報と保険条件（発行日、有効期限、ファンド名、期間、保証額、利益配当有無、投資オプション）を組み合わせてポリシーを管理できる。

**画面へのアクセス方法**：3270端末からトランザクションID「SSP2」を入力して直接アクセスする。CICSトランザクションとして独立して起動されるため、他画面からの直接遷移は行われない。

**主要な操作・処理内容**：
1. **ポリシー照会（オプション1）**：ポリシー番号と顧客番号を入力し、ENTERキーを押下することでLGIPOL01プログラム経由で該当ポリシーの詳細情報を取得・表示する
2. **ポリシー登録（オプション2）**：顧客番号とポリシー情報（発行日、有効期限、ファンド詳細、被保険者情報）を入力し、ENTERキーを押下することでLGAPOL01プログラム経由で新規ポリシーを登録する
3. **ポリシー削除（オプション3）**：ポリシー番号と顧客番号を入力し、ENTERキーを押下することでLGDPOL01プログラム経由でポリシーを削除する
4. **ポリシー更新（オプション4）**：ポリシー番号と顧客番号を入力して照会後、変更内容を入力しENTERキーを押下することでLGUPOL01プログラム経由でポリシーを更新する

**画面遷移**：本画面はトランザクション「SSP2」として独立起動する。CLEARキーで画面を初期化し、PF3キーでトランザクションを終了してCICS入力待ち状態に戻る。他画面への直接遷移機能はない。

**権限による表示制御**：本システムはCICS標準のセキュリティ機能に依存しており、画面レベルでの権限制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F008 | 養老保険登録 | 主機能 | オプション2選択時にLGAPOL01プログラムをCICS LINKで呼び出し、養老保険ポリシーを新規作成する |
| F009 | 養老保険照会 | 主機能 | オプション1選択時にLGIPOL01プログラムをCICS LINKで呼び出し、ポリシー詳細を照会・表示する |
| F010 | 養老保険更新 | 主機能 | オプション4選択時にまずLGIPOL01で照会後、LGUPOL01プログラムをCICS LINKで呼び出し、ポリシーを更新する |
| F011 | 養老保険削除 | 主機能 | オプション3選択時にLGDPOL01プログラムをCICS LINKで呼び出し、ポリシーを削除する |
| F028 | 養老保険メニュー | 主機能 | LGTESTP2プログラムが画面SSMAPP2を表示し、養老保険の操作メニュー機能を提供する |

## 画面種別

メニュー / 登録 / 照会 / 編集 / 削除（複合画面）

## URL/ルーティング

- トランザクションID: SSP2
- BMSマップセット: SSMAP
- BMSマップ名: SSMAPP2
- プレゼンテーションプログラム: LGTESTP2

## 入出力項目

| 項目名 | フィールドID | 桁数 | 入力/出力 | 属性 | 説明 |
|--------|-------------|------|-----------|------|------|
| ポリシー番号 | ENP2PNO | 10 | 入出力 | 数値、右寄せゼロ埋め | 照会・更新・削除時のキー項目、登録時は自動採番 |
| 顧客番号 | ENP2CNO | 10 | 入出力 | 数値、右寄せゼロ埋め | 必須、外部キー |
| 発行日 | ENP2IDA | 10 | 入出力 | 日付（yyyy-mm-dd） | ポリシー発行日 |
| 有効期限 | ENP2EDA | 10 | 入出力 | 日付（yyyy-mm-dd） | ポリシー有効期限 |
| ファンド名 | ENP2FNM | 10 | 入出力 | 英数字 | 投資ファンド名 |
| 期間 | ENP2TER | 2 | 入出力 | 数値、右寄せゼロ埋め | 保険期間（年） |
| 保証額 | ENP2SUM | 6 | 入出力 | 数値、右寄せゼロ埋め | 満期保証額 |
| 被保険者名 | ENP2LIF | 25 | 入出力 | 英数字 | 被保険者の氏名（COMMAREA31桁） |
| 利益配当有無 | ENP2WPR | 1 | 入出力 | 英数字 | Y/N |
| 株式投資 | ENP2EQU | 1 | 入出力 | 英数字 | Y/N |
| マネージドファンド | ENP2MAN | 1 | 入出力 | 英数字 | Y/N |
| オプション選択 | ENP2OPT | 1 | 入力 | 数値、必須入力 | 操作選択（1:照会、2:登録、3:削除、4:更新） |
| メッセージ | ERP2FLD | 40 | 出力 | 表示専用 | 処理結果メッセージ表示領域 |

## 表示項目

| 項目名 | 位置 | 説明 |
|--------|------|------|
| トランザクションID | 行1、列1 | 「SSP2」固定表示 |
| 画面タイトル | 行1、列12 | 「General Insurance Endowment Policy Menu」固定表示 |
| メニュー選択肢 | 行4-7、列8 | 「1. Policy Inquiry」「2. Policy Add」「3. Policy Delete」「4. Policy Update」 |
| 各入力項目ラベル | 行4-15、列30 | 各フィールドのラベル表示 |
| 日付フォーマットヒント | 行6,7、列63 | 「(yyyy-mm-dd)」形式ガイド |
| オプション選択ラベル | 行22、列8 | 「Select Option」 |

## イベント仕様

### 1-オプション1選択（ポリシー照会）

**トリガー**: オプション欄に「1」を入力してENTERキー押下

**処理フロー**:
1. 画面から顧客番号（ENP2CNO）とポリシー番号（ENP2PNO）を取得
2. CA-REQUEST-IDに「01IEND」を設定
3. LGIPOL01プログラムをCICS LINKで呼び出し（COMMAREA長: 32500バイト）
4. CA-RETURN-CODEが0より大きい場合、「No data was returned.」メッセージを表示
5. 正常時は取得したポリシー情報を画面フィールドに設定して再表示

### 2-オプション2選択（ポリシー登録）

**トリガー**: オプション欄に「2」を入力してENTERキー押下

**処理フロー**:
1. 画面からポリシー情報（顧客番号、発行日、有効期限、ファンド詳細等）を取得
2. CA-REQUEST-IDに「01AEND」を設定
3. CA-PAYMENTとCA-BROKERIDに0、CA-BROKERSREFに空白を設定
4. 入力データをCOMMAREA（CA-ENDOWMENT構造体）にマッピング
5. LGAPOL01プログラムをCICS LINKで呼び出し
6. CA-RETURN-CODEが70の場合、「Customer does not exist」を表示
7. その他エラー時はSYNCPOINT ROLLBACKを実行し「Error Adding Life Policy」を表示
8. 正常時は自動採番されたポリシー番号と「New Life Policy Inserted」を表示

### 3-オプション3選択（ポリシー削除）

**トリガー**: オプション欄に「3」を入力してENTERキー押下

**処理フロー**:
1. 画面から顧客番号（ENP2CNO）とポリシー番号（ENP2PNO）を取得
2. CA-REQUEST-IDに「01DEND」を設定
3. LGDPOL01プログラムをCICS LINKで呼び出し
4. エラー時はSYNCPOINT ROLLBACKを実行し「Error Deleting Life Policy」を表示
5. 正常時は画面のポリシー詳細フィールドをクリアし「Life Policy Deleted」を表示

### 4-オプション4選択（ポリシー更新）

**トリガー**: オプション欄に「4」を入力してENTERキー押下

**処理フロー**:
1. まずCA-REQUEST-IDに「01IEND」を設定し、LGIPOL01で既存データを照会・表示
2. ユーザーが情報を修正してENTERキー押下
3. CA-REQUEST-IDに「01UEND」を設定
4. 修正データをCOMMAREAにマッピング
5. LGUPOL01プログラムをCICS LINKで呼び出し
6. エラー時は「Error Updating Life Policy」を表示
7. 正常時は「Life Policy Updated」を表示

### 5-CLEARキー押下

**トリガー**: CLEARキー押下

**処理フロー**:
1. 画面フィールドを初期化
2. SSMAPP2マップを再表示（SEND MAP MAPONLY）
3. トランザクションSSP2を継続

### 6-PF3キー押下

**トリガー**: PF3キー押下

**処理フロー**:
1. 「Transaction ended」メッセージを表示
2. CICSにRETURNしてトランザクション終了

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オプション1（照会） | POLICY, ENDOWMENT | SELECT | ポリシー番号・顧客番号をキーにポリシー情報を取得 |
| オプション2（登録） | POLICY, ENDOWMENT | INSERT | 新規養老保険ポリシーレコードを登録 |
| オプション3（削除） | POLICY, ENDOWMENT | DELETE | ポリシー番号をキーにポリシーを削除 |
| オプション4（更新） | POLICY, ENDOWMENT | UPDATE | ポリシー番号をキーにポリシー情報を更新 |

### テーブル別更新項目詳細

#### POLICY/ENDOWMENTテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT/INSERT/UPDATE | CA-POLICY-NUM | ポリシー番号 | キー項目 |
| SELECT/INSERT/UPDATE | CA-CUSTOMER-NUM | 顧客番号 | 外部キー |
| INSERT/UPDATE | CA-ISSUE-DATE | 発行日 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-EXPIRY-DATE | 有効期限 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-E-FUND-NAME | ファンド名 | 10桁 |
| INSERT/UPDATE | CA-E-TERM | 期間 | 2桁数字 |
| INSERT/UPDATE | CA-E-SUM-ASSURED | 保証額 | 6桁数字 |
| INSERT/UPDATE | CA-E-LIFE-ASSURED | 被保険者名 | 31桁 |
| INSERT/UPDATE | CA-E-WITH-PROFITS | 利益配当有無 | 1桁（Y/N） |
| INSERT/UPDATE | CA-E-EQUITIES | 株式投資 | 1桁（Y/N） |
| INSERT/UPDATE | CA-E-MANAGED-FUND | マネージドファンド | 1桁（Y/N） |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|---------|------|
| MSG001 | New Life Policy Inserted | ポリシー登録成功時 | 成功 |
| MSG002 | Life Policy Updated | ポリシー更新成功時 | 成功 |
| MSG003 | Life Policy Deleted | ポリシー削除成功時 | 成功 |
| MSG004 | No data was returned. | 照会結果が0件の場合 | 警告 |
| MSG005 | Customer does not exist | 登録時に顧客が存在しない場合（RC=70） | エラー |
| MSG006 | Error Adding Life Policy | ポリシー登録失敗時 | エラー |
| MSG007 | Error Updating Life Policy | ポリシー更新失敗時 | エラー |
| MSG008 | Error Deleting Life Policy | ポリシー削除失敗時 | エラー |
| MSG009 | Please enter a valid option | 無効なオプション入力時 | エラー |
| MSG010 | Transaction ended | PF3押下時 | 情報 |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| COMMEAREAなし | アベンドコード「LGCA」で異常終了（NODUMP） |
| COMMAREA長不足 | CA-RETURN-CODEに「98」を設定してリターン |
| 無効なリクエストID | CA-RETURN-CODEに「99」を設定してリターン |
| 顧客不存在（RC=70） | 「Customer does not exist」を表示して画面再表示 |
| データ未検出 | 「No data was returned.」を表示して画面再表示 |
| 登録エラー | SYNCPOINT ROLLBACKを実行、エラーメッセージ表示後、画面を初期化して再表示 |
| 削除エラー | SYNCPOINT ROLLBACKを実行、エラーメッセージ表示後、画面を初期化して再表示 |
| 更新エラー | エラーメッセージ表示後、画面を初期化して再表示 |
| MAPFAIL | トランザクション終了 |

## 備考

- ポリシー番号・顧客番号は10桁の数値で、右寄せゼロ埋め形式
- 養老保険は「Life Policy」として画面メッセージに表示される
- 被保険者名（Life Assured）は画面表示25桁だが、COMMAREA上は31桁で定義されている
- 利益配当有無、株式投資、マネージドファンドは各1桁のフラグ項目（Y/N等）
- 登録時、顧客が存在しない場合はリターンコード70が返却される
- CA-ENDOWMENT構造体（lgcmarea.cpy行46-54）にポリシー固有データが格納される
- ビジネスロジックプログラム（LGIPOL01, LGAPOL01, LGDPOL01, LGUPOL01）はCICS LINKコマンドで呼び出され、COMMエリア長は32500バイト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造（COMMAREA）を理解することが重要。養老保険ポリシーデータはCA-ENDOWMENT構造体として定義されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-REQUEST-ID（6桁）とCA-POLICY-REQUEST構造（行34-44）でポリシー基本情報を定義 |
| 1-2 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-ENDOWMENT（行46-54）で養老保険固有フィールド（ファンド名、期間、保証額等）を定義 |

**読解のコツ**: CA-ENDOWMENT構造体には利益配当(CA-E-WITH-PROFITS)、株式(CA-E-EQUITIES)、マネージドファンド(CA-E-MANAGED-FUND)の3つのフラグ項目がある。

#### Step 2: 画面レイアウト（BMS）を理解する

画面項目の配置と属性を定義するBMSマップを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | SSMAPP2マップ定義（行237-340）：養老保険ポリシーメニュー画面 |

**主要フィールド定義**:
- **行253**: ENP2PNO - ポリシー番号入力（10桁、右寄せゼロ埋め）
- **行260**: ENP2CNO - 顧客番号入力（10桁、右寄せゼロ埋め）
- **行267**: ENP2IDA - 発行日（10桁、yyyy-mm-dd形式）
- **行276**: ENP2EDA - 有効期限（10桁）
- **行285**: ENP2FNM - ファンド名（10桁）
- **行292**: ENP2TER - 期間（2桁）
- **行299**: ENP2SUM - 保証額（6桁、右寄せゼロ埋め）
- **行306**: ENP2LIF - 被保険者名（25桁）
- **行313**: ENP2WPR - 利益配当有無（1桁）
- **行334**: ENP2OPT - オプション選択（1桁）
- **行339**: ERP2FLD - メッセージ表示領域（40桁）

#### Step 3: メインプログラム（プレゼンテーション層）を理解する

画面制御とビジネスロジック呼び出しを行うメインプログラムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp2.cbl | `base/src/lgtestp2.cbl` | MAINLINE SECTION（行30-）：初回表示時のマップ送信と初期値設定 |
| 3-2 | lgtestp2.cbl | `base/src/lgtestp2.cbl` | A-GAIN（行47-）：AID処理とマップ受信 |
| 3-3 | lgtestp2.cbl | `base/src/lgtestp2.cbl` | EVALUATE ENP2OPTO（行61-231）：オプション分岐処理の中核 |

**主要処理フロー**:
1. **行32-33**: EIBCALENチェック - 初回起動判定
2. **行35-39**: 初期化 - 画面とCOMMAREAの初期化、数値フィールドのゼロ埋め
3. **行42-45**: EXEC CICS SEND MAP - 初期画面表示
4. **行49-54**: HANDLE AID/CONDITION - キー操作とエラーハンドリング設定
5. **行56-58**: EXEC CICS RECEIVE MAP - 画面入力受信
6. **行61-231**: EVALUATE文 - オプション値による処理分岐
   - **行63-88**: WHEN '1' - ポリシー照会（LGIPOL01、リクエストID: 01IEND）
   - **行90-123**: WHEN '2' - ポリシー登録（LGAPOL01、リクエストID: 01AEND）
   - **行125-153**: WHEN '3' - ポリシー削除（LGDPOL01、リクエストID: 01DEND）
   - **行155-216**: WHEN '4' - ポリシー更新（LGIPOL01→LGUPOL01、リクエストID: 01UEND）
   - **行218-229**: WHEN OTHER - 無効オプションエラー

#### Step 4: エラー処理を理解する

各種エラー条件と処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgtestp2.cbl | `base/src/lgtestp2.cbl` | NO-ADD（行268-276）：登録エラー処理、RC=70は顧客不存在 |
| 4-2 | lgtestp2.cbl | `base/src/lgtestp2.cbl` | ERROR-OUT（行290-300）：共通エラー処理、画面再表示と初期化 |

**主要処理フロー**:
- **行269-276**: CA-RETURN-CODE=70の場合は「Customer does not exist」を表示
- **行110, 134**: 登録・削除エラー時はSYNCPOINT ROLLBACKでトランザクション取消

### プログラム呼び出し階層図

```
LGTESTP2（プレゼンテーションプログラム）
    │
    ├─ LGIPOL01（ポリシー照会）──→ LGIPDB01（Db2アクセス）
    │
    ├─ LGAPOL01（ポリシー登録）──→ LGAPDB01（Db2アクセス）
    │
    ├─ LGDPOL01（ポリシー削除）──→ LGDPDB01（Db2アクセス）
    │
    └─ LGUPOL01（ポリシー更新）──→ LGUPDB01（Db2アクセス）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

3270端末                  LGTESTP2                   POLICY/ENDOWMENTテーブル
    │                         │                                 │
    │ ①画面入力              │                                 │
    │  (ENP2PNO, ENP2CNO,    │                                 │
    │   ENP2FNM等)           │                                 │
    ├────────────────────▶    │                                 │
    │                         │ ②COMMAREA設定                  │
    │                         │   CA-REQUEST-ID (01IEND等)      │
    │                         │   CA-POLICY-NUM                 │
    │                         │   CA-ENDOWMENT構造体            │
    │                         │                                 │
    │                         ├─────▶ LGIPOL01/LGAPOL01等       │
    │                         │              │                  │
    │                         │              │ ③CICS LINK       │
    │                         │              ├─────────────────▶│
    │                         │              │                  │
    │                         │ ④結果受信   │                  │
    │                         │◀─────────────┤                  │
    │                         │              │                  │
    │ ⑤画面表示              │                                 │
    │◀────────────────────────┤                                 │
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestp2.cbl | `base/src/lgtestp2.cbl` | COBOLソース | 養老保険メニュー画面制御プログラム |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面レイアウト定義（SSMAPP2部分） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | COBOLコピー句 | COMMAREA構造定義（CA-ENDOWMENT含む） |
| lgipol01.cbl | `base/src/lgipol01.cbl` | COBOLソース | ポリシー照会ビジネスロジック |
| lgapol01.cbl | `base/src/lgapol01.cbl` | COBOLソース | ポリシー登録ビジネスロジック |
| lgdpol01.cbl | `base/src/lgdpol01.cbl` | COBOLソース | ポリシー削除ビジネスロジック |
| lgupol01.cbl | `base/src/lgupol01.cbl` | COBOLソース | ポリシー更新ビジネスロジック |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | COBOLソース | ポリシー照会Db2アクセス |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | COBOLソース | ポリシー登録Db2アクセス |
| lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | COBOLソース | ポリシー削除Db2アクセス |
| lgupdb01.cbl | `base/src/lgupdb01.cbl` | COBOLソース | ポリシー更新Db2アクセス |
