# 画面設計書 4-住宅保険ポリシーメニュー画面

## 概要

本ドキュメントは、GenApp（General Insurance Application）における住宅保険ポリシーメニュー画面（SSMAPP3）の設計仕様を定義する。この画面は住宅保険（House）ポリシーの照会・登録・削除・更新を行うためのインターフェースである。

### 本画面の処理概要

**業務上の目的・背景**：
住宅保険は個人向け損害保険の主要商品であり、物件情報（タイプ、寝室数、住宅価値、住所）と連動したポリシー管理が必要である。本画面は、住宅保険ポリシーのライフサイクル全体（新規契約、内容照会、契約変更、契約解約）を一元的に管理するために提供されている。オペレーターは物件の詳細情報と保険条件（発行日、有効期限）を組み合わせてポリシーを管理できる。

**画面へのアクセス方法**：
3270端末からCICSトランザクションID「SSP3」を入力することで本画面にアクセスする。CICSリージョンにサインオン後、コマンドラインに「SSP3」と入力しENTERキーを押下することで画面が表示される。

**主要な操作・処理内容**：
1. **ポリシー照会（オプション1）**：ポリシー番号と顧客番号を入力し、オプション「1」を選択してENTERキーを押下すると、該当ポリシーの詳細情報が画面に表示される
2. **ポリシー登録（オプション2）**：顧客番号とポリシー情報（発行日、有効期限、物件タイプ、寝室数、住宅価値、住所情報）を入力し、オプション「2」を選択してENTERキーを押下すると、新規ポリシーとしてデータベースに登録される
3. **ポリシー削除（オプション3）**：ポリシー番号と顧客番号を入力し、オプション「3」を選択してENTERキーを押下すると、該当ポリシーが削除される
4. **ポリシー更新（オプション4）**：ポリシー番号と顧客番号を入力しオプション「4」を選択すると、まず既存情報が照会表示され、修正後に再度ENTERキーを押下することで更新が実行される

**画面遷移**：
- 本画面は独立したCICSトランザクションとして動作し、他画面との直接遷移はない
- CLEARキーまたはPF3キーを押下するとトランザクションが終了し、CICS画面に戻る
- 各操作完了後は同一画面（SSP3トランザクション）にRETURNし、継続操作が可能

**権限による表示制御**：
本画面には特別な権限制御は実装されていない。CICSリージョンへのアクセス権限を持つすべてのユーザーが利用可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F012 | 住宅保険登録 | 主機能 | オプション2選択時にLGAPOL01プログラムをCICS LINKで呼び出し、住宅保険ポリシーを新規作成する |
| F013 | 住宅保険照会 | 主機能 | オプション1選択時にLGIPOL01プログラムをCICS LINKで呼び出し、ポリシー詳細を照会・表示する |
| F014 | 住宅保険更新 | 主機能 | オプション4選択時にまずLGIPOL01で照会後、LGUPOL01プログラムをCICS LINKで呼び出し、ポリシーを更新する |
| F015 | 住宅保険削除 | 主機能 | オプション3選択時にLGDPOL01プログラムをCICS LINKで呼び出し、ポリシーを削除する |
| F029 | 住宅保険メニュー | 主機能 | LGTESTP3プログラムが画面SSMAPP3を表示し、住宅保険の操作メニュー機能を提供する |

## 画面種別

メニュー・登録・照会・編集・削除（複合機能画面）

## URL/ルーティング

- トランザクションID: SSP3
- BMSマップ名: SSMAPP3
- マップセット名: SSMAP
- プレゼンテーションプログラム: LGTESTP3

## 入出力項目

| 項目名 | フィールド名 | 属性 | 桁数（画面/COMM） | 入力/出力 | 必須 | 説明 |
|--------|--------------|------|-------------------|-----------|------|------|
| ポリシー番号 | ENP3PNO | 数字 | 10/10 | 入出力 | 照会・削除・更新時必須 | 右寄せゼロ埋め |
| 顧客番号 | ENP3CNO | 数字 | 10/10 | 入出力 | 必須 | 右寄せゼロ埋め |
| 発行日（Issue date） | ENP3IDA | 日付 | 10/10 | 入出力 | - | yyyy-mm-dd形式 |
| 有効期限（Expiry date） | ENP3EDA | 日付 | 10/10 | 入出力 | - | yyyy-mm-dd形式 |
| 物件タイプ（Property Type） | ENP3TYP | 英数字 | 15/15 | 入出力 | - | CA-H-PROPERTY-TYPE |
| 寝室数（Bedrooms） | ENP3BED | 数字 | 3/3 | 入出力 | - | 右寄せゼロ埋め、CA-H-BEDROOMS |
| 住宅価値（House Value） | ENP3VAL | 数字 | 8/8 | 入出力 | - | 右寄せゼロ埋め、CA-H-VALUE |
| 住所名（House Name） | ENP3HNM | 英数字 | 20/20 | 入出力 | - | CA-H-HOUSE-NAME |
| 住所番号（House Number） | ENP3HNO | 英数字 | 4/4 | 入出力 | - | CA-H-HOUSE-NUMBER |
| 郵便番号（Postcode） | ENP3HPC | 英数字 | 8/8 | 入出力 | - | CA-H-POSTCODE |
| オプション選択 | ENP3OPT | 数字 | 1/- | 入力 | 必須 | 1:照会、2:登録、3:削除、4:更新 |
| メッセージ欄 | ERP3FLD | 英数字 | 40/- | 出力 | - | 処理結果メッセージ |

## 表示項目

| 項目名 | 表示位置 | 属性 | 説明 |
|--------|----------|------|------|
| トランザクションID | 行1,列1 | 高輝度・保護（ASKIP,BRT） | 'SSP3'を表示 |
| 画面タイトル | 行1,列12 | 高輝度・保護（BRT,ASKIP） | 'General Insurance House Policy Menu' |
| メニューオプション1 | 行4,列8 | 通常・保護（NORM,ASKIP） | '1. Policy Inquiry' |
| メニューオプション2 | 行5,列8 | 通常・保護（NORM,ASKIP） | '2. Policy Add' |
| メニューオプション3 | 行6,列8 | 通常・保護（NORM,ASKIP） | '3. Policy Delete' |
| メニューオプション4 | 行7,列8 | 通常・保護（NORM,ASKIP） | '4. Policy Update' |
| 日付フォーマットガイド | 行6,列63等 | 通常・保護（NORM,ASKIP） | '(yyyy-mm-dd)' |

## イベント仕様

### 1-ENTERキー押下（オプション1: ポリシー照会）

```
1. 画面からENP3CNO（顧客番号）とENP3PNO（ポリシー番号）を取得
2. CA-REQUEST-IDに'01IHOU'を設定
3. Move ENP3CNOO To CA-CUSTOMER-NUM
4. Move ENP3PNOO To CA-POLICY-NUM
5. EXEC CICS LINK PROGRAM('LGIPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
6. CA-RETURN-CODE > 0 の場合、NO-DATAへGO TO（'No data was returned.'を表示）
7. 成功時、以下のマッピングを実行：
   - CA-ISSUE-DATE → ENP3IDAI
   - CA-EXPIRY-DATE → ENP3EDAI
   - CA-H-PROPERTY-TYPE → ENP3TYPI
   - CA-H-BEDROOMS → ENP3BEDI
   - CA-H-VALUE → ENP3VALI
   - CA-H-HOUSE-NAME → ENP3HNMI
   - CA-H-HOUSE-NUMBER → ENP3HNOI
   - CA-H-POSTCODE → ENP3HPCI
8. EXEC CICS SEND MAP ('SSMAPP3') FROM(SSMAPP3O) MAPSET('SSMAP')
9. ENDIT-STARTIT（SSP3トランザクションにRETURN）
```

### 2-ENTERキー押下（オプション2: ポリシー登録）

```
1. 画面から全入力フィールドを取得
2. CA-REQUEST-IDに'01AHOU'を設定
3. 以下のマッピングを実行：
   - ENP3CNOI → CA-CUSTOMER-NUM
   - 0 → CA-PAYMENT
   - 0 → CA-BROKERID
   - '        ' → CA-BROKERSREF
   - ENP3IDAI → CA-ISSUE-DATE
   - ENP3EDAI → CA-EXPIRY-DATE
   - ENP3TYPI → CA-H-PROPERTY-TYPE
   - ENP3BEDI → CA-H-BEDROOMS
   - ENP3VALI → CA-H-VALUE
   - ENP3HNMI → CA-H-HOUSE-NAME
   - ENP3HNOI → CA-H-HOUSE-NUMBER
   - ENP3HPCI → CA-H-POSTCODE
4. EXEC CICS LINK PROGRAM('LGAPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
5. CA-RETURN-CODE > 0 の場合：
   - EXEC CICS Syncpoint Rollback
   - NO-ADDへGO TO
6. 成功時：
   - CA-CUSTOMER-NUM → ENP3CNOI
   - CA-POLICY-NUM → ENP3PNOI（採番されたポリシー番号）
   - ' ' → ENP3OPTI
   - 'New House Policy Inserted' → ERP3FLDO
7. EXEC CICS SEND MAP ('SSMAPP3') FROM(SSMAPP3O) MAPSET('SSMAP')
8. ENDIT-STARTIT（SSP3トランザクションにRETURN）
```

### 3-ENTERキー押下（オプション3: ポリシー削除）

```
1. 画面からENP3CNO（顧客番号）とENP3PNO（ポリシー番号）を取得
2. CA-REQUEST-IDに'01DHOU'を設定
3. Move ENP3CNOO To CA-CUSTOMER-NUM
4. Move ENP3PNOO To CA-POLICY-NUM
5. EXEC CICS LINK PROGRAM('LGDPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
6. CA-RETURN-CODE > 0 の場合：
   - EXEC CICS Syncpoint Rollback
   - NO-DELETEへGO TO（'Error Deleting House Policy'を表示）
7. 成功時：
   - 全ポリシー詳細フィールドをSpacesでクリア
   - ' ' → ENP3OPTI
   - 'House Policy Deleted' → ERP3FLDO
8. EXEC CICS SEND MAP ('SSMAPP3') FROM(SSMAPP3O) MAPSET('SSMAP')
9. ENDIT-STARTIT（SSP3トランザクションにRETURN）
```

### 4-ENTERキー押下（オプション4: ポリシー更新）

```
【フェーズ1: 既存データ照会】
1. CA-REQUEST-IDに'01IHOU'を設定
2. Move ENP3CNOO To CA-CUSTOMER-NUM
3. Move ENP3PNOO To CA-POLICY-NUM
4. EXEC CICS LINK PROGRAM('LGIPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
5. CA-RETURN-CODE > 0 の場合、NO-DATAへGO TO
6. 取得データを画面フィールドにマッピング・表示
7. EXEC CICS SEND MAP ('SSMAPP3') FROM(SSMAPP3O) MAPSET('SSMAP')

【フェーズ2: ユーザー修正入力受信】
8. EXEC CICS RECEIVE MAP('SSMAPP3') INTO(SSMAPP3I) MAPSET('SSMAP')

【フェーズ3: 更新実行】
9. CA-REQUEST-IDに'01UHOU'を設定
10. 修正入力データをCOMMAREAにマッピング
11. EXEC CICS LINK PROGRAM('LGUPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
12. CA-RETURN-CODE > 0 の場合、NO-UPDへGO TO（'Error Updating House Policy'を表示）
13. 成功時：
    - CA-CUSTOMER-NUM → ENP3CNOI
    - CA-POLICY-NUM → ENP3PNOI
    - ' ' → ENP3OPTI
    - 'House Policy Updated' → ERP3FLDO
14. EXEC CICS SEND MAP ('SSMAPP3') FROM(SSMAPP3O) MAPSET('SSMAP')
15. ENDIT-STARTIT（SSP3トランザクションにRETURN）
```

### 5-CLEARキー押下

```
1. Initialize SSMAPP3I（画面入力フィールドを初期化）
2. EXEC CICS SEND MAP ('SSMAPP3') MAPSET('SSMAP') MAPONLY
3. EXEC CICS RETURN TRANSID('SSP3') COMMAREA(COMM-AREA)
```

### 6-PF3キー押下

```
1. EXEC CICS SEND TEXT FROM(MSGEND) LENGTH(24) ERASE FREEKB
   - MSGEND = 'Transaction ended      '
2. EXEC CICS RETURN（CICSにRETURN、トランザクション終了）
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オプション1（照会） | POLICY/HOUSE | SELECT | ポリシー番号と顧客番号をキーにポリシー情報を取得 |
| オプション2（登録） | POLICY/HOUSE | INSERT | 新規住宅保険ポリシーレコードを登録 |
| オプション3（削除） | POLICY/HOUSE | DELETE | ポリシー番号をキーにポリシーを削除 |
| オプション4（更新） | POLICY/HOUSE | UPDATE | ポリシー番号をキーにポリシー情報を更新 |

### テーブル別更新項目詳細

#### POLICY/HOUSE - Db2/VSAM

| 操作 | 項目（COMMAREA名） | データ型 | 桁数 | 備考 |
|-----|-------------------|---------|------|------|
| SELECT/INSERT/UPDATE | CA-POLICY-NUM | 9(10) | 10 | キー項目 |
| SELECT/INSERT/UPDATE | CA-CUSTOMER-NUM | 9(10) | 10 | 外部キー |
| INSERT/UPDATE | CA-ISSUE-DATE | X(10) | 10 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-EXPIRY-DATE | X(10) | 10 | yyyy-mm-dd形式 |
| INSERT/UPDATE | CA-H-PROPERTY-TYPE | X(15) | 15 | 物件タイプ |
| INSERT/UPDATE | CA-H-BEDROOMS | 9(3) | 3 | 寝室数 |
| INSERT/UPDATE | CA-H-VALUE | 9(8) | 8 | 住宅価値 |
| INSERT/UPDATE | CA-H-HOUSE-NAME | X(20) | 20 | 住所名 |
| INSERT/UPDATE | CA-H-HOUSE-NUMBER | X(4) | 4 | 住所番号 |
| INSERT/UPDATE | CA-H-POSTCODE | X(8) | 8 | 郵便番号 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|----------|
| MSG001 | New House Policy Inserted | 成功 | ポリシー登録成功時（lgtestp3.cbl 行117-118） |
| MSG002 | House Policy Updated | 成功 | ポリシー更新成功時（lgtestp3.cbl 行207-208） |
| MSG003 | House Policy Deleted | 成功 | ポリシー削除成功時（lgtestp3.cbl 行147-148） |
| MSG004 | No data was returned. | エラー | 照会時にデータが存在しない場合（lgtestp3.cbl 行286） |
| MSG005 | Customer does not exist | エラー | 登録時に顧客が存在しない場合（RC=70）（lgtestp3.cbl 行270） |
| MSG006 | Error Adding House Policy | エラー | ポリシー登録失敗時（Rollback実行）（lgtestp3.cbl 行273） |
| MSG007 | Error Updating House Policy | エラー | ポリシー更新失敗時（lgtestp3.cbl 行278） |
| MSG008 | Error Deleting House Policy | エラー | ポリシー削除失敗時（Rollback実行）（lgtestp3.cbl 行282） |
| MSG009 | Please enter a valid option | エラー | 無効なオプション入力時（lgtestp3.cbl 行219-220） |
| MSG010 | Transaction ended | 情報 | PF3押下によるトランザクション終了時（lgtestp3.cbl 行18-19） |

## 例外処理

| 例外条件 | 処理内容 | 画面遷移 |
|----------|----------|----------|
| ポリシーデータなし | 'No data was returned.'を表示、ERROR-OUTで画面・COMMエリア初期化 | ENDIT-STARTITで同一画面にRETURN |
| 顧客存在しない（RC=70） | 'Customer does not exist'を表示 | ERROR-OUTで同一画面にRETURN |
| ポリシー登録エラー | Syncpoint Rollback実行、'Error Adding House Policy'を表示、画面・COMMエリア初期化 | ENDIT-STARTITで同一画面にRETURN |
| ポリシー更新エラー | 'Error Updating House Policy'を表示、画面・COMMエリア初期化 | ERROR-OUTで同一画面にRETURN |
| ポリシー削除エラー | Syncpoint Rollback実行、'Error Deleting House Policy'を表示、画面・COMMエリア初期化 | ENDIT-STARTITで同一画面にRETURN |
| 無効なオプション | 'Please enter a valid option'を表示、ENP3OPTLに-1設定、CURSOR指定で再表示 | ENDIT-STARTITで同一画面にRETURN |
| MAPFAILエラー | HANDLE CONDITION MAPFAILでENDITへ | CICS画面に戻る |

## 備考

- 本画面はCICS 3270端末向けのBMSマップ（SSMAPP3）を使用
- プレゼンテーションプログラムはLGTESTP3（全300行）
- ポリシー番号・顧客番号は10桁の数字で右寄せゼロ埋め表示（JUSTIFY=(RIGHT,ZERO)）
- 登録時、顧客が存在しない場合はリターンコード70が返却される
- ビジネスロジックプログラム（LGIPOL01, LGAPOL01, LGDPOL01, LGUPOL01）はCICS LINKコマンドで呼び出され、COMMエリア長は32500バイト
- CA-HOUSE構造体（lgcmarea.cpy 行56-63）にポリシー固有データが格納される
- 住宅価値フィールドは8桁で、他のポリシー画面（自動車6桁）より大きい
- 郵便番号は顧客画面と異なり大文字変換は行われない
- 更新処理（オプション4）は2フェーズ方式：照会表示 → RECEIVE MAP → 更新実行
- ERROR-OUT処理でSSMAPP3I, SSMAPP3O, COMM-AREAをInitializeしてからRETURN
- 登録・削除時のエラーでSyncpoint Rollbackを実行し、トランザクション整合性を確保

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造（COMMAREA）を理解することが重要。住宅保険ポリシーデータはCA-HOUSE構造体として定義されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-REQUEST-ID（6桁）とCA-POLICY-REQUEST構造（行34-44）でポリシー基本情報を定義 |
| 1-2 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-HOUSE（行56-63）で住宅保険固有フィールド（物件タイプ、寝室数、価値等）を定義 |

**読解のコツ**: CA-HOUSE構造体には物件情報（CA-H-PROPERTY-TYPE、CA-H-BEDROOMS、CA-H-VALUE）と住所情報（CA-H-HOUSE-NAME、CA-H-HOUSE-NUMBER、CA-H-POSTCODE）が含まれる。

#### Step 2: 画面レイアウト（BMS）を理解する

画面項目の配置と属性を定義するBMSマップを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | SSMAPP3マップ定義（行346-443）：住宅保険ポリシーメニュー画面 |

**主要フィールド定義**:
- **行362**: ENP3PNO - ポリシー番号入力（10桁、右寄せゼロ埋め）
- **行369**: ENP3CNO - 顧客番号入力（10桁、右寄せゼロ埋め）
- **行376**: ENP3IDA - 発行日（10桁、yyyy-mm-dd形式）
- **行385**: ENP3EDA - 有効期限（10桁）
- **行394**: ENP3TYP - 物件タイプ（15桁）
- **行401**: ENP3BED - 寝室数（3桁、右寄せゼロ埋め）
- **行408**: ENP3VAL - 住宅価値（8桁、右寄せゼロ埋め）
- **行437**: ENP3OPT - オプション選択（1桁）
- **行442**: ERP3FLD - メッセージ表示領域（40桁）

#### Step 3: メインプログラム（プレゼンテーション層）を理解する

画面制御とビジネスロジック呼び出しを行うメインプログラムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp3.cbl | `base/src/lgtestp3.cbl` | MAINLINE SECTION（行30-）：初回表示時のマップ送信と初期値設定 |
| 3-2 | lgtestp3.cbl | `base/src/lgtestp3.cbl` | A-GAIN（行50-）：AID処理とマップ受信 |
| 3-3 | lgtestp3.cbl | `base/src/lgtestp3.cbl` | EVALUATE ENP3OPTO（行64-230）：オプション分岐処理の中核 |

**主要処理フロー**:
1. **行32-33**: EIBCALENチェック - 初回起動判定
2. **行35-41**: 初期化 - 画面とCOMMAREAの初期化、数値フィールドのゼロ埋め
3. **行45-48**: EXEC CICS SEND MAP - 初期画面表示
4. **行52-57**: HANDLE AID/CONDITION - キー操作とエラーハンドリング設定
5. **行59-61**: EXEC CICS RECEIVE MAP - 画面入力受信
6. **行64-230**: EVALUATE文 - オプション値による処理分岐
   - **行66-90**: WHEN '1' - ポリシー照会（LGIPOL01、リクエストID: 01IHOU）
   - **行92-123**: WHEN '2' - ポリシー登録（LGAPOL01、リクエストID: 01AHOU）
   - **行125-153**: WHEN '3' - ポリシー削除（LGDPOL01、リクエストID: 01DHOU）
   - **行155-214**: WHEN '4' - ポリシー更新（LGIPOL01→LGUPOL01、リクエストID: 01UHOU）
   - **行217-228**: WHEN OTHER - 無効オプションエラー

#### Step 4: エラー処理を理解する

各種エラー条件と処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgtestp3.cbl | `base/src/lgtestp3.cbl` | NO-ADD（行267-275）：登録エラー処理、RC=70は顧客不存在 |
| 4-2 | lgtestp3.cbl | `base/src/lgtestp3.cbl` | ERROR-OUT（行289-299）：共通エラー処理、画面再表示と初期化 |

**主要処理フロー**:
- **行268-275**: CA-RETURN-CODE=70の場合は「Customer does not exist」を表示
- **行111, 134**: 登録・削除エラー時はSYNCPOINT ROLLBACKでトランザクション取消

### プログラム呼び出し階層図

```
LGTESTP3（プレゼンテーションプログラム）
    │
    ├─ LGIPOL01（ポリシー照会）──→ LGIPDB01（Db2アクセス）
    │
    ├─ LGAPOL01（ポリシー登録）──→ LGAPDB01（Db2アクセス）
    │
    ├─ LGDPOL01（ポリシー削除）──→ LGDPDB01（Db2アクセス）
    │
    └─ LGUPOL01（ポリシー更新）──→ LGUPDB01（Db2アクセス）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

3270端末                  LGTESTP3                     POLICY/HOUSEテーブル
    │                         │                                 │
    │ ①画面入力              │                                 │
    │  (ENP3PNO, ENP3CNO,    │                                 │
    │   ENP3TYP等)           │                                 │
    ├────────────────────▶    │                                 │
    │                         │ ②COMMAREA設定                  │
    │                         │   CA-REQUEST-ID (01IHOU等)      │
    │                         │   CA-POLICY-NUM                 │
    │                         │   CA-HOUSE構造体                │
    │                         │                                 │
    │                         ├─────▶ LGIPOL01/LGAPOL01等       │
    │                         │              │                  │
    │                         │              │ ③CICS LINK       │
    │                         │              ├─────────────────▶│
    │                         │              │                  │
    │                         │ ④結果受信   │                  │
    │                         │◀─────────────┤                  │
    │                         │              │                  │
    │ ⑤画面表示              │                                 │
    │◀────────────────────────┤                                 │
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestp3.cbl | `base/src/lgtestp3.cbl` | COBOLソース | 住宅保険メニュー画面制御プログラム |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面レイアウト定義（SSMAPP3部分） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | COBOLコピー句 | COMMAREA構造定義（CA-HOUSE含む） |
| lgipol01.cbl | `base/src/lgipol01.cbl` | COBOLソース | ポリシー照会ビジネスロジック |
| lgapol01.cbl | `base/src/lgapol01.cbl` | COBOLソース | ポリシー登録ビジネスロジック |
| lgdpol01.cbl | `base/src/lgdpol01.cbl` | COBOLソース | ポリシー削除ビジネスロジック |
| lgupol01.cbl | `base/src/lgupol01.cbl` | COBOLソース | ポリシー更新ビジネスロジック |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | COBOLソース | ポリシー照会Db2アクセス |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | COBOLソース | ポリシー登録Db2アクセス |
| lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | COBOLソース | ポリシー削除Db2アクセス |
| lgupdb01.cbl | `base/src/lgupdb01.cbl` | COBOLソース | ポリシー更新Db2アクセス |
