# 画面設計書 5-商業用不動産保険ポリシーメニュー画面

## 概要

本ドキュメントは、GenApp（General Insurance Application）における商業用不動産保険ポリシーメニュー画面（SSMAPP4）の設計仕様を定義する。この画面は商業用不動産保険（Commercial）ポリシーの照会・登録・削除を行うためのインターフェースである。

### 本画面の処理概要

**業務上の目的・背景**：
商業用不動産保険は企業向けの損害保険商品であり、物件の位置情報（住所、郵便番号、緯度経度）と複数のリスク項目（火災、犯罪、洪水、天候）ごとのリスク評価・保険料の管理が必要である。本画面は、商業用不動産保険ポリシーの新規契約、内容照会、契約解約を管理するために提供されている。リスク評価に基づくステータス管理（承認/却下）と却下理由の記録も行える。

**画面へのアクセス方法**：
3270端末からCICSトランザクションID「SSP4」を入力することで本画面にアクセスする。CICSリージョンにサインオン後、コマンドラインに「SSP4」と入力しENTERキーを押下することで画面が表示される。

**主要な操作・処理内容**：
1. **ポリシー照会（オプション1）**：複数の検索条件（顧客番号+ポリシー番号、ポリシー番号のみ、顧客番号のみ、郵便番号のみ）を指定して検索可能
2. **ポリシー登録（オプション2）**：顧客番号とポリシー情報（物件詳細、各種リスク情報、ステータス等）を入力し、オプション「2」を選択してENTERキーを押下すると、新規ポリシーとしてデータベースに登録される
3. **ポリシー削除（オプション3）**：ポリシー番号と顧客番号を入力し、オプション「3」を選択してENTERキーを押下すると、該当ポリシーが削除される

**画面遷移**：
- 本画面は独立したCICSトランザクションとして動作し、他画面との直接遷移はない
- CLEARキーまたはPF3キーを押下するとトランザクションが終了し、CICS画面に戻る
- 各操作完了後は同一画面（SSP4トランザクション）にRETURNし、継続操作が可能

**権限による表示制御**：
本画面には特別な権限制御は実装されていない。CICSリージョンへのアクセス権限を持つすべてのユーザーが利用可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| F016 | 商業用不動産保険登録 | 主機能 | オプション2選択時にLGAPOL01プログラムをCICS LINKで呼び出し、商業用不動産保険ポリシーを新規作成する |
| F017 | 商業用不動産保険照会 | 主機能 | オプション1選択時にLGIPOL01プログラムをCICS LINKで呼び出し、ポリシー詳細を照会・表示する |
| F019 | 商業用不動産保険削除 | 主機能 | オプション3選択時にLGDPOL01プログラムをCICS LINKで呼び出し、ポリシーを削除する |
| F030 | 商業用不動産保険メニュー | 主機能 | LGTESTP4プログラムが画面SSMAPP4を表示し、商業用不動産保険の操作メニュー機能を提供する |

## 画面種別

メニュー・登録・照会・削除（複合機能画面）

## URL/ルーティング

- トランザクションID: SSP4
- BMSマップ名: SSMAPP4
- マップセット名: SSMAP
- プレゼンテーションプログラム: LGTESTP4

## 入出力項目

| 項目名 | フィールド名 | 属性 | 桁数（画面/COMM） | 入力/出力 | 必須 | 説明 |
|--------|--------------|------|-------------------|-----------|------|------|
| ポリシー番号 | ENP4PNO | 数字 | 10/10 | 入出力 | 照会・削除時条件 | 右寄せゼロ埋め |
| 顧客番号 | ENP4CNO | 数字 | 10/10 | 入出力 | 登録時必須 | 右寄せゼロ埋め |
| 開始日（Start date） | ENP4IDA | 日付 | 10/10 | 入出力 | - | yyyy-mm-dd形式 |
| 有効期限（Expiry date） | ENP4EDA | 日付 | 10/10 | 入出力 | - | yyyy-mm-dd形式 |
| 住所（Address） | ENP4ADD | 英数字 | 25/255 | 入出力 | - | CA-B-Address |
| 郵便番号（Postcode） | ENP4HPC | 英数字 | 8/8 | 入出力 | 照会条件可 | CA-B-Postcode |
| 緯度（Latitude） | ENP4LAT | 数字 | 11/11 | 入出力 | - | 右寄せゼロ埋め、CA-B-Latitude |
| 経度（Longitude） | ENP4LON | 数字 | 11/11 | 入出力 | - | 右寄せゼロ埋め、CA-B-Longitude |
| 顧客名（Customer Name） | ENP4CUS | 英数字 | 25/255 | 入出力 | - | CA-B-Customer |
| 物件タイプ（Property Type） | ENP4PTY | 英数字 | 25/255 | 入出力 | - | CA-B-PropType |
| 火災リスク（Fire Peril） | ENP4FPE | 数字 | 4/4 | 入出力 | - | 右寄せゼロ埋め、CA-B-FirePeril |
| 火災保険料（Fire Premium） | ENP4FPR | 数字 | 8/8 | 入出力 | - | 右寄せゼロ埋め、CA-B-FirePremium |
| 犯罪リスク（Crime Peril） | ENP4CPE | 数字 | 4/4 | 入出力 | - | 右寄せゼロ埋め、CA-B-CrimePeril |
| 犯罪保険料（Crime Premium） | ENP4CPR | 数字 | 8/8 | 入出力 | - | 右寄せゼロ埋め、CA-B-CrimePremium |
| 洪水リスク（Flood Peril） | ENP4XPE | 数字 | 4/4 | 入出力 | - | 右寄せゼロ埋め、CA-B-FloodPeril |
| 洪水保険料（Flood Premium） | ENP4XPR | 数字 | 8/8 | 入出力 | - | 右寄せゼロ埋め、CA-B-FloodPremium |
| 天候リスク（Weather Peril） | ENP4WPE | 数字 | 4/4 | 入出力 | - | 右寄せゼロ埋め、CA-B-WeatherPeril |
| 天候保険料（Weather Premium） | ENP4WPR | 数字 | 8/8 | 入出力 | - | 右寄せゼロ埋め、CA-B-WeatherPremium |
| ステータス（Status） | ENP4STA | 数字 | 4/4 | 入出力 | - | 右寄せゼロ埋め、CA-B-Status |
| 却下理由（Reject Reason） | ENP4REJ | 英数字 | 25/255 | 入出力 | - | CA-B-RejectReason |
| オプション選択 | ENP4OPT | 数字 | 1/- | 入力 | 必須 | 1:照会、2:登録、3:削除 |
| メッセージ欄 | ERP4FLD | 英数字 | 40/- | 出力 | - | 処理結果メッセージ |

## 表示項目

| 項目名 | 表示位置 | 属性 | 説明 |
|--------|----------|------|------|
| トランザクションID | 行1,列1 | 高輝度・保護（ASKIP,BRT） | 'SSP4'を表示 |
| 画面タイトル | 行1,列12 | 高輝度・保護（BRT,ASKIP） | 'General Insurance Commercial Policy Menu' |
| メニューオプション1 | 行4,列8 | 通常・保護（NORM,ASKIP） | '1. Policy Inquiry' |
| メニューオプション2 | 行5,列8 | 通常・保護（NORM,ASKIP） | '2. Policy Add' |
| メニューオプション3 | 行6,列8 | 通常・保護（NORM,ASKIP） | '3. Policy Delete' |
| 日付フォーマットガイド | 行6,列63等 | 通常・保護（NORM,ASKIP） | '(yyyy-mm-dd)' |

**注意**: オプション4（Policy Update）はBMSマップ上でコメントアウトされており（ssmap.bms 行460-461）、画面には表示されない。

## イベント仕様

### 1-ENTERキー押下（オプション1: ポリシー照会）

照会は4種類の検索パターンをサポート：

```
【パターン判定処理】
If ENP4CNO有効 AND ENP4PNO有効 Then
    パターン1: 顧客番号+ポリシー番号指定（01ICOM）
Else If ENP4PNO有効 Then
    パターン2: ポリシー番号のみ指定（02ICOM）
Else If ENP4CNO有効 Then
    パターン3: 顧客番号のみ指定（03ICOM）
Else If ENP4HPC有効 Then
    パターン4: 郵便番号のみ指定（05ICOM）
End-If

※有効判定: Not = Spaces AND Not = Low-Values AND Not = 0 AND Not = 0000000000（または00000000）
```

**パターン1: 顧客番号+ポリシー番号指定**
```
1. CA-REQUEST-IDに'01ICOM'を設定
2. Move ENP4CNOO To CA-CUSTOMER-NUM
3. Move ENP4PNOO To CA-POLICY-NUM
```

**パターン2: ポリシー番号のみ指定**
```
1. CA-REQUEST-IDに'02ICOM'を設定
2. Move ENP4PNOO To CA-POLICY-NUM
```

**パターン3: 顧客番号のみ指定**
```
1. CA-REQUEST-IDに'03ICOM'を設定
2. Move ENP4CNOO To CA-CUSTOMER-NUM
```

**パターン4: 郵便番号のみ指定**
```
1. CA-REQUEST-IDに'05ICOM'を設定
2. Move ENP4HPCO To CA-B-PostCode
```

**共通処理**
```
4. EXEC CICS LINK PROGRAM('LGIPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
5. CA-RETURN-CODE > 0 の場合、NO-DATAへGO TO（'No data was returned.'を表示）
6. 成功時、以下のマッピングを実行：
   - CA-POLICY-NUM → ENP4PNOI
   - CA-CUSTOMER-NUM → ENP4CNOI
   - CA-ISSUE-DATE → ENP4IDAI
   - CA-EXPIRY-DATE → ENP4EDAI
   - CA-B-Address → ENP4ADDI
   - CA-B-Postcode → ENP4HPCI
   - CA-B-Latitude → ENP4LATI
   - CA-B-Longitude → ENP4LONI
   - CA-B-Customer → ENP4CUSI
   - CA-B-PropType → ENP4PTYI
   - CA-B-FirePeril → ENP4FPEI
   - CA-B-FirePremium → ENP4FPRI
   - CA-B-CrimePeril → ENP4CPEI
   - CA-B-CrimePremium → ENP4CPRI
   - CA-B-FloodPeril → ENP4XPEI
   - CA-B-FloodPremium → ENP4XPRI
   - CA-B-WeatherPeril → ENP4WPEI
   - CA-B-WeatherPremium → ENP4WPRI
   - CA-B-Status → ENP4STAI
   - CA-B-RejectReason → ENP4REJI
7. EXEC CICS SEND MAP ('SSMAPP4') FROM(SSMAPP4O) MAPSET('SSMAP')
8. ENDIT-STARTIT（SSP4トランザクションにRETURN）
```

### 2-ENTERキー押下（オプション2: ポリシー登録）

```
1. CA-REQUEST-IDに'01ACOM'を設定
2. 以下のマッピングを実行：
   - ENP4CNOO → CA-CUSTOMER-NUM
   - ENP4IDAO → CA-ISSUE-DATE
   - ENP4EDAO → CA-EXPIRY-DATE
   - ENP4ADDO → CA-B-Address
   - ENP4HPCO → CA-B-Postcode
   - ENP4LATO → CA-B-Latitude
   - ENP4LONO → CA-B-Longitude
   - ENP4CUSO → CA-B-Customer
   - ENP4PTYO → CA-B-PropType
   - ENP4FPEO → CA-B-FirePeril
   - ENP4FPRO → CA-B-FirePremium
   - ENP4CPEO → CA-B-CrimePeril
   - ENP4CPRO → CA-B-CrimePremium
   - ENP4XPEO → CA-B-FloodPeril
   - ENP4XPRO → CA-B-FloodPremium
   - ENP4WPEO → CA-B-WeatherPeril
   - ENP4WPRO → CA-B-WeatherPremium
   - ENP4STAO → CA-B-Status
   - ENP4REJO → CA-B-RejectReason
3. EXEC CICS LINK PROGRAM('LGAPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
4. CA-RETURN-CODE > 0 の場合：
   - EXEC CICS Syncpoint Rollback
   - NO-ADDへGO TO
5. 成功時：
   - CA-CUSTOMER-NUM → ENP4CNOI
   - CA-POLICY-NUM → ENP4PNOI（採番されたポリシー番号）
   - ' ' → ENP4OPTI
   - 'New Commercial Policy Inserted' → ERP4FLDO
6. EXEC CICS SEND MAP ('SSMAPP4') FROM(SSMAPP4O) MAPSET('SSMAP')
7. ENDIT-STARTIT（SSP4トランザクションにRETURN）
```

### 3-ENTERキー押下（オプション3: ポリシー削除）

```
1. CA-REQUEST-IDに'01DCOM'を設定
2. Move ENP4CNOO To CA-CUSTOMER-NUM
3. Move ENP4PNOO To CA-POLICY-NUM
4. EXEC CICS LINK PROGRAM('LGDPOL01') COMMAREA(COMM-AREA) LENGTH(32500)
5. CA-RETURN-CODE > 0 の場合：
   - EXEC CICS Syncpoint Rollback
   - NO-DELETEへGO TO（'Error Deleting Commercial Policy'を表示）
6. 成功時：
   - 全ポリシー詳細フィールドをSpacesでクリア
   - ' ' → ENP4OPTI
   - 'Commercial Policy Deleted' → ERP4FLDO
7. EXEC CICS SEND MAP ('SSMAPP4') FROM(SSMAPP4O) MAPSET('SSMAP')
8. ENDIT-STARTIT（SSP4トランザクションにRETURN）
```

### 4-CLEARキー押下

```
1. Initialize SSMAPP4I（画面入力フィールドを初期化）
2. EXEC CICS SEND MAP ('SSMAPP4') MAPSET('SSMAP') MAPONLY
3. EXEC CICS RETURN TRANSID('SSP4') COMMAREA(COMM-AREA)
```

### 5-PF3キー押下

```
1. EXEC CICS SEND TEXT FROM(MSGEND) LENGTH(24) ERASE FREEKB
   - MSGEND = 'Transaction ended      '
2. EXEC CICS RETURN（CICSにRETURN、トランザクション終了）
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オプション1（照会） | POLICY/COMMERCIAL | SELECT | 複数キー条件でポリシー情報を取得 |
| オプション2（登録） | POLICY/COMMERCIAL | INSERT | 新規商業用不動産保険ポリシーレコードを登録 |
| オプション3（削除） | POLICY/COMMERCIAL | DELETE | ポリシー番号をキーにポリシーを削除 |

### テーブル別更新項目詳細

#### POLICY/COMMERCIAL - Db2/VSAM

| 操作 | 項目（COMMAREA名） | データ型 | 桁数 | 備考 |
|-----|-------------------|---------|------|------|
| SELECT/INSERT | CA-POLICY-NUM | 9(10) | 10 | キー項目 |
| SELECT/INSERT | CA-CUSTOMER-NUM | 9(10) | 10 | 外部キー |
| INSERT | CA-ISSUE-DATE | X(10) | 10 | yyyy-mm-dd形式 |
| INSERT | CA-EXPIRY-DATE | X(10) | 10 | yyyy-mm-dd形式 |
| INSERT | CA-B-Address | X(255) | 255 | 住所 |
| INSERT | CA-B-Postcode | X(8) | 8 | 郵便番号（検索キー可） |
| INSERT | CA-B-Latitude | X(11) | 11 | 緯度 |
| INSERT | CA-B-Longitude | X(11) | 11 | 経度 |
| INSERT | CA-B-Customer | X(255) | 255 | 顧客名 |
| INSERT | CA-B-PropType | X(255) | 255 | 物件タイプ |
| INSERT | CA-B-FirePeril | 9(4) | 4 | 火災リスク |
| INSERT | CA-B-FirePremium | 9(8) | 8 | 火災保険料 |
| INSERT | CA-B-CrimePeril | 9(4) | 4 | 犯罪リスク |
| INSERT | CA-B-CrimePremium | 9(8) | 8 | 犯罪保険料 |
| INSERT | CA-B-FloodPeril | 9(4) | 4 | 洪水リスク |
| INSERT | CA-B-FloodPremium | 9(8) | 8 | 洪水保険料 |
| INSERT | CA-B-WeatherPeril | 9(4) | 4 | 天候リスク |
| INSERT | CA-B-WeatherPremium | 9(8) | 8 | 天候保険料 |
| INSERT | CA-B-Status | 9(4) | 4 | ステータス |
| INSERT | CA-B-RejectReason | X(255) | 255 | 却下理由 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|----------|
| MSG001 | New Commercial Policy Inserted | 成功 | ポリシー登録成功時（lgtestp4.cbl 行189-190） |
| MSG002 | Commercial Policy Deleted | 成功 | ポリシー削除成功時（lgtestp4.cbl 行228-229） |
| MSG003 | No data was returned. | エラー | 照会時にデータが存在しない場合（lgtestp4.cbl 行305） |
| MSG004 | Customer does not exist | エラー | 登録時に顧客が存在しない場合（RC=70）（lgtestp4.cbl 行289） |
| MSG005 | Error Adding Commercial Policy | エラー | ポリシー登録失敗時（Rollback実行）（lgtestp4.cbl 行292） |
| MSG006 | Error Deleting Commercial Policy | エラー | ポリシー削除失敗時（Rollback実行）（lgtestp4.cbl 行301） |
| MSG007 | Please enter a valid option | エラー | 無効なオプション入力時（lgtestp4.cbl 行238-239） |
| MSG008 | Transaction ended | 情報 | PF3押下によるトランザクション終了時（lgtestp4.cbl 行18-19） |

## 例外処理

| 例外条件 | 処理内容 | 画面遷移 |
|----------|----------|----------|
| ポリシーデータなし | 'No data was returned.'を表示、ERROR-OUTで画面・COMMエリア初期化 | ENDIT-STARTITで同一画面にRETURN |
| 顧客存在しない（RC=70） | 'Customer does not exist'を表示 | ERROR-OUTで同一画面にRETURN |
| ポリシー登録エラー | Syncpoint Rollback実行、'Error Adding Commercial Policy'を表示、画面・COMMエリア初期化 | ENDIT-STARTITで同一画面にRETURN |
| ポリシー削除エラー | Syncpoint Rollback実行、'Error Deleting Commercial Policy'を表示、画面・COMMエリア初期化 | ENDIT-STARTITで同一画面にRETURN |
| 無効なオプション | 'Please enter a valid option'を表示、ENP4OPTLに-1設定、CURSOR指定で再表示 | ENDIT-STARTITで同一画面にRETURN |
| MAPFAILエラー | HANDLE CONDITION MAPFAILでENDITへ | CICS画面に戻る |

## 備考

- 本画面はCICS 3270端末向けのBMSマップ（SSMAPP4）を使用
- プレゼンテーションプログラムはLGTESTP4（全319行）
- ポリシー番号・顧客番号は10桁の数字で右寄せゼロ埋め表示（JUSTIFY=(RIGHT,ZERO)）
- **更新機能（オプション4）はBMSマップ上でコメントアウトされており（ssmap.bms 行460-461）、現在利用不可**
  - LGTESTP4プログラム内にNO-UPDセクション（行296-298）が存在するが、呼び出し元がない
- 照会機能は4種類の検索パターンをサポート（lgtestp4.cbl 行73-120）：
  - 01ICOM: 顧客番号+ポリシー番号
  - 02ICOM: ポリシー番号のみ
  - 03ICOM: 顧客番号のみ
  - 05ICOM: 郵便番号のみ
- 登録時、顧客が存在しない場合はリターンコード70が返却される
- ビジネスロジックプログラム（LGIPOL01, LGAPOL01, LGDPOL01）はCICS LINKコマンドで呼び出され、COMMエリア長は32500バイト
- CA-COMMERCIAL構造体（lgcmarea.cpy 行77-94）にポリシー固有データが格納される
- COMMAREA上の文字列項目（住所、顧客名、物件タイプ、却下理由）は255桁だが、画面表示は25桁に制限
- 4種類のリスク項目（火災、犯罪、洪水、天候）それぞれにリスク値（4桁）と保険料（8桁）のペアが設定可能
- 画面初期化時、リスク・保険料フィールドはLOW-VALUESで初期化される（lgtestp4.cbl 行40-48）
- ERROR-OUT処理でSSMAPP4I, SSMAPP4O, COMM-AREAをInitializeしてからRETURN

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造体の全体像を把握。CA-REQUEST-ID、CA-RETURN-CODE、CA-CUSTOMER-NUM、CA-POLICY-NUMの共通項目と、CA-COMMERCIAL（行77-94）の商業用不動産保険固有フィールドを理解する |

**読解のコツ**: COBOLのCOPY文は他言語のincludeに相当。01レベルが構造体のルート、配下の番号（03, 05等）が階層を示す。PIC X(n)は文字列n桁、PIC 9(n)は数値n桁を表す。

#### Step 2: 画面レイアウトを理解する

BMSマップ定義から画面の物理的なレイアウトを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | SSMAPP4マップ定義（行424-506）を確認。ENP4で始まるフィールド定義、POS=(行,列)の配置、ATTRB属性を理解する |

**主要フィールド配置**:
- **行1**: トランザクションID「SSP4」、画面タイトル
- **行4-6**: メニューオプション（1:照会、2:登録、3:削除）
- **行7-12**: 基本情報（ポリシー番号、顧客番号、日付、住所等）
- **行13-18**: リスク情報（火災、犯罪、洪水、天候の各リスク・保険料）
- **行19-20**: ステータス、却下理由
- **行24**: メッセージ表示欄

**読解のコツ**: ATTRB=(ASKIP,BRT)は「スキップ、高輝度」で保護フィールド。ATTRB=(UNPROT,NUM)は「非保護、数字」で入力可能フィールドを示す。

#### Step 3: メインプログラムを理解する

画面の処理ロジックを実装するプレゼンテーションプログラムを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp4.cbl | `base/src/lgtestp4.cbl` | MAINLINE SECTION（行30）から処理を開始。EIBCALENによる初回/継続判定、画面初期化処理を確認 |

**主要処理フロー**:
1. **行32-33**: EIBCALEN > 0で継続（A-GAIN）へ、それ以外は初期化
2. **行35-48**: 画面・COMMエリア初期化、リスクフィールドをLOW-VALUESで初期化
3. **行52-55**: 初回画面表示（EXEC CICS SEND MAP）
4. **行59-68**: AIDキー処理設定とMAP受信
5. **行71-249**: EVALUATE ENP4OPTOでオプション分岐
   - WHEN '1'（行73-154）: 照会処理（4種の検索パターン）
   - WHEN '2'（行156-195）: 登録処理
   - WHEN '3'（行197-234）: 削除処理
   - WHEN OTHER（行236-247）: エラー処理

**4種類の照会パターン**（行73-120）:
- 01ICOM: 顧客番号＋ポリシー番号指定
- 02ICOM: ポリシー番号のみ指定
- 03ICOM: 顧客番号のみ指定
- 05ICOM: 郵便番号のみ指定

#### Step 4: エラー処理を理解する

例外処理とエラーメッセージの出力ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgtestp4.cbl | `base/src/lgtestp4.cbl` | NO-ADD（行286-294）、NO-UPD（行296-298）、NO-DELETE（行300-302）、NO-DATA（行304-306）、ERROR-OUT（行308-318）の各エラー処理を確認 |

**エラー処理パターン**:
- **行183, 206**: 失敗時のSyncpoint Rollbackでトランザクション整合性を確保
- **行287-294**: NO-ADDでリターンコード70は「Customer does not exist」
- **行308-318**: ERROR-OUTで画面表示後、全エリアを初期化してRETURN

### プログラム呼び出し階層図

```
LGTESTP4（商業用不動産保険メニュー）
    │
    ├─ EXEC CICS SEND MAP('SSMAPP4')  ... 画面表示
    │
    ├─ EXEC CICS RECEIVE MAP('SSMAPP4') ... 画面入力受信
    │
    ├─ EXEC CICS LINK PROGRAM('LGIPOL01') ... 照会処理
    │      └─ 01ICOM/02ICOM/03ICOM/05ICOM
    │
    ├─ EXEC CICS LINK PROGRAM('LGAPOL01') ... 登録処理
    │      └─ 01ACOM
    │
    ├─ EXEC CICS LINK PROGRAM('LGDPOL01') ... 削除処理
    │      └─ 01DCOM
    │
    └─ EXEC CICS RETURN TRANSID('SSP4') ... トランザクション継続
```

### データフロー図

```
[入力]                    [処理]                         [出力]

3270端末                  LGTESTP4
  │                         │
  │ ENP4OPT=1              │
  │ ENP4CNO/PNO/HPC ─────▶ │ ─▶ LGIPOL01 ─▶ DB照会
  │                         │      │
  │                         │ ◀────┘
  │ ◀───────────────────── │ CA-COMMERCIAL情報 ────────▶ 画面表示
  │                         │
  │ ENP4OPT=2              │
  │ 全入力フィールド ─────▶ │ ─▶ LGAPOL01 ─▶ DB登録
  │                         │      │
  │ ◀───────────────────── │ ◀────┘ 採番ポリシー番号
  │                         │
  │ ENP4OPT=3              │
  │ CNO/PNO ───────────────▶ │ ─▶ LGDPOL01 ─▶ DB削除
  │                         │      │
  │ ◀───────────────────── │ ◀────┘ 削除完了メッセージ

COMMAREA構造:
┌─────────────────────────────────────────────────────────────┐
│ CA-REQUEST-ID │ CA-RETURN-CODE │ CA-CUSTOMER-NUM │ ...     │
├─────────────────────────────────────────────────────────────┤
│ CA-COMMERCIAL (商業用不動産保険固有)                        │
│ ├─ CA-B-Address(255) ├─ CA-B-Postcode(8)                   │
│ ├─ CA-B-Latitude(11) ├─ CA-B-Longitude(11)                 │
│ ├─ CA-B-Customer(255) ├─ CA-B-PropType(255)                │
│ ├─ CA-B-FirePeril(4) ├─ CA-B-FirePremium(8)                │
│ ├─ CA-B-CrimePeril(4) ├─ CA-B-CrimePremium(8)              │
│ ├─ CA-B-FloodPeril(4) ├─ CA-B-FloodPremium(8)              │
│ ├─ CA-B-WeatherPeril(4) ├─ CA-B-WeatherPremium(8)          │
│ └─ CA-B-Status(4) └─ CA-B-RejectReason(255)                │
└─────────────────────────────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestp4.cbl | `base/src/lgtestp4.cbl` | ソース | 商業用不動産保険メニュープログラム（319行） |
| ssmap.bms | `base/src/ssmap.bms` | BMS | BMSマップ定義（SSMAPP4: 行424-506） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピー句 | COMMAREA構造体定義（CA-COMMERCIAL: 行77-94） |
| LGIPOL01 | - | ソース | ポリシー照会ビジネスロジック |
| LGAPOL01 | - | ソース | ポリシー登録ビジネスロジック |
| LGDPOL01 | - | ソース | ポリシー削除ビジネスロジック |
