# 画面設計書 6-保険請求メニュー画面

## 概要

本ドキュメントは、GenApp（General Insurance Application）における保険請求メニュー画面（SSMAPP5）の設計仕様を定義する。この画面は保険請求（Claim）の照会・登録を行うためのインターフェースである。

### 本画面の処理概要

**業務上の目的・背景**：
保険請求は保険契約者が保険金を請求する際に必要な情報を管理する重要な機能である。本画面は、保険請求の新規登録と既存請求の照会を行うために提供されている。請求番号、関連するポリシー番号・顧客番号、請求日、支払済金額、請求額、原因、所見などの情報を管理できる。保険金支払い業務の効率化と請求履歴の追跡を目的としている。

**画面へのアクセス方法**：
3270端末からCICSトランザクションID「SSP5」を入力することで本画面にアクセスする。CICSリージョンにサインオン後、コマンドラインに「SSP5」と入力しENTERキーを押下することで画面が表示される。

**主要な操作・処理内容**：
1. **請求照会（オプション1）**：請求番号を入力し、オプション「1」を選択してENTERキーを押下すると、該当請求の詳細情報が画面に表示される
2. **請求登録（オプション2）**：ポリシー番号、顧客番号、請求情報（請求日、支払済金額、請求額、原因、所見）を入力し、オプション「2」を選択してENTERキーを押下すると、新規請求としてデータベースに登録される

**画面遷移**：
- 本画面は独立したCICSトランザクションとして動作し、他画面との直接遷移はない
- CLEARキーまたはPF3キーを押下するとトランザクションが終了し、CICS画面に戻る
- 各操作完了後は同一画面（SSP5トランザクション）にRETURNし、継続操作が可能

**権限による表示制御**：
本画面には特別な権限制御は実装されていない。CICSリージョンへのアクセス権限を持つすべてのユーザーが利用可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 保険請求照会 | 主機能 | オプション1選択時に請求番号を指定して請求情報を照会・表示する |
| - | 保険請求登録 | 主機能 | オプション2選択時に新規請求を登録する |

**注意**: 画面機能マッピングに本画面の機能が登録されていないため、機能Noは未割当。

## 画面種別

メニュー・登録・照会（複合機能画面）

## URL/ルーティング

- トランザクションID: SSP5
- BMSマップ名: SSMAPP5
- マップセット名: SSMAP
- プレゼンテーションプログラム: 未確認（ソースコードが見つからない）

## 入出力項目

| 項目名 | フィールド名 | 属性 | 桁数（画面/COMM） | 入力/出力 | 必須 | 説明 |
|--------|--------------|------|-------------------|-----------|------|------|
| 請求番号（Claim Number） | ENP5LNO | 数字 | 10/10 | 入出力 | 照会時必須 | 右寄せゼロ埋め、CA-C-Num |
| ポリシー番号（Policy Number） | ENP5PNO | 数字 | 10/10 | 入出力 | 登録時必須 | 右寄せゼロ埋め、CA-POLICY-NUM |
| 顧客番号（Customer Number） | ENP5CNO | 数字 | 10/10 | 入出力 | 登録時必須 | 右寄せゼロ埋め、CA-CUSTOMER-NUM |
| 請求日（Claim date） | ENP5CDA | 日付 | 10/10 | 入出力 | - | yyyy-mm-dd形式、CA-C-Date |
| 支払済金額（Paid） | ENP5PAD | 数字 | 10/8 | 入出力 | - | 右寄せゼロ埋め、CA-C-Paid |
| 請求額（Value） | ENP5VAL | 数字 | 10/8 | 入出力 | - | 右寄せゼロ埋め、CA-C-Value |
| 原因（Cause） | ENP5CAU | 英数字 | 25/255 | 入出力 | - | CA-C-Cause |
| 所見（Observation） | ENP5OBS | 英数字 | 25/255 | 入出力 | - | CA-C-Observations |
| オプション選択 | ENP5OPT | 数字 | 1/- | 入力 | 必須 | 1:照会、2:登録 |
| メッセージ欄 | ERP5FLD | 英数字 | 40/- | 出力 | - | 処理結果メッセージ |

## 表示項目

| 項目名 | 表示位置 | 属性 | 説明 |
|--------|----------|------|------|
| トランザクションID | 行1,列1 | 高輝度・保護（ASKIP,BRT） | 'SSP5'を表示 |
| 画面タイトル | 行1,列12 | 高輝度・保護（BRT,ASKIP） | 'General Insurance Policy Claim Menu' |
| メニューオプション1 | 行4,列8 | 通常・保護（NORM,ASKIP） | '1. Claim Inquiry' |
| メニューオプション2 | 行5,列8 | 通常・保護（NORM,ASKIP） | '2. Claim Add' |
| 日付フォーマットガイド | 行7,列63 | 通常・保護（NORM,ASKIP） | '(yyyy-mm-dd)' |

**注意**: オプション3（Policy Delete）とオプション4（Policy Update）はBMSマップ上でコメントアウトされており（ssmap.bms 行615-618）、画面には表示されない。

## イベント仕様

### 1-ENTERキー押下（オプション1: 請求照会）

```
【推定処理フロー】
1. 画面からENP5LNO（請求番号）を取得
2. CA-REQUEST-IDに適切な値を設定（推定：'01ICLM'等）
3. 対応するビジネスロジックプログラムをCICS LINKで呼び出し
4. CA-RETURN-CODE > 0 の場合、'No data was returned.'を表示
5. 成功時、以下のマッピングを実行：
   - CA-C-Num → ENP5LNO（請求番号）
   - CA-POLICY-NUM → ENP5PNO（ポリシー番号）
   - CA-CUSTOMER-NUM → ENP5CNO（顧客番号）
   - CA-C-Date → ENP5CDA（請求日）
   - CA-C-Paid → ENP5PAD（支払済金額）
   - CA-C-Value → ENP5VAL（請求額）
   - CA-C-Cause → ENP5CAU（原因）
   - CA-C-Observations → ENP5OBS（所見）
6. EXEC CICS SEND MAP ('SSMAPP5') FROM(SSMAPP5O) MAPSET('SSMAP')
7. SSP5トランザクションにRETURN
```

### 2-ENTERキー押下（オプション2: 請求登録）

```
【推定処理フロー】
1. 画面から全入力フィールドを取得
2. CA-REQUEST-IDに適切な値を設定（推定：'01ACLM'等）
3. 入力データをCOMMAREA（CA-CLAIM構造体）にマッピング：
   - ENP5PNO → CA-POLICY-NUM
   - ENP5CNO → CA-CUSTOMER-NUM
   - ENP5CDA → CA-C-Date
   - ENP5PAD → CA-C-Paid
   - ENP5VAL → CA-C-Value
   - ENP5CAU → CA-C-Cause
   - ENP5OBS → CA-C-Observations
4. 対応するビジネスロジックプログラムをCICS LINKで呼び出し
5. CA-RETURN-CODE > 0 の場合：
   - EXEC CICS Syncpoint Rollback（推定）
   - エラーメッセージを表示
6. 成功時：
   - 採番されたCA-C-Num → ENP5LNO
   - 成功メッセージを出力
7. EXEC CICS SEND MAP ('SSMAPP5') FROM(SSMAPP5O) MAPSET('SSMAP')
8. SSP5トランザクションにRETURN
```

### 3-CLEARキー押下

```
【推定処理フロー】
1. Initialize SSMAPP5I（画面入力フィールドを初期化）
2. EXEC CICS SEND MAP ('SSMAPP5') MAPSET('SSMAP') MAPONLY
3. EXEC CICS RETURN TRANSID('SSP5') COMMAREA(COMM-AREA)
```

### 4-PF3キー押下

```
【推定処理フロー】
1. EXEC CICS SEND TEXT FROM(MSGEND) LENGTH(24) ERASE FREEKB
   - MSGEND = 'Transaction ended      '
2. EXEC CICS RETURN（CICSにRETURN、トランザクション終了）
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オプション1（照会） | CLAIM | SELECT | 請求番号をキーに請求情報を取得 |
| オプション2（登録） | CLAIM | INSERT | 新規請求レコードを登録 |

### テーブル別更新項目詳細

#### CLAIM - Db2/VSAM

| 操作 | 項目（COMMAREA名） | データ型 | 桁数 | 備考 |
|-----|-------------------|---------|------|------|
| SELECT/INSERT | CA-C-Num | 9(10) | 10 | 請求番号（キー項目） |
| SELECT | CA-POLICY-NUM | 9(10) | 10 | 関連ポリシー番号 |
| SELECT | CA-CUSTOMER-NUM | 9(10) | 10 | 関連顧客番号 |
| INSERT | CA-C-Date | X(10) | 10 | 請求日（yyyy-mm-dd形式） |
| INSERT | CA-C-Paid | 9(8) | 8 | 支払済金額 |
| INSERT | CA-C-Value | 9(8) | 8 | 請求額 |
| INSERT | CA-C-Cause | X(255) | 255 | 原因 |
| INSERT | CA-C-Observations | X(255) | 255 | 所見 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|----------|
| MSG001 | New Claim Inserted（推定） | 成功 | 請求登録成功時 |
| MSG002 | No data was returned. | エラー | 照会時にデータが存在しない場合 |
| MSG003 | Error Adding Claim（推定） | エラー | 請求登録失敗時（Rollback実行） |
| MSG004 | Please enter a valid option | エラー | 無効なオプション入力時 |
| MSG005 | Transaction ended | 情報 | PF3押下によるトランザクション終了時 |

## 例外処理

| 例外条件 | 処理内容 | 画面遷移 |
|----------|----------|----------|
| 請求データなし | 'No data was returned.'を表示、入力フィールドを初期化 | 同一画面にRETURN |
| 請求登録エラー | Syncpoint Rollback実行（推定）、エラーメッセージを表示、入力フィールドを初期化 | 同一画面にRETURN |
| 無効なオプション | 'Please enter a valid option'を表示、オプションフィールドにカーソル移動 | 同一画面にRETURN |
| MAPFAILエラー | トランザクション終了 | CICS画面に戻る |

## 備考

- 本画面はCICS 3270端末向けのBMSマップ（SSMAPP5）を使用
- **プレゼンテーションプログラム（LGTESTP5相当）のソースコードが確認できなかった**
  - 画面一覧CSVでは「未確認」と記載されている
  - イベント処理フローは他の画面プログラムのパターンから推定
- トランザクションIDはBMSマップ定義（ssmap.bms 行607）に基づき「SSP5」
- **削除機能（オプション3）と更新機能（オプション4）はBMSマップ上でコメントアウトされており（ssmap.bms 行615-618）、現在利用不可**
- CA-CLAIM構造体（lgcmarea.cpy 行96-103）に請求固有データが格納される
- 支払済金額（CA-C-Paid）と請求額（CA-C-Value）は画面表示10桁だが、COMMAREA上は8桁で定義されている
- 原因（CA-C-Cause）と所見（CA-C-Observations）は画面表示25桁だが、COMMAREA上は255桁で定義されている
- 画面機能マッピングに本画面の機能が登録されていないため、機能Noは未割当
- ビジネスロジックプログラム（請求処理用）が未特定：LGICLA01, LGACLA01等が存在する可能性があるが未確認
- CA-REQUEST-IDの値（'01ICLM', '01ACLM'等）は他の画面のパターンから推定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

**注意**: 本画面のプレゼンテーションプログラム（LGTESTP5相当）のソースコードは確認できなかったため、処理フローは他の画面プログラムのパターンから推定している。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造体の全体像を把握。CA-REQUEST-ID、CA-RETURN-CODE、CA-CUSTOMER-NUM、CA-POLICY-NUMの共通項目と、CA-CLAIM（行96-103）の保険請求固有フィールドを理解する |

**CA-CLAIM構造体の主要フィールド**:
- CA-C-Num: 請求番号（10桁）
- CA-C-Date: 請求日（10桁、yyyy-mm-dd形式）
- CA-C-Paid: 支払済金額（8桁）
- CA-C-Value: 請求額（8桁）
- CA-C-Cause: 原因（255桁）
- CA-C-Observations: 所見（255桁）

**読解のコツ**: COBOLのCOPY文は他言語のincludeに相当。01レベルが構造体のルート、配下の番号（03, 05等）が階層を示す。PIC X(n)は文字列n桁、PIC 9(n)は数値n桁を表す。

#### Step 2: 画面レイアウトを理解する

BMSマップ定義から画面の物理的なレイアウトを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | SSMAPP5マップ定義（行598-689）を確認。ENP5で始まるフィールド定義、POS=(行,列)の配置、ATTRB属性を理解する |

**主要フィールド配置**:
- **行1**: トランザクションID「SSP5」、画面タイトル「General Insurance Policy Claim Menu」
- **行4-5**: メニューオプション（1:照会、2:登録）
- **行7**: オプション入力フィールド
- **行8-14**: 請求情報入力フィールド（請求番号、ポリシー番号、顧客番号、請求日、支払済金額、請求額、原因、所見）
- **行24**: メッセージ表示欄

**読解のコツ**:
- ATTRB=(ASKIP,BRT)は「スキップ、高輝度」で保護フィールド
- ATTRB=(UNPROT,NUM)は「非保護、数字」で入力可能フィールドを示す
- 行615-618にコメントアウトされたオプション3（削除）、オプション4（更新）がある

#### Step 3: 類似プログラムを参考にして処理ロジックを推定する

LGTESTP5のソースコードが確認できないため、類似の構造を持つ他の画面プログラムを参考にする。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 自動車保険メニュープログラム。EVALUATE文によるオプション分岐、CICS LINK呼び出しパターン、エラー処理の構造を参考にする |

**推定される処理パターン**（lgtestp1.cblを参考）:
1. **初回判定**: EIBCALEN > 0で継続処理へ、それ以外は画面初期化
2. **画面受信**: EXEC CICS RECEIVE MAP('SSMAPP5')
3. **オプション分岐**: EVALUATE ENP5OPTO
   - WHEN '1': 照会処理（推定リクエストID: '01ICLM'）
   - WHEN '2': 登録処理（推定リクエストID: '01ACLM'）
4. **ビジネスロジック呼び出し**: EXEC CICS LINK PROGRAM('LGxCLA01') COMMAREA(COMM-AREA) LENGTH(32500)
5. **エラー処理**: CA-RETURN-CODE > 0の場合、Syncpoint Rollback後にエラーメッセージ表示
6. **トランザクション継続**: EXEC CICS RETURN TRANSID('SSP5') COMMAREA(COMM-AREA)

### プログラム呼び出し階層図

```
LGTESTP5（保険請求メニュー）※ソース未確認
    │
    ├─ EXEC CICS SEND MAP('SSMAPP5')  ... 画面表示
    │
    ├─ EXEC CICS RECEIVE MAP('SSMAPP5') ... 画面入力受信
    │
    ├─ EXEC CICS LINK PROGRAM('LGxCLA01') ... 照会処理（推定）
    │      └─ 01ICLM（推定）
    │
    ├─ EXEC CICS LINK PROGRAM('LGxCLA01') ... 登録処理（推定）
    │      └─ 01ACLM（推定）
    │
    └─ EXEC CICS RETURN TRANSID('SSP5') ... トランザクション継続
```

### データフロー図

```
[入力]                    [処理]                         [出力]

3270端末                  LGTESTP5（推定）
  │                         │
  │ ENP5OPT=1              │
  │ ENP5LNO（請求番号）───▶ │ ─▶ 照会プログラム ─▶ DB照会
  │                         │      │
  │                         │ ◀────┘
  │ ◀───────────────────── │ CA-CLAIM情報 ──────────────▶ 画面表示
  │                         │
  │ ENP5OPT=2              │
  │ 請求情報 ──────────────▶ │ ─▶ 登録プログラム ─▶ DB登録
  │                         │      │
  │ ◀───────────────────── │ ◀────┘ 採番請求番号

COMMAREA構造:
┌─────────────────────────────────────────────────────────────┐
│ CA-REQUEST-ID │ CA-RETURN-CODE │ CA-CUSTOMER-NUM │ ...     │
├─────────────────────────────────────────────────────────────┤
│ CA-CLAIM (保険請求固有)                                     │
│ ├─ CA-C-Num(10)      ... 請求番号                          │
│ ├─ CA-C-Date(10)     ... 請求日（yyyy-mm-dd）              │
│ ├─ CA-C-Paid(8)      ... 支払済金額                        │
│ ├─ CA-C-Value(8)     ... 請求額                            │
│ ├─ CA-C-Cause(255)   ... 原因                              │
│ └─ CA-C-Observations(255) ... 所見                         │
└─────────────────────────────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LGTESTP5 | - | ソース | 保険請求メニュープログラム（**ソース未確認**） |
| ssmap.bms | `base/src/ssmap.bms` | BMS | BMSマップ定義（SSMAPP5: 行598-689） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピー句 | COMMAREA構造体定義（CA-CLAIM: 行96-103） |
| lgtestp1.cbl | `base/src/lgtestp1.cbl` | ソース | 参考：自動車保険メニュー（類似構造） |
| lgtestp2.cbl | `base/src/lgtestp2.cbl` | ソース | 参考：養老保険メニュー（類似構造） |
| LGxCLA01 | - | ソース | 請求照会/登録ビジネスロジック（**未特定**） |
