---
generated_at: 2026-01-06 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-顧客メニュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **データベーステーブル名CUSTOMER**：実際のDb2テーブル定義未確認
  2. **メッセージIDの採番体系**：ソースコード上にID定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/ssmap.bms` - BMSマップ定義（SSMAPC1セクション、行13-106）
- E-02: `base/src/lgtestc1.cbl` - プレゼンテーションプログラム（全348行）
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義（行10-26）
- E-04: `base/src/lgicus01.cbl` - 顧客照会ビジネスロジック
- E-05: `base/src/lgacus01.cbl` - 顧客登録ビジネスロジック
- E-06: `base/src/lgucus01.cbl` - 顧客更新ビジネスロジック
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行2）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報（行18-20, 47-75）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行2-5）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トランザクションIDはSSC1 | E-01(行14), E-02(行232,256) | ○ |
| C-02 | BMSマップ名はSSMAPC1 | E-01(行13), E-02(行64,79) | ○ |
| C-03 | プログラム名はLGTESTC1 | E-02(行11), E-07 | ○ |
| C-04 | 顧客番号フィールドは10桁 | E-01(行29-30), E-03(行12) | ○ |
| C-05 | 名フィールドは10桁 | E-01(行36-37), E-03(行16) | ○ |
| C-06 | 姓フィールドは20桁 | E-01(行42-43), E-03(行17) | ○ |
| C-07 | 生年月日フィールドは10桁 | E-01(行49-50), E-03(行18) | ○ |
| C-08 | 郵便番号は大文字変換される | E-02(行126-127,188-189) | ○ |
| C-09 | オプション1で照会実行（01ICUS） | E-02(行86-111) | ○ |
| C-10 | オプション2で登録実行（01ACUS） | E-02(行113-146) | ○ |
| C-11 | オプション4で更新実行（01UCUS） | E-02(行148-207) | ○ |
| C-12 | 照会時LGICUS01を呼び出し | E-02(行89-92,151-154), E-04 | ○ |
| C-13 | 登録時LGACUS01を呼び出し | E-02(行128-131), E-05 | ○ |
| C-14 | 更新時LGUCUS01を呼び出し | E-02(行190-193), E-06 | ○ |
| C-15 | CLEARキーで画面初期化 | E-02(行72-74,246-257) | ○ |
| C-16 | PF3キーでトランザクション終了 | E-02(行73-74,236-244) | ○ |
| C-17 | 登録失敗時Rollback実行 | E-02(行132-134) | ○ |
| C-18 | COMMAREA長は32500バイト | E-02(行90-91,129-130) | ○ |
| C-19 | メッセージ'New Customer Inserted'表示 | E-02(行140-141) | ○ |
| C-20 | メッセージ'Customer details updated'表示 | E-02(行201-202) | ○ |
| C-21 | メッセージ'No data was returned.'表示 | E-02(行268) | ○ |
| C-22 | メッセージ'Error Adding Customer'表示 | E-02(行264) | ○ |
| C-23 | メッセージ'Error Updating Customer'表示 | E-02(行260) | ○ |
| C-24 | GENACNTLキューへの書き込み | E-02(行283-346) | ○ |
| C-25 | 画面タイトル'General Insurance Customer Menu' | E-01(行15-16) | ○ |
| C-26 | メールアドレス27桁 | E-01(行93-94) | ○ |
| C-27 | LGICUS01からLGICDB01を呼び出し | E-04(行122-125) | ○ |
| C-28 | LGACUS01からLGACDB01を呼び出し | E-05(行134-137) | ○ |
| C-29 | データベーステーブル名はCUSTOMER | **根拠なし（推定）** | △ |
| C-30 | メッセージIDの採番体系（MSG001等） | **根拠なし（設計書用に付与）** | △ |

## 4) 不足情報（Unknown / Missing）
- データベース（Db2/VSAM）のテーブル定義・DDLが参照できなかったため、テーブル名「CUSTOMER」は推定
  - 候補：プロジェクト内のDDLファイル / Db2定義書 / VSAM KSDS定義
- メッセージIDは設計書作成時に付与した識別子であり、ソースコード上には存在しない
  - 候補：メッセージマスター定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目定義、イベント処理フロー
- 1: 中リスク - データベーステーブル名の確認が必要
- 0: 低リスク - ビジネスロジックプログラムの呼び出し関係

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル「CUSTOMER」の名称がDb2/VSAM定義と一致するか確認
- [ ] 郵便番号の大文字変換が業務要件と整合しているか確認
- [ ] GENACNTLキューの制御情報が運用上正しく使用されているか確認
- [ ] 顧客削除機能が本画面に不要であることを業務要件と照合
