---
generated_at: 2026-01-06 10:35:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：2-自動車保険ポリシーメニュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **データベーステーブル名POLICY/MOTOR**：実際のDb2テーブル定義未確認
  2. **メッセージIDの採番体系**：ソースコード上にID定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/ssmap.bms` - BMSマップ定義（SSMAPP1セクション、行112-231）
- E-02: `base/src/lgtestp1.cbl` - プレゼンテーションプログラム（全319行）
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義（行34-75、CA-MOTOR）
- E-04: `base/src/lgipol01.cbl` - ポリシー照会ビジネスロジック
- E-05: `base/src/lgapol01.cbl` - ポリシー登録ビジネスロジック
- E-06: `base/src/lgdpol01.cbl` - ポリシー削除ビジネスロジック
- E-07: `base/src/lgupol01.cbl` - ポリシー更新ビジネスロジック
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行3）
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報（行23, 77-110）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行6-10）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トランザクションIDはSSP1 | E-01(行113), E-02(行259) | ○ |
| C-02 | BMSマップ名はSSMAPP1 | E-01(行112), E-02(行47,61) | ○ |
| C-03 | プログラム名はLGTESTP1 | E-02(行11), E-08 | ○ |
| C-04 | ポリシー番号フィールドは10桁 | E-01(行128-129), E-03(行35) | ○ |
| C-05 | 顧客番号フィールドは10桁 | E-01(行135-136), E-03(行12) | ○ |
| C-06 | 発行日フィールドは10桁 | E-01(行142-143), E-03(行38) | ○ |
| C-07 | 車メーカーフィールドは画面20桁、COMM15桁 | E-01(行160-161), E-03(行66) | ○ |
| C-08 | 車種フィールドは画面20桁、COMM15桁 | E-01(行167-168), E-03(行67) | ○ |
| C-09 | オプション1で照会実行（01IMOT） | E-02(行68-95) | ○ |
| C-10 | オプション2で登録実行（01AMOT） | E-02(行97-133) | ○ |
| C-11 | オプション3で削除実行（01DMOT） | E-02(行135-167), E-06 | ○ |
| C-12 | オプション4で更新実行（01UMOT） | E-02(行169-234), E-07 | ○ |
| C-13 | 照会時LGIPOL01を呼び出し | E-02(行72-75,173-176), E-04 | ○ |
| C-14 | 登録時LGAPOL01を呼び出し | E-02(行115-118), E-05 | ○ |
| C-15 | 削除時LGDPOL01を呼び出し | E-02(行139-142), E-06 | ○ |
| C-16 | 更新時LGUPOL01を呼び出し | E-02(行216-219), E-07 | ○ |
| C-17 | CLEARキーで画面初期化 | E-02(行54-56,273-284) | ○ |
| C-18 | PF3キーでトランザクション終了 | E-02(行55-56,263-271) | ○ |
| C-19 | 登録失敗時Rollback実行 | E-02(行119-121) | ○ |
| C-20 | 削除失敗時Rollback実行 | E-02(行143-145) | ○ |
| C-21 | COMMAREA長は32500バイト | E-02(行73-74,116-117) | ○ |
| C-22 | メッセージ'New Motor Policy Inserted'表示 | E-02(行127-128) | ○ |
| C-23 | メッセージ'Motor Policy Updated'表示 | E-02(行227-228) | ○ |
| C-24 | メッセージ'Motor Policy Deleted'表示 | E-02(行157-158) | ○ |
| C-25 | 顧客不存在時RC=70 | E-02(行287-294) | ○ |
| C-26 | 画面タイトル'General Insurance Motor Policy Menu' | E-01(行114-115) | ○ |
| C-27 | CA-MOTOR構造体使用 | E-03(行65-75) | ○ |
| C-28 | 排気量(CC)は画面8桁、COMM4桁 | E-01(行195-196), E-03(行71) | ○ |
| C-29 | 事故回数は6桁 | E-01(行211-212), E-03(行74) | ○ |
| C-30 | 保険料は6桁 | E-01(行218-219), E-03(行73) | ○ |
| C-31 | データベーステーブル名はPOLICY/MOTOR | **根拠なし（推定）** | △ |
| C-32 | メッセージIDの採番体系（MSG001等） | **根拠なし（設計書用に付与）** | △ |

## 4) 不足情報（Unknown / Missing）
- データベース（Db2/VSAM）のテーブル定義・DDLが参照できなかったため、テーブル名「POLICY/MOTOR」は推定
  - 候補：プロジェクト内のDDLファイル / Db2定義書 / VSAM KSDS定義
- メッセージIDは設計書作成時に付与した識別子であり、ソースコード上には存在しない
  - 候補：メッセージマスター定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目定義、イベント処理フロー
- 1: 中リスク - データベーステーブル名の確認が必要
- 0: 低リスク - ビジネスロジックプログラムの呼び出し関係
- 0: 低リスク - CA-MOTOR構造体のマッピング

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル「POLICY/MOTOR」の名称がDb2/VSAM定義と一致するか確認
- [ ] 顧客存在チェック（RC=70）の動作が業務要件と整合しているか確認
- [ ] 削除処理時のカスケード削除有無を確認
- [ ] 車両価値・保険料・事故回数の数値範囲が妥当か確認
- [ ] 車メーカー・車種の画面桁数（20桁）とCOMM桁数（15桁）の差異が問題ないか確認
