---
generated_at: 2026-01-06 10:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：3-養老保険ポリシーメニュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **データベーステーブル名POLICY/ENDOWMENT**：実際のDb2テーブル定義未確認
  2. **メッセージIDの採番体系**：ソースコード上にID定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/ssmap.bms` - BMSマップ定義（SSMAPP2セクション、行237-340）
- E-02: `base/src/lgtestp2.cbl` - プレゼンテーションプログラム（全301行）
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義（行46-54、CA-ENDOWMENT）
- E-04: `base/src/lgipol01.cbl` - ポリシー照会ビジネスロジック
- E-05: `base/src/lgapol01.cbl` - ポリシー登録ビジネスロジック
- E-06: `base/src/lgdpol01.cbl` - ポリシー削除ビジネスロジック
- E-07: `base/src/lgupol01.cbl` - ポリシー更新ビジネスロジック
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行4）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行11-15）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トランザクションIDはSSP2 | E-01(行238), E-02(行241) | ○ |
| C-02 | BMSマップ名はSSMAPP2 | E-01(行237), E-02(行42,56) | ○ |
| C-03 | プログラム名はLGTESTP2 | E-02(行11), E-08 | ○ |
| C-04 | ポリシー番号フィールドは10桁 | E-01(行253-254), E-03(行35) | ○ |
| C-05 | 顧客番号フィールドは10桁 | E-01(行260-261), E-03(行12) | ○ |
| C-06 | ファンド名フィールドは10桁 | E-01(行285-286), E-03(行50) | ○ |
| C-07 | 期間フィールドは2桁 | E-01(行292-293), E-03(行51) | ○ |
| C-08 | 保証額フィールドは6桁 | E-01(行299-300), E-03(行52) | ○ |
| C-09 | オプション1で照会実行（01IEND） | E-02(行63-88) | ○ |
| C-10 | オプション2で登録実行（01AEND） | E-02(行90-123) | ○ |
| C-11 | オプション3で削除実行（01DEND） | E-02(行125-153), E-06 | ○ |
| C-12 | オプション4で更新実行（01UEND） | E-02(行155-216), E-07 | ○ |
| C-13 | 照会時LGIPOL01を呼び出し | E-02(行67-70,159-162), E-04 | ○ |
| C-14 | 登録時LGAPOL01を呼び出し | E-02(行105-108), E-05 | ○ |
| C-15 | 削除時LGDPOL01を呼び出し | E-02(行129-132), E-06 | ○ |
| C-16 | 更新時LGUPOL01を呼び出し | E-02(行198-201), E-07 | ○ |
| C-17 | CLEARキーで画面初期化 | E-02(行49-51,255-266) | ○ |
| C-18 | PF3キーでトランザクション終了 | E-02(行50-51,245-253) | ○ |
| C-19 | 登録失敗時Rollback実行 | E-02(行109-111) | ○ |
| C-20 | 削除失敗時Rollback実行 | E-02(行133-135) | ○ |
| C-21 | COMMAREA長は32500バイト | E-02(行68-69,106-107) | ○ |
| C-22 | メッセージ'New Life Policy Inserted'表示 | E-02(行117-118) | ○ |
| C-23 | メッセージ'Life Policy Updated'表示 | E-02(行209-210) | ○ |
| C-24 | メッセージ'Life Policy Deleted'表示 | E-02(行147-148) | ○ |
| C-25 | 顧客不存在時RC=70 | E-02(行268-276) | ○ |
| C-26 | 画面タイトル'General Insurance Endowment Policy Menu' | E-01(行239-240) | ○ |
| C-27 | CA-ENDOWMENT構造体使用 | E-03(行46-54) | ○ |
| C-28 | 被保険者名は画面25桁、COMM31桁 | E-01(行306-307), E-03(行53) | ○ |
| C-29 | データベーステーブル名はPOLICY/ENDOWMENT | **根拠なし（推定）** | △ |
| C-30 | メッセージIDの採番体系（MSG001等） | **根拠なし（設計書用に付与）** | △ |

## 4) 不足情報（Unknown / Missing）
- データベース（Db2/VSAM）のテーブル定義・DDLが参照できなかったため、テーブル名「POLICY/ENDOWMENT」は推定
  - 候補：プロジェクト内のDDLファイル / Db2定義書 / VSAM KSDS定義
- メッセージIDは設計書作成時に付与した識別子であり、ソースコード上には存在しない
  - 候補：メッセージマスター定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目定義、イベント処理フロー
- 1: 中リスク - データベーステーブル名の確認が必要
- 0: 低リスク - ビジネスロジックプログラムの呼び出し関係
- 0: 低リスク - CA-ENDOWMENT構造体のマッピング

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル「POLICY/ENDOWMENT」の名称がDb2/VSAM定義と一致するか確認
- [ ] 顧客存在チェック（RC=70）の動作が業務要件と整合しているか確認
- [ ] 利益配当有無・株式投資・マネージドファンドのフラグ値（Y/N等）の仕様を確認
- [ ] 被保険者名の桁数差異（画面25桁、COMM31桁）が問題ないか確認
