---
generated_at: 2026-01-06 11:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：4-住宅保険ポリシーメニュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **データベーステーブル名POLICY/HOUSE**：実際のDb2テーブル定義未確認
  2. **メッセージIDの採番体系**：ソースコード上にID定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/ssmap.bms` - BMSマップ定義（SSMAPP3セクション、行346-443）
- E-02: `base/src/lgtestp3.cbl` - プレゼンテーションプログラム（全300行）
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義（行56-63、CA-HOUSE）
- E-04: `base/src/lgipol01.cbl` - ポリシー照会ビジネスロジック
- E-05: `base/src/lgapol01.cbl` - ポリシー登録ビジネスロジック
- E-06: `base/src/lgdpol01.cbl` - ポリシー削除ビジネスロジック
- E-07: `base/src/lgupol01.cbl` - ポリシー更新ビジネスロジック
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行5）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行16-20）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トランザクションIDはSSP3 | E-01(行347), E-02(行240,263) | ○ |
| C-02 | BMSマップ名はSSMAPP3 | E-01(行346), E-02(行45-46,59-61) | ○ |
| C-03 | プログラム名はLGTESTP3 | E-02(行11), E-08 | ○ |
| C-04 | ポリシー番号フィールドは10桁 | E-01(行362-363), E-03(行35) | ○ |
| C-05 | 顧客番号フィールドは10桁 | E-01(行369-370), E-03(行12) | ○ |
| C-06 | 物件タイプフィールドは15桁 | E-01(行394-395), E-03(行57) | ○ |
| C-07 | 寝室数フィールドは3桁 | E-01(行401-402), E-03(行58) | ○ |
| C-08 | 住宅価値フィールドは8桁 | E-01(行408-409), E-03(行59) | ○ |
| C-09 | 住所名フィールドは20桁 | E-01(行415-416), E-03(行60) | ○ |
| C-10 | 住所番号フィールドは4桁 | E-01(行422-423), E-03(行61) | ○ |
| C-11 | 郵便番号フィールドは8桁 | E-01(行429-430), E-03(行62) | ○ |
| C-12 | オプション1で照会実行（01IHOU） | E-02(行66-90) | ○ |
| C-13 | オプション2で登録実行（01AHOU） | E-02(行92-123) | ○ |
| C-14 | オプション3で削除実行（01DHOU） | E-02(行125-153) | ○ |
| C-15 | オプション4で更新実行（01IHOU→01UHOU） | E-02(行155-214) | ○ |
| C-16 | 照会時LGIPOL01を呼び出し | E-02(行70-73,159-162), E-04 | ○ |
| C-17 | 登録時LGAPOL01を呼び出し | E-02(行106-109), E-05 | ○ |
| C-18 | 削除時LGDPOL01を呼び出し | E-02(行129-132), E-06 | ○ |
| C-19 | 更新時LGUPOL01を呼び出し | E-02(行196-199), E-07 | ○ |
| C-20 | CLEARキーで画面初期化（CLEARIT） | E-02(行52-54,254-265) | ○ |
| C-21 | PF3キーでトランザクション終了（ENDIT） | E-02(行52-54,244-252) | ○ |
| C-22 | 登録失敗時Rollback実行 | E-02(行110-112) | ○ |
| C-23 | 削除失敗時Rollback実行 | E-02(行133-135) | ○ |
| C-24 | COMMAREA長は32500バイト | E-02(行71-72,107-108,130-131,161,198) | ○ |
| C-25 | メッセージ'New House Policy Inserted'表示 | E-02(行117-118) | ○ |
| C-26 | メッセージ'House Policy Updated'表示 | E-02(行207-208) | ○ |
| C-27 | メッセージ'House Policy Deleted'表示 | E-02(行147-148) | ○ |
| C-28 | 顧客不存在時RC=70 | E-02(行268-271) | ○ |
| C-29 | 画面タイトル'General Insurance House Policy Menu' | E-01(行348-349) | ○ |
| C-30 | CA-HOUSE構造体使用 | E-03(行56-63) | ○ |
| C-31 | データベーステーブル名はPOLICY/HOUSE | **根拠なし（推定）** | △ |
| C-32 | メッセージIDの採番体系（MSG001等） | **根拠なし（設計書用に付与）** | △ |

## 4) 不足情報（Unknown / Missing）
- データベース（Db2/VSAM）のテーブル定義・DDLが参照できなかったため、テーブル名「POLICY/HOUSE」は推定
  - 候補：プロジェクト内のDDLファイル / Db2定義書 / VSAM KSDS定義
- メッセージIDは設計書作成時に付与した識別子であり、ソースコード上には存在しない
  - 候補：メッセージマスター定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目定義、イベント処理フロー
- 1: 中リスク - データベーステーブル名の確認が必要
- 0: 低リスク - ビジネスロジックプログラムの呼び出し関係
- 0: 低リスク - CA-HOUSE構造体のマッピング

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル「POLICY/HOUSE」の名称がDb2/VSAM定義と一致するか確認
- [ ] 顧客存在チェック（RC=70）の動作が業務要件と整合しているか確認
- [ ] 住宅価値の8桁が業務上の最大金額を表現できるか確認
- [ ] 物件タイプの15桁で表現できる種類が網羅されているか確認
- [ ] NO-ADD処理でERP1FLDOへMoveしている箇所（行270,273）が正しいか確認（ERP3FLDOではなくERP1FLDO）
