---
generated_at: 2026-01-06 11:05:00
metrics:
  claims_total: 38
  claims_with_evidence: 35
  claims_without_evidence: 3
confidence_derived: 0.92
---

# 根拠レポート：5-商業用不動産保険ポリシーメニュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：35 / 38、根拠なし：3
- 優先レビュー（高）
  1. **データベーステーブル名POLICY/COMMERCIAL**：実際のDb2テーブル定義未確認
  2. **メッセージIDの採番体系**：ソースコード上にID定義なし
  3. **更新機能の無効化理由**：業務要件との整合性を確認する必要あり

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/ssmap.bms` - BMSマップ定義（SSMAPP4セクション、行449-600）
- E-02: `base/src/lgtestp4.cbl` - プレゼンテーションプログラム（全319行）
- E-03: `base/src/lgcmarea.cpy` - COMMAREA構造定義（行77-94、CA-COMMERCIAL）
- E-04: `base/src/lgipol01.cbl` - ポリシー照会ビジネスロジック
- E-05: `base/src/lgapol01.cbl` - ポリシー登録ビジネスロジック
- E-06: `base/src/lgdpol01.cbl` - ポリシー削除ビジネスロジック
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行6）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行21-24）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トランザクションIDはSSP4 | E-01(行450), E-02(行259,282) | ○ |
| C-02 | BMSマップ名はSSMAPP4 | E-01(行449), E-02(行52-53,66-68) | ○ |
| C-03 | プログラム名はLGTESTP4 | E-02(行11), E-07 | ○ |
| C-04 | ポリシー番号フィールドは10桁 | E-01(行465-466), E-03(行35) | ○ |
| C-05 | 顧客番号フィールドは10桁 | E-01(行472-473), E-03(行12) | ○ |
| C-06 | 住所フィールドは画面25桁、COMM255桁 | E-01(行497-498), E-03(行78) | ○ |
| C-07 | 郵便番号フィールドは8桁 | E-01(行504-505), E-03(行79) | ○ |
| C-08 | 緯度フィールドは11桁 | E-01(行511-512), E-03(行80) | ○ |
| C-09 | 経度フィールドは11桁 | E-01(行515-516), E-03(行81) | ○ |
| C-10 | 顧客名フィールドは画面25桁、COMM255桁 | E-01(行522-523), E-03(行82) | ○ |
| C-11 | 物件タイプフィールドは画面25桁、COMM255桁 | E-01(行529-530), E-03(行83) | ○ |
| C-12 | 火災リスク4桁、火災保険料8桁 | E-01(行536-541), E-03(行84-85) | ○ |
| C-13 | 犯罪リスク4桁、犯罪保険料8桁 | E-01(行547-552), E-03(行86-87) | ○ |
| C-14 | 洪水リスク4桁、洪水保険料8桁 | E-01(行558-563), E-03(行88-89) | ○ |
| C-15 | 天候リスク4桁、天候保険料8桁 | E-01(行569-574), E-03(行90-91) | ○ |
| C-16 | ステータス4桁 | E-01(行580-581), E-03(行92) | ○ |
| C-17 | 却下理由は画面25桁、COMM255桁 | E-01(行587-588), E-03(行93) | ○ |
| C-18 | オプション1で照会実行（01ICOM/02ICOM/03ICOM/05ICOM） | E-02(行73-154) | ○ |
| C-19 | オプション2で登録実行（01ACOM） | E-02(行156-195) | ○ |
| C-20 | オプション3で削除実行（01DCOM） | E-02(行197-234) | ○ |
| C-21 | 照会時LGIPOL01を呼び出し | E-02(行122-125), E-04 | ○ |
| C-22 | 登録時LGAPOL01を呼び出し | E-02(行178-181), E-05 | ○ |
| C-23 | 削除時LGDPOL01を呼び出し | E-02(行201-204), E-06 | ○ |
| C-24 | CLEARキーで画面初期化（CLEARIT） | E-02(行59-61,273-284) | ○ |
| C-25 | PF3キーでトランザクション終了（ENDIT） | E-02(行59-61,263-271) | ○ |
| C-26 | 登録失敗時Rollback実行 | E-02(行182-184) | ○ |
| C-27 | 削除失敗時Rollback実行 | E-02(行205-207) | ○ |
| C-28 | COMMAREA長は32500バイト | E-02(行123-124,179-180,202-203) | ○ |
| C-29 | メッセージ'New Commercial Policy Inserted'表示 | E-02(行189-190) | ○ |
| C-30 | メッセージ'Commercial Policy Deleted'表示 | E-02(行228-229) | ○ |
| C-31 | 顧客不存在時RC=70 | E-02(行287-290) | ○ |
| C-32 | 画面タイトル'General Insurance Commercial Policy Menu' | E-01(行451-452) | ○ |
| C-33 | CA-COMMERCIAL構造体使用 | E-03(行77-94) | ○ |
| C-34 | 更新機能（オプション4）はコメントアウト | E-01(行460-461) | ○ |
| C-35 | 4種類の検索パターン対応（01ICOM,02ICOM,03ICOM,05ICOM） | E-02(行73-120) | ○ |
| C-36 | データベーステーブル名はPOLICY/COMMERCIAL | **根拠なし（推定）** | △ |
| C-37 | メッセージIDの採番体系（MSG001等） | **根拠なし（設計書用に付与）** | △ |
| C-38 | 更新機能無効化の業務的理由 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベース（Db2/VSAM）のテーブル定義・DDLが参照できなかったため、テーブル名「POLICY/COMMERCIAL」は推定
  - 候補：プロジェクト内のDDLファイル / Db2定義書 / VSAM KSDS定義
- メッセージIDは設計書作成時に付与した識別子であり、ソースコード上には存在しない
  - 候補：メッセージマスター定義書 / 運用マニュアル
- 更新機能（オプション4）がコメントアウトされている理由が不明
  - LGTESTP4プログラム内にNO-UPDセクション（行296-298）が存在するが呼び出し元がない
  - 候補：業務要件定義書 / 変更履歴 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目定義、イベント処理フロー
- 1: 中リスク - データベーステーブル名の確認が必要
- 1: 中リスク - 更新機能の無効化が業務要件と整合しているか確認が必要
- 0: 低リスク - CA-COMMERCIAL構造体のマッピング
- 0: 低リスク - 4種類の検索パターンの実装

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル「POLICY/COMMERCIAL」の名称がDb2/VSAM定義と一致するか確認
- [ ] 更新機能（オプション4）が無効化されている理由を業務要件と照合
- [ ] 4種類のリスク項目（火災、犯罪、洪水、天候）の数値範囲・計算ロジックを確認
- [ ] 画面表示桁数（25桁）とCOMMAREA桁数（255桁）の差異が問題ないか確認
- [ ] 郵便番号による検索（パターン4: 05ICOM）の業務上の必要性を確認
- [ ] リスク・保険料フィールドのLOW-VALUES初期化（行40-48）が表示上問題ないか確認
