---
generated_at: 2026-01-06 11:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 18
  claims_without_evidence: 7
confidence_derived: 0.72
---

# 根拠レポート：6-保険請求メニュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.72**
  - 根拠あり：18 / 25、根拠なし：7
- 優先レビュー（高）
  1. **プレゼンテーションプログラム**：対応するCOBOLプログラム（LGTESTP5相当）が未確認
  2. **ビジネスロジックプログラム**：請求処理用プログラムが未特定
  3. **CA-REQUEST-IDの値**：'01ICLM'等は推定値
  4. **イベント処理フロー**：実装詳細が確認できていない
  5. **削除・更新機能の無効化理由**：業務要件との整合性を確認する必要あり

## 2) 参照した情報（Evidence一覧）

- E-01: `base/src/ssmap.bms` - BMSマップ定義（SSMAPP5セクション、行606-687）
- E-02: `base/src/lgcmarea.cpy` - COMMAREA構造定義（行96-103、CA-CLAIM）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行7）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トランザクションIDはSSP5 | E-01(行607) | ○ |
| C-02 | BMSマップ名はSSMAPP5 | E-01(行606), E-03 | ○ |
| C-03 | 画面タイトル'General Insurance Policy Claim Menu' | E-01(行608-609) | ○ |
| C-04 | 請求番号フィールドは10桁 | E-01(行622-623), E-02(行97) | ○ |
| C-05 | ポリシー番号フィールドは10桁 | E-01(行629-630) | ○ |
| C-06 | 顧客番号フィールドは10桁 | E-01(行636-637) | ○ |
| C-07 | 請求日フィールドは10桁 | E-01(行643-644), E-02(行98) | ○ |
| C-08 | 支払済金額フィールドは画面10桁、COMM8桁 | E-01(行652-653), E-02(行99) | ○ |
| C-09 | 請求額フィールドは画面10桁、COMM8桁 | E-01(行659-660), E-02(行100) | ○ |
| C-10 | 原因フィールドは画面25桁、COMM255桁 | E-01(行666-667), E-02(行101) | ○ |
| C-11 | 所見フィールドは画面25桁、COMM255桁 | E-01(行673-674), E-02(行102) | ○ |
| C-12 | メニューオプション1は'1. Claim Inquiry' | E-01(行611-612) | ○ |
| C-13 | メニューオプション2は'2. Claim Add' | E-01(行613-614) | ○ |
| C-14 | 削除・更新機能はコメントアウト | E-01(行615-618) | ○ |
| C-15 | CA-CLAIM構造体使用 | E-02(行96-103) | ○ |
| C-16 | オプション選択フィールドは1桁 | E-01(行680-681) | ○ |
| C-17 | メッセージ欄は40桁 | E-01(行685-686) | ○ |
| C-18 | 日付フォーマットガイド'(yyyy-mm-dd)'表示 | E-01(行647-648) | ○ |
| C-19 | プレゼンテーションプログラム名（LGTESTP5相当） | **根拠なし（未確認）** | △ |
| C-20 | ビジネスロジックプログラム名（照会・登録用） | **根拠なし（未確認）** | △ |
| C-21 | CA-REQUEST-IDの値（'01ICLM', '01ACLM'等） | **根拠なし（推定）** | △ |
| C-22 | イベント処理フローの詳細 | **根拠なし（推定）** | △ |
| C-23 | データベーステーブル名はCLAIM | **根拠なし（推定）** | △ |
| C-24 | メッセージIDの採番体系（MSG001等） | **根拠なし（設計書用に付与）** | △ |
| C-25 | 削除・更新機能無効化の業務的理由 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- プレゼンテーションプログラム（LGTESTP5等）のソースコードが見つからなかった
  - 候補：`base/src/lgtestp5.cbl` / 他のソースディレクトリ
  - 画面一覧CSVでは「未確認」と記載されている
- ビジネスロジックプログラム（照会・登録・削除用）が未特定
  - 候補：LGICLA01, LGACLA01, LGDCLA01等（命名パターンからの推定）
- CA-REQUEST-IDの値は他の画面のパターン（xxYzzz形式）から推定したが、実装未確認
  - 顧客系：01ICUS, 01ACUS, 01UCUS
  - 自動車系：01IMOT, 01AMOT, 01DMOT, 01UMOT
  - 養老保険系：01IEND, 01AEND, 01DEND, 01UEND
  - 住宅系：01IHOU, 01AHOU, 01DHOU, 01UHOU
  - 商業用系：01ICOM, 01ACOM, 01DCOM
  - → 請求系：01ICLM, 01ACLM等と推定
- データベース（Db2/VSAM）のテーブル定義・DDLが参照できなかったため、テーブル名「CLAIM」は推定
- 削除・更新機能がコメントアウトされている理由が不明

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - プレゼンテーションプログラムの実装が未確認
- 2: 高リスク - ビジネスロジックプログラムの呼び出し関係が未確認
- 1: 中リスク - 削除・更新機能の無効化が業務要件と整合しているか確認が必要
- 0: 低リスク - 画面項目定義（BMSマップから確認済）
- 0: 低リスク - CA-CLAIM構造体のマッピング（lgcmarea.cpyから確認済）

## 6) レビュアーチェックリスト（最小）
- [ ] プレゼンテーションプログラム（LGTESTP5相当）のソースコードを確認
- [ ] 請求処理用ビジネスロジックプログラムの存在と呼び出し関係を確認
- [ ] トランザクションID「SSP5」がCICS定義と一致するか確認
- [ ] データベーステーブル「CLAIM」の名称がDb2/VSAM定義と一致するか確認
- [ ] 削除・更新機能が無効化されている理由を業務要件と照合
- [ ] 支払済金額・請求額の桁数差異（画面10桁、COMM8桁）が問題ないか確認
- [ ] 画面機能マッピングに本画面の機能を追加する必要があるか確認
- [ ] CA-REQUEST-IDの命名規則（01ICLM等）が正しいか確認

## 7) 補足：信頼度が低い理由

本画面の信頼度（0.72）が他の画面（0.92-0.94）より低い理由：

1. **プレゼンテーションプログラムのソースコードが見つからない**
   - 他の画面（LGTESTC1, LGTESTP1-P4）と異なり、LGTESTP5相当のファイルが確認できなかった
   - イベント処理フローは他の画面のパターンから推定している

2. **ビジネスロジックプログラムが未特定**
   - 請求処理用のプログラム（LGICLA01, LGACLA01等）の存在が確認できなかった

3. **画面機能マッピングに登録がない**
   - 機能Noが割り当てられておらず、業務要件との対応が不明確

レビュー時には、これらの不足情報を優先的に確認することを推奨する。
