---
generated_at: 2026-01-06 15:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードに基づいており、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgstsq.cbl` - エラーメッセージキュー出力プログラム
- E-02: `base/src/lgacus01.cbl` - 顧客追加プログラム (WRITE-ERROR-MESSAGE手続き)
- E-03: `base/src/lgacdb01.cbl` - 顧客DB追加プログラム (CA-RETURN-CODE設定)
- E-04: `base/src/lgipdb01.cbl` - 保険証券照会DBプログラム (カーソル処理、エラーコード)
- E-05: `base/src/lgapdb01.cbl` - 保険証券追加DBプログラム (リターンコード70)
- E-06: `base/src/lgacvs01.cbl` - 顧客VSAMプログラム (リターンコード80)
- E-07: `base/src/lgdpvs01.cbl` - 保険証券削除VSAMプログラム (リターンコード81)
- E-08: `base/src/lgupvs01.cbl` - 保険証券更新VSAMプログラム (リターンコード81, 82)
- E-09: `base/src/lgucvs01.cbl` - 顧客更新VSAMプログラム (リターンコード81, 82)
- E-10: `base/src/lgucdb01.cbl` - 顧客更新DBプログラム (リターンコード02)
- E-11: `base/src/lgwebst5.cbl` - 統計収集プログラム (GENASTATキュー)
- E-12: `base/src/lgtestp1.cbl` - 自動車保険メニュープログラム (端末メッセージ)
- E-13: `base/src/lgcmarea.cpy` - COMMAREA構造体定義 (CA-RETURN-CODE)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TDQエラーメッセージ通知（CSMTキュー） | E-01 (STDQ-NAME='CSMT', WRITEQ TD) | ○ |
| C-02 | TSQエラーメッセージ通知（GENAERRSキュー） | E-01 (STSQ-NAME='GENAERRS', WRITEQ TS) | ○ |
| C-03 | 画面エラーメッセージ | E-12 (ERP1FLDO変数、EXEC CICS SEND MAP) | ○ |
| C-04 | ABEND通知(LGCA) | E-02 (EXEC CICS ABEND ABCODE('LGCA') NODUMP) | ○ |
| C-05 | リターンコード00（正常完了） | E-02, E-03, E-04 (MOVE '00' TO CA-RETURN-CODE) | ○ |
| C-06 | リターンコード01（データなし） | E-04 (SQLCODE EQUAL 100 -> MOVE '01' TO CA-RETURN-CODE) | ○ |
| C-07 | リターンコード02（重複データ） | E-10 (MOVE '02' TO CA-RETURN-CODE) | ○ |
| C-08 | リターンコード70（顧客なし） | E-05 (MOVE '70' TO CA-RETURN-CODE) | ○ |
| C-09 | リターンコード80（VSAM書込エラー） | E-06 (MOVE '80' TO CA-RETURN-CODE) | ○ |
| C-10 | リターンコード81（VSAM読込エラー） | E-07, E-08, E-09 (MOVE '81' TO CA-RETURN-CODE) | ○ |
| C-11 | リターンコード82（VSAM更新エラー） | E-08, E-09 (MOVE '82' TO CA-RETURN-CODE) | ○ |
| C-12 | リターンコード88（カーソルクローズエラー） | E-04 (MOVE '88' TO CA-RETURN-CODE) | ○ |
| C-13 | リターンコード89（カーソルオープンエラー） | E-04 (MOVE '89' TO CA-RETURN-CODE) | ○ |
| C-14 | リターンコード90（DBエラー） | E-03, E-04, E-05 (MOVE '90' TO CA-RETURN-CODE) | ○ |
| C-15 | リターンコード98（COMMAREA不足） | E-03, E-04 (MOVE '98' TO CA-RETURN-CODE) | ○ |
| C-16 | リターンコード99（無効リクエストID） | E-04 (MOVE '99' TO CA-RETURN-CODE) | ○ |
| C-17 | 統計収集開始通知 | E-11 (StatQ='GENASTAT', WS-Startup変数) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての通知項目がソースコード内で直接確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がCOBOLソースコードで直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] TDQ/TSQキュー名が本番環境の設定と一致しているか確認
- [ ] リターンコードの意味がアプリケーション設計書と整合しているか確認
- [ ] ABENDコード'LGCA'が運用手順書に記載されているか確認
- [ ] 画面メッセージが多言語対応要件を満たしているか確認（現在は英語のみ）
