# 通知設計書 1-TDQエラーメッセージ通知

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるTDQ（Transactional Data Queue）エラーメッセージ通知の設計を定義する。CICSトランザクションデータキュー（TDQ）のCSMTキューへのエラーメッセージ出力機能を記述する。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの各業務プログラムでエラーが発生した際に、エラー情報をCICS標準のシステムログキュー（CSMT）に出力する機能を提供する。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、顧客情報やポリシー情報の操作時に発生するエラーを運用担当者が迅速に把握し、問題の原因特定と解決を行うためにシステムログへのエラー記録が必須である。TDQへの出力により、CICS環境での標準的なエラーモニタリングが可能となる。

**通知の送信タイミング**：VSAM ファイル操作エラー（読み取り、書き込み、更新、削除）、DB2データベースエラー（SQLCODEが0以外）、またはCOMMAREA不正（サイズ不足、未受信）などのエラー発生時に即座に送信される。具体的には、LGACVS01、LGAPVS01、LGUCVS01、LGUPVS01、LGDPVS01などのVSAMアクセスプログラム、およびLGIPDB01などのDB2アクセスプログラムからLGSTSQプログラムを介して出力される。

**通知の受信者**：CICSシステム運用担当者、およびCSMTキューを監視する運用監視システムが受信者となる。TDQ出力は運用コンソールやシステム監視ツールで参照可能である。

**通知内容の概要**：エラーメッセージには日時（日付・時刻）、プログラム名（9文字固定）、顧客番号（10桁）、ポリシー番号（10桁）、SQLコードまたはRESPコード（エラー種別に応じて）が含まれる。これにより、どの処理でいつエラーが発生したかを特定できる。

**期待されるアクション**：運用担当者はCSMTキューのエラーメッセージを確認し、エラー原因を調査する。データ不整合の場合はデータ修正、システム障害の場合はシステム復旧作業を行う。

## 通知種別

システムログ（CICS TDQ - Transactional Data Queue）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知のため即座に出力） |
| リトライ | なし（CICS TDQ WRITEQはRESPコードで結果を返すが、失敗時のリトライは行わない） |

### 送信先決定ロジック

送信先は固定でCSMT（CICS System Message Transient Data Queue）キューである。CSMTはCICS標準のシステムメッセージキューであり、全エラーメッセージがこのキューに集約される。

## 通知テンプレート

### TDQメッセージの場合

| 項目 | 内容 |
|-----|------|
| キュー名 | CSMT |
| キュータイプ | Transient Data Queue (TDQ) |
| メッセージ形式 | テキスト（固定長） |

### 本文テンプレート

```
{SYSID} {DATE} {TIME} {PROGRAM} CNUM={CUSTOMER-NUM} PNUM={POLICY-NUM} {OPERATION} RESP={RESP-CODE} RESP2={RESP2-CODE}
```

または（DB2エラーの場合）

```
{SYSID} {DATE} {TIME} {PROGRAM} CNUM={CUSTOMER-NUM} PNUM={POLICY-NUM} {SQL-REQUEST} SQLCODE={SQLCODE}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | TDQはテキストメッセージのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| SYSID | CICSシステムID | EXEC CICS ASSIGN SYSID | Yes |
| DATE | エラー発生日付 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| TIME | エラー発生時刻 | EXEC CICS FORMATTIME TIME | Yes |
| PROGRAM | エラー発生プログラム名 | ERROR-MSG構造体の固定値 | Yes |
| CUSTOMER-NUM | 顧客番号 | CA-CUSTOMER-NUM | Yes |
| POLICY-NUM | ポリシー番号 | CA-POLICY-NUM | 条件付き |
| OPERATION | 操作内容 | 各プログラムの固定文字列 | Yes |
| RESP-CODE | CICSレスポンスコード | WS-RESP | Yes |
| RESP2-CODE | CICS拡張レスポンスコード | WS-RESP2/EIBRESP2 | Yes |
| SQLCODE | SQLエラーコード | SQLCODE | 条件付き |
| SQL-REQUEST | SQL操作種別 | EM-SQLREQ | 条件付き |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| VSAMエラー | CICS FILE操作失敗 | WS-RESP Not = DFHRESP(NORMAL) | VSAMファイル操作が正常完了しなかった場合 |
| DB2エラー | SQL SELECT/INSERT/UPDATE失敗 | SQLCODE Not = 0 And SQLCODE Not = 100 | SQLエラー発生時（100は正常終了） |
| COMMAREAエラー | COMMAREA未受信 | EIBCALEN = 0 | プログラム呼び出し時にCOMMAREAが渡されなかった場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SQLCODE = 100 | データ未検出は通常のビジネスケースとして扱い、エラーログ出力は行わない（リターンコード01を返す） |
| 正常完了時 | RESP = DFHRESP(NORMAL)またはSQLCODE = 0の場合はログ出力しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[業務処理でエラー発生] --> B[エラー情報収集]
    B --> C[EXEC CICS ASKTIME/FORMATTIME]
    C --> D[ERROR-MSG構造体に値設定]
    D --> E[EXEC CICS LINK PROGRAM LGSTSQ]
    E --> F[LGSTSQプログラム実行]
    F --> G[EXEC CICS ASSIGN SYSID]
    G --> H[EXEC CICS WRITEQ TD QUEUE CSMT]
    H --> I{書き込み結果}
    I -->|成功| J[呼び出し元に戻る]
    I -->|失敗| K[エラーは無視して続行]
    J --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | TDQ出力処理ではDB2テーブル参照なし |

### テーブル別参照項目詳細

TDQ出力処理自体ではデータベーステーブルの参照は行わない。エラー情報はCOMMAREAおよびCICSシステム情報から取得する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | TDQ出力処理ではDB2テーブル更新なし |

#### 送信ログテーブル

TDQ出力はCICS TDQキュー（CSMT）への書き込みのみで、別途送信ログテーブルへの記録は行わない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| TDQ書き込み失敗 | WRITEQ TDのRESPがNORMAL以外 | エラーは無視して処理続行 |
| キュー未定義 | CSMTキューが定義されていない | CICSシステム設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（CICSシステムの能力に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に出力可能。

## セキュリティ考慮事項

- TDQ出力には顧客番号が含まれるため、CSMTキューへのアクセスは運用担当者に限定する
- ポリシー番号も出力されるため、CICSリソースセキュリティでCSMTキューへのアクセス制御を実施する
- エラーメッセージにパスワードや個人情報の詳細は含まれない設計となっている

## 備考

- LGSTSQプログラムは全業務プログラム共通のエラーログ出力モジュールとして使用される
- TDQ出力と同時にTSQ（GENAERRS）への出力も行われる（別通知として定義）
- 呼び出し方法はEXEC CICS LINK PROGRAM('LGSTSQ') COMMAREA(ERROR-MSG)

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メッセージ構造を理解する

まず、TDQに出力されるメッセージの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | WORKING-STORAGE SECTION（行15-40）でWRITE-MSG構造体を確認。SYSID(4)+空白(1)+メッセージ本文(90)の95バイト構造 |

**メッセージ構造**（lgstsq.cbl 行25-28）:
```cobol
01  WRITE-MSG.
  03 WRITE-MSG-SYSID          PIC X(4).   ... CICSシステムID
  03 FILLER-X                 PIC X.       ... 区切り空白
  03 WRITE-MSG-MSG            PIC X(90).   ... エラーメッセージ本文
```

#### Step 2: TDQ書き込み処理を理解する

LGSTSQプログラムのTDQ書き込み処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行94-99のWRITEQ TD処理。キュー名CSMTへの書き込み |

**TDQ書き込み処理**:
```cobol
EXEC CICS WRITEQ TD QUEUE(STDQ-NAME)    ... STDQ-NAME = 'CSMT'
          FROM(WRITE-MSG)
          RESP(WS-RESP)
          LENGTH(WS-RECV-LEN)
END-EXEC.
```

#### Step 3: 呼び出し元のエラーメッセージ生成を理解する

業務プログラムからLGSTSQへのエラーメッセージ受け渡しを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 各業務プログラム | `base/src/lg*.cbl` | WRITE-ERROR-MESSAGEセクションまたはWS-ERROR-MSG構造体を確認。日時、プログラム名、顧客番号、ポリシー番号、エラーコードを設定 |

**呼び出しパターン**:
```cobol
EXEC CICS LINK PROGRAM('LGSTSQ')
          COMMAREA(ERROR-MSG)
          LENGTH(LENGTH OF ERROR-MSG)
END-EXEC.
```

### プログラム呼び出し階層図

```
業務プログラム（LGAPOL01, LGIPDB01等）
    │
    ├─ エラー発生検知
    │      └─ WS-RESP/SQLCODE チェック
    │
    ├─ エラーメッセージ生成
    │      ├─ EXEC CICS ASKTIME/FORMATTIME ... 日時取得
    │      └─ ERROR-MSG構造体に値設定
    │
    └─ EXEC CICS LINK PROGRAM('LGSTSQ')
           │
           └─ LGSTSQ
                  ├─ EXEC CICS ASSIGN SYSID ... システムID取得
                  ├─ WRITE-MSG構造体組み立て
                  └─ EXEC CICS WRITEQ TD QUEUE('CSMT') ... TDQ出力
```

### データフロー図

```
[入力]                      [処理]                           [出力]

業務プログラム              LGSTSQ
  │                           │
  │ ERROR-MSG(90バイト) ────▶ │
  │ (日時+プログラム名+       │ ─▶ SYSID取得
  │  顧客番号+ポリシー番号+   │ ─▶ WRITE-MSG組み立て
  │  エラーコード)            │                               TDQ: CSMT
  │                           │ ────────────────────────────▶ CICSシステムログ

出力メッセージ形式:
┌──────────┬─────┬────────────────────────────────────────────────────┐
│ SYSID(4) │ ' ' │ 日時 プログラム名 CNUM=顧客番号 PNUM=ポリシー番号 ...│
└──────────┴─────┴────────────────────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgstsq.cbl | `base/src/lgstsq.cbl` | ソース | TDQ/TSQエラーログ出力プログラム（127行） |
| lgapol01.cbl | `base/src/lgapol01.cbl` | ソース | ポリシー追加（呼び出し元例） |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | DB2照会（呼び出し元例） |
