# 通知設計書 10-リターンコード81

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード81（VSAMファイル読み込みエラー）の設計を定義する。LGDPVS01、LGUPVS01、LGUCVS01プログラムで使用されるリターンコードである。

### 本通知の処理概要

本通知は、GENAPPアプリケーションのVSAMアクセスプログラムがファイル読み込み（READ）または削除前の読み込み処理を実行した際に、エラーが発生した場合に、COMMAREAのCA-RETURN-CODEフィールドに設定されるリターンコードである。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、顧客情報やポリシー情報をVSAMファイルに格納している。VSAMファイルからの読み込み処理が失敗した場合、後続の更新・削除処理を行うことができないため、即座にエラーを検知し、適切な対処を行う必要がある。リターンコード81は「VSAMファイル読み込みエラー」を示し、呼び出し元はトランザクションのロールバックと適切なエラーメッセージの表示を行うことができる。

**通知の送信タイミング**：EXEC CICS READ FILE文またはEXEC CICS DELETE FILE文の実行後、WS-RESPがDFHRESP(NORMAL)以外の場合に設定される。エラーメッセージをTDQ/TSQに出力した後、RETURNまたはABENDで処理を終了する。

**通知の受信者**：業務プログラムを呼び出したプログラムが受信者となる。また、TDQ/TSQにエラー詳細が出力されるため、運用担当者も間接的に受信者となる。

**通知内容の概要**：CA-RETURN-CODE = '81'（2桁数字）に加え、TDQ/TSQにはエラー詳細（日時、プログラム名、顧客番号、ポリシー番号、RESPコード、RESP2コード）が出力される。

**期待されるアクション**：呼び出し元プログラムは、CA-RETURN-CODE = 81を確認したら、トランザクションをロールバックし、エラーメッセージを表示する。運用担当者はTDQ/TSQのログを確認して、エラーの原因を調査する。

## 通知種別

エラーコード（COMMAREA リターンコード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（COMMAREA経由） |
| 優先度 | 高（読み込みエラーは重大） |
| リトライ | なし（単一のリターン値） |

### 送信先決定ロジック

送信先はCOMMAREAを渡した呼び出し元プログラムに固定。エラー詳細はTDQ（CSMT）とTSQ（GENAERRS）に出力される。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| データ型 | PIC 9(2) |
| 値 | 81 |

### 本文テンプレート（TDQ/TSQ出力）

削除時（LGDPVS01）：
```
{DATE} {TIME} LGDPVS01 PNUM={POLICY-NUM} CNUM={CUSTOMER-NUM} Delete file KSDSPOLY RESP={RESP} RESP2={RESP2}
```

更新時（LGUPVS01）：
```
{DATE} {TIME} LGUPVS01 PNUM={POLICY-NUM} CNUM={CUSTOMER-NUM} Re-write  KSDSPOLY  RESP={RESP} RESP2={RESP2}
```

顧客更新時（LGUCVS01）：
```
{DATE} {TIME} LGUCVS01 CNUM={CUSTOMER-NUM} Re-write  KSDSCUST  RESP={RESP} RESP2={RESP2}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | リターンコードとTDQ/TSQログのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | 処理結果コード | DFHCOMMAREA | Yes |
| DATE | エラー発生日付 | EXEC CICS FORMATTIME | Yes |
| TIME | エラー発生時刻 | EXEC CICS FORMATTIME | Yes |
| PROGRAM | プログラム名 | ERROR-MSG固定値 | Yes |
| CUSTOMER-NUM | 顧客番号 | CA-CUSTOMER-NUM | Yes |
| POLICY-NUM | ポリシー番号 | CA-POLICY-NUM | 条件付き |
| RESP | CICSレスポンスコード | WS-RESP | Yes |
| RESP2 | CICS拡張レスポンスコード | EIBRESP2 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| VSAM読み込み | READ FILE失敗 | WS-RESP Not = DFHRESP(NORMAL) | VSAMファイル読み込みエラー |
| VSAM削除 | DELETE FILE失敗 | WS-RESP Not = DFHRESP(NORMAL) | VSAMファイル削除エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常完了時 | WS-RESP = DFHRESP(NORMAL)の場合はリターンコード81は設定されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[VSAM読み込み/削除処理] --> B[EXEC CICS READ/DELETE FILE]
    B --> C{WS-RESP判定}
    C -->|Not NORMAL| D[MOVE '81' TO CA-RETURN-CODE]
    C -->|NORMAL| E[正常処理続行]
    D --> F[PERFORM WRITE-ERROR-MESSAGE]
    F --> G[EXEC CICS LINK LGSTSQ]
    G --> H{ABENDする?}
    H -->|Yes| I[EXEC CICS ABEND]
    H -->|No| J[EXEC CICS RETURN]
    I --> K[異常終了]
    J --> L[呼び出し元に戻る]
    E --> M[後続処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | VSAMファイル操作のためDB2参照なし |

### テーブル別参照項目詳細

VSAMファイル操作のため、DB2テーブルの参照は行わない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | VSAMファイル操作のためDB2更新なし |

#### VSAMファイル

| ファイル名 | 操作 | 概要 |
|-----------|------|------|
| KSDSPOLY | DELETE/READ | ポリシー情報削除/読み込み（LGDPVS01、LGUPVS01） |
| KSDSCUST | READ | 顧客情報読み込み（LGUCVS01） |

#### 送信ログ

TDQ（CSMT）およびTSQ（GENAERRS）にエラー詳細が出力される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| VSAM読み込み失敗 | WS-RESP Not = DFHRESP(NORMAL) | TDQ/TSQにログ出力、RETURNまたはABEND発行 |
| VSAMレコード未検出 | WS-RESP = DFHRESP(NOTFND) | リターンコード81設定、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に設定可能。

## セキュリティ考慮事項

- リターンコード81自体には機密情報は含まれない
- TDQ/TSQに出力されるログには顧客番号・ポリシー番号が含まれるため、アクセス制御が必要

## 備考

- リターンコード81はVSAMファイル読み込み/削除エラー専用
- 使用プログラム：
  - LGDPVS01（ポリシー削除）：Line 88 - MOVE '81' TO CA-RETURN-CODE
  - LGUPVS01（ポリシー更新）：Line 149 - MOVE '81' TO CA-RETURN-CODE
  - LGUCVS01（顧客更新）：Line 79 - MOVE '81' TO CA-RETURN-CODE
- LGUCVS01はABEND ABCODE('LGV1')を発行
- LGUPVS01はABEND ABCODE('LGV3')を発行
- エラー発生時はWRITE-ERROR-MESSAGEを実行してTDQ/TSQにログ出力

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード81の設定箇所を理解する

VSAM READ/DELETE失敗時のリターンコード81設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgdpvs01.cbl | `base/src/lgdpvs01.cbl` | 行88でVSAM DELETE失敗時に'81'を設定 |
| 1-2 | lgupvs01.cbl | `base/src/lgupvs01.cbl` | 行149でVSAM READ失敗時に'81'を設定 |
| 1-3 | lgucvs01.cbl | `base/src/lgucvs01.cbl` | 行79でVSAM READ失敗時に'81'を設定、ABEND 'LGV1'発行 |

**リターンコード81設定**（lgdpvs01.cbl 行88）:
```cobol
IF WS-RESP Not = DFHRESP(NORMAL)  ... DELETE失敗判定
  MOVE '81' TO CA-RETURN-CODE      ... リターンコード81設定
  PERFORM WRITE-ERROR-MESSAGE      ... エラーログ出力
END-IF
```

### プログラム呼び出し階層図

```
画面プログラム（LGTESTP1等）
    │
    └─ LINK LGDPOL01/LGUPOL01/LGUCUS01
           │
           └─ LINK LGDPVS01/LGUPVS01/LGUCVS01
                  │
                  ├─ EXEC CICS READ/DELETE FILE
                  │      │
                  │      └─ WS-RESP Not = DFHRESP(NORMAL)
                  │             ├─ MOVE '81' TO CA-RETURN-CODE
                  │             ├─ WRITE-ERROR-MESSAGE → LGSTSQ
                  │             └─ ABEND 'LGV1'/'LGV3' NODUMP（一部プログラム）
                  │
                  └─ RETURN または 異常終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgdpvs01.cbl | `base/src/lgdpvs01.cbl` | ソース | ポリシー削除（VSAM）- リターンコード81設定（行88） |
| lgupvs01.cbl | `base/src/lgupvs01.cbl` | ソース | ポリシー更新（VSAM）- リターンコード81設定（行149） |
| lgucvs01.cbl | `base/src/lgucvs01.cbl` | ソース | 顧客更新（VSAM）- リターンコード81設定（行79） |
