# 通知設計書 11-リターンコード82

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード82（VSAMファイル更新エラー）通知の設計仕様を定義します。

### 本通知の処理概要

本通知は、CICS環境下でVSAM（Virtual Storage Access Method）KSDSファイルへのREWRITE（更新書き込み）処理が失敗した際に発行されるエラー通知です。

**業務上の目的・背景**：保険システムにおいて、顧客情報（KSDSCUST）または保険証券情報（KSDSPOLY）の更新処理は業務の中核を担います。これらのデータの更新が失敗した場合、業務継続に重大な影響を与えるため、即座にシステム管理者やオペレーターに通知し、迅速な対応を可能にすることが目的です。

**通知の送信タイミング**：CICS REWRITE命令の実行後、RESP値がDFHRESP(NORMAL)以外の値を返した場合に即時送信されます。具体的には、LGUPVS01（ポリシー更新）およびLGUCVS01（顧客更新）プログラムで使用されます。

**通知の受信者**：CICSトランザクションデータキュー（TDQ）のCSMTキュー経由でシステムコンソール、およびテンポラリストレージキュー（TSQ）のGENAERRSキュー経由でエラー監視システムに通知されます。システム運用担当者が主な受信者となります。

**通知内容の概要**：日時、プログラム名（LGUPVS01またはLGUCVS01）、顧客番号、ポリシー番号（該当する場合）、CICS RESPコード、RESP2コードが含まれます。

**期待されるアクション**：システム管理者は通知を受け取り次第、VSAMファイルの状態確認、ディスク容量の確認、ファイルの排他制御状態の確認を行い、必要に応じてファイルの回復処理や再実行を実施します。

## 通知種別

システムログ出力（CICSキュー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（LGSTSQプログラム経由） |
| 優先度 | 高（ABEND発生のため） |
| リトライ | なし（ABENDにより処理終了） |

### 送信先決定ロジック

送信先は固定です。LGSTSQプログラムが以下の2つのキューに同時出力します：
1. TDQ: CSMT（CICSシステムメッセージキュー）
2. TSQ: GENAERRS（GENAPPエラーキュー）

## 通知テンプレート

### システムログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先TDQ | CSMT |
| 出力先TSQ | GENAERRS（Q=nnnnパラメータでGENAnnnnに変更可能） |
| 形式 | テキスト |

### 本文テンプレート

```
{SYSID} {日付} {時刻} {プログラム名} CNUM={顧客番号} PNUM={ポリシー番号} Re-write {ファイル名} RESP={RESPコード} RESP2={RESP2コード}
```

例（LGUPVS01の場合）：
```
XXXX 01/06/2026 10:30:00 LGUPVS01 PNUM=0000012345 CNUM=0000067890 Re-write  KSDSPOLY  RESP=+00016 RESP2=+00000
```

例（LGUCVS01の場合）：
```
XXXX 01/06/2026 10:30:00 LGUCVS01 CNUM=0000067890 Re-write  KSDSCUST  RESP=+00016 RESP2=+00000
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| SYSID | CICSシステムID | EXEC CICS ASSIGN | Yes |
| 日付 | エラー発生日 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| 時刻 | エラー発生時刻 | EXEC CICS FORMATTIME TIME | Yes |
| プログラム名 | 発行元プログラム | 固定値（LGUPVS01/LGUCVS01） | Yes |
| 顧客番号 | 処理対象顧客番号 | CA-Customer-Num | Yes |
| ポリシー番号 | 処理対象ポリシー番号 | CA-Policy-Num（LGUPVS01のみ） | No |
| RESPコード | CICSレスポンスコード | WS-RESP | Yes |
| RESP2コード | CICS詳細レスポンスコード | WS-RESP2（EIBRESP2） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| CICS REWRITE実行 | KSDSPOLY更新失敗（LGUPVS01） | WS-RESP Not = DFHRESP(NORMAL) | ポリシーファイルへのREWRITE失敗 |
| CICS REWRITE実行 | KSDSCUST更新失敗（LGUCVS01） | WS-RESP Not = DFHRESP(NORMAL) | 顧客ファイルへのREWRITE失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | エラー発生時は必ず通知を送信 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CICS REWRITE実行] --> B{RESP = NORMAL?}
    B -->|Yes| C[正常終了]
    B -->|No| D[WS-RESP2 = EIBRESP2]
    D --> E[CA-RETURN-CODE = '82']
    E --> F[WRITE-ERROR-MESSAGE実行]
    F --> G[日時取得 ASKTIME/FORMATTIME]
    G --> H[エラーメッセージ構築]
    H --> I[LGSTSQ呼び出し TDQ/TSQ出力]
    I --> J[COMMAREA内容も出力]
    J --> K[ABEND発行 LGV2/LGV4]
    K --> L[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | VSAMファイルのみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| KSDSPOLY（VSAM） | REWRITE | ポリシー情報更新（LGUPVS01） |
| KSDSCUST（VSAM） | REWRITE | 顧客情報更新（LGUCVS01） |

### キュー出力

| キュー名 | 種別 | 操作 | 概要 |
|---------|------|------|------|
| CSMT | TDQ | WRITEQ TD | システムメッセージ出力 |
| GENAERRS | TSQ | WRITEQ TS | エラーログ出力 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| VSAMファイル更新失敗 | REWRITE実行時のRESP異常 | エラーメッセージ出力後ABEND |
| キュー出力失敗 | LGSTSQ内でのTDQ/TSQ出力失敗 | NOSUSPENDオプションにより無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（ABENDにより処理終了） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（エラー発生時は24時間即時出力）

## セキュリティ考慮事項

- 顧客番号、ポリシー番号がログに出力されるため、ログファイルへのアクセス権限を適切に設定する必要があります
- CSMTキューはCICS管理者権限でのみアクセス可能に設定することを推奨
- GENAERRSキューの内容は定期的にアーカイブし、一定期間後に削除することを推奨

## 備考

- 本リターンコードは、LGUPVS01（保険証券更新）とLGUCVS01（顧客更新）プログラムでのみ使用されます
- ABENDコードは、LGUCVS01では「LGV2」、LGUPVS01では「LGV4」が使用されます
- NODUMPオプションが指定されているため、ダンプは出力されません
- リターンコード81（読み込みエラー）の後に更新処理を行うため、82が発生した場合は読み込みは成功したが書き込みで失敗したことを意味します

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード82の設定箇所を理解する

VSAM REWRITE失敗時のリターンコード82設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgupvs01.cbl | `base/src/lgupvs01.cbl` | VSAM REWRITE失敗時に'82'を設定、ABEND 'LGV4'発行 |
| 1-2 | lgucvs01.cbl | `base/src/lgucvs01.cbl` | VSAM REWRITE失敗時に'82'を設定、ABEND 'LGV2'発行 |

**想定されるリターンコード82設定パターン**:
```cobol
EXEC CICS REWRITE FILE(ファイル名)
          FROM(データ領域)
          RESP(WS-RESP)
END-EXEC
IF WS-RESP Not = DFHRESP(NORMAL)  ... REWRITE失敗判定
  MOVE EIBRESP2 TO WS-RESP2
  MOVE '82' TO CA-RETURN-CODE      ... リターンコード82設定
  PERFORM WRITE-ERROR-MESSAGE      ... エラーログ出力
  EXEC CICS ABEND ABCODE('LGV2'/'LGV4') NODUMP END-EXEC
END-IF
```

### プログラム呼び出し階層図

```
画面プログラム（LGTESTP1等）
    │
    └─ LINK LGUPOL01/LGUCUS01
           │
           └─ LINK LGUPVS01/LGUCVS01
                  │
                  ├─ EXEC CICS READ FILE ... 読み込み成功（81なし）
                  │
                  ├─ EXEC CICS REWRITE FILE
                  │      │
                  │      └─ WS-RESP Not = DFHRESP(NORMAL)
                  │             ├─ MOVE '82' TO CA-RETURN-CODE
                  │             ├─ WRITE-ERROR-MESSAGE → LGSTSQ
                  │             └─ ABEND 'LGV2'/'LGV4' NODUMP
                  │
                  └─ （異常終了）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgupvs01.cbl | `base/src/lgupvs01.cbl` | ソース | ポリシー更新（VSAM）- リターンコード82設定、ABEND 'LGV4' |
| lgucvs01.cbl | `base/src/lgucvs01.cbl` | ソース | 顧客更新（VSAM）- リターンコード82設定、ABEND 'LGV2' |
