# 通知設計書 12-リターンコード88

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード88（DBカーソルクローズエラー）通知の設計仕様を定義します。

### 本通知の処理概要

本通知は、DB2データベースのカーソルクローズ操作が失敗した際に発行されるエラー通知です。LGIPDB01プログラムにおける商業用不動産保険（Commercial Policy）の一括照会処理で使用されます。

**業務上の目的・背景**：保険システムにおいて、複数のポリシー情報を一括で取得する際にDB2カーソルを使用します。カーソルのクローズに失敗した場合、データベースリソースが正しく解放されず、システムリソースの枯渇やデッドロックの原因となる可能性があります。このエラーを通知することで、システム管理者が早期に問題を検知し、適切な対応を取ることができます。

**通知の送信タイミング**：EXEC SQL CLOSE CURSOR実行後、SQLCODEが0以外の値を返した場合に即時送信されます。具体的には、LGIPDB01プログラムのGET-Commercial-DB2-INFO-3およびGET-Commercial-DB2-INFO-5処理で発生します。

**通知の受信者**：CICSトランザクションデータキュー（TDQ）のCSMTキュー経由でシステムコンソール、およびテンポラリストレージキュー（TSQ）のGENAERRSキュー経由でエラー監視システムに通知されます。データベース管理者およびシステム運用担当者が主な受信者となります。

**通知内容の概要**：日時、プログラム名（LGIPDB01）、顧客番号、ポリシー番号、SQL操作種別、SQLCODEが含まれます。

**期待されるアクション**：データベース管理者は通知を受け取り次第、DB2の状態確認、カーソル状態の確認、必要に応じてDB2接続のリセットやトランザクションの再実行を実施します。

## 通知種別

システムログ出力（CICSキュー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（LGSTSQプログラム経由） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

送信先は固定です。LGSTSQプログラムが以下の2つのキューに同時出力します：
1. TDQ: CSMT（CICSシステムメッセージキュー）
2. TSQ: GENAERRS（GENAPPエラーキュー）

## 通知テンプレート

### システムログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先TDQ | CSMT |
| 出力先TSQ | GENAERRS |
| 形式 | テキスト |

### 本文テンプレート

```
{SYSID} {日付} {時刻} LGIPDB01 CNUM={顧客番号} PNUM={ポリシー番号} {SQL操作種別} SQLCODE={SQLコード}
```

例：
```
XXXX 01/06/2026 10:30:00 LGIPDB01 CNUM=0000067890 PNUM=0000012345  SELECT Commercial  SQLCODE=-501
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| SYSID | CICSシステムID | EXEC CICS ASSIGN | Yes |
| 日付 | エラー発生日 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| 時刻 | エラー発生時刻 | EXEC CICS FORMATTIME TIME | Yes |
| 顧客番号 | 処理対象顧客番号 | CA-CUSTOMER-NUM | Yes |
| ポリシー番号 | 処理対象ポリシー番号 | CA-POLICY-NUM | Yes |
| SQL操作種別 | 実行中のSQL操作 | EM-SQLREQ（' SELECT Commercial '） | Yes |
| SQLコード | DB2 SQLCODE | SQLCODE | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| SQL CLOSE CURSOR実行 | Cust_Cursorクローズ失敗 | SQLCODE NOT EQUAL 0 | GET-Commercial-DB2-INFO-3でのカーソルクローズ失敗 |
| SQL CLOSE CURSOR実行 | Zip_Cursorクローズ失敗 | SQLCODE NOT EQUAL 0 | GET-Commercial-DB2-INFO-5でのカーソルクローズ失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | エラー発生時は必ず通知を送信 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[EXEC SQL CLOSE CURSOR実行] --> B{SQLCODE = 0?}
    B -->|Yes| C[正常終了]
    B -->|No| D[CA-RETURN-CODE = '88']
    D --> E[WRITE-ERROR-MESSAGE実行]
    E --> F[日時取得 ASKTIME/FORMATTIME]
    F --> G[SQLCODEをエラーメッセージに設定]
    G --> H[LGSTSQ呼び出し TDQ/TSQ出力]
    H --> I[COMMAREA内容も出力]
    I --> J[END-PROGRAM実行]
    J --> K[CICS RETURN]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| POLICY | ポリシー基本情報取得 | COMMERCIAL表との結合 |
| COMMERCIAL | 商業用不動産保険情報取得 | カーソル操作対象 |

### テーブル別参照項目詳細

#### POLICY表

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| CUSTOMERNUMBER | 顧客番号特定 | カーソル条件 |
| POLICYNUMBER | ポリシー番号特定 | カーソル条件 |

#### COMMERCIAL表

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| 各種保険情報 | ポリシー詳細取得 | Cust_CursorまたはZip_Cursor |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 参照のみ |

### キュー出力

| キュー名 | 種別 | 操作 | 概要 |
|---------|------|------|------|
| CSMT | TDQ | WRITEQ TD | システムメッセージ出力 |
| GENAERRS | TSQ | WRITEQ TS | エラーログ出力 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| カーソルクローズ失敗 | CLOSE CURSOR実行時のSQLCODE異常 | エラーメッセージ出力後、処理終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（エラー発生時は24時間即時出力）

## セキュリティ考慮事項

- 顧客番号、ポリシー番号がログに出力されるため、ログファイルへのアクセス権限を適切に設定する必要があります
- SQLCODEの情報はデータベースの内部状態を示すため、外部公開されないよう注意が必要です

## 備考

- 本リターンコードは、LGIPDB01プログラムでのみ使用されます
- GET-Commercial-DB2-INFO-3では顧客番号によるカーソル検索（Cust_Cursor）を使用
- GET-Commercial-DB2-INFO-5では郵便番号によるカーソル検索（Zip_Cursor）を使用
- カーソルクローズエラーは、通常はデータベース接続の問題やリソース不足を示します
- ABENDは発行されず、EXEC CICS RETURNで呼び出し元に制御を返します

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード88の設定箇所を理解する

DB2カーソルクローズ失敗時のリターンコード88設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行855-859でCust_Cursorクローズ失敗時に'88'を設定 |
| 1-2 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行938-942でZip_Cursorクローズ失敗時に'88'を設定 |

**リターンコード88設定**（lgipdb01.cbl 行855-859）:
```cobol
EXEC SQL
  Close Cust_Cursor
END-EXEC.
IF SQLCODE NOT EQUAL 0
  MOVE '88' TO CA-RETURN-CODE       ... リターンコード88設定
  PERFORM WRITE-ERROR-MESSAGE       ... エラーログ出力
  PERFORM END-PROGRAM               ... 処理終了
END-IF.
```

### プログラム呼び出し階層図

```
画面プログラム / Webサービス
    │
    └─ LINK LGIPOL01
           │
           └─ LINK LGIPDB01
                  │
                  ├─ GET-Commercial-DB2-INFO-3 / GET-Commercial-DB2-INFO-5
                  │      │
                  │      ├─ OPEN CURSOR
                  │      ├─ FETCH（複数回）
                  │      └─ CLOSE CURSOR
                  │             │
                  │             └─ SQLCODE NOT = 0
                  │                    ├─ MOVE '88' TO CA-RETURN-CODE
                  │                    ├─ WRITE-ERROR-MESSAGE → LGSTSQ
                  │                    └─ END-PROGRAM → RETURN
                  │
                  └─ 呼び出し元に戻る
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | ポリシー照会（DB2）- リターンコード88設定（行855-859, 938-942） |
