# 通知設計書 14-リターンコード90

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード90（データベースエラー - 一般SQLエラー）通知の設計仕様を定義します。

### 本通知の処理概要

本通知は、DB2データベース操作（SELECT、INSERT、UPDATE、DELETE）で予期しないエラーが発生した際に発行される汎用エラー通知です。SQLCODE 0（正常）および100（データなし）以外のSQLCODEが返された場合に使用されます。

**業務上の目的・背景**：保険システムにおいて、データベース操作は全ての業務処理の基盤です。SELECT、INSERT、UPDATE、DELETE等のSQL操作が失敗した場合、データの整合性や業務の継続性に重大な影響を与えます。このエラーを即座に通知することで、システム管理者およびデータベース管理者が早期に問題を検知し、適切な対応を取ることができます。

**通知の送信タイミング**：各種SQL操作実行後、SQLCODEが0（正常）および100（データなし）以外の値を返した場合に即時送信されます。多数のDB2プログラム（LGUCDB01、LGUPDB01、LGIPDB01、LGACDB01、LGICDB01、LGAPDB01、LGDPDB01など）で使用されます。

**通知の受信者**：CICSトランザクションデータキュー（TDQ）のCSMTキュー経由でシステムコンソール、およびテンポラリストレージキュー（TSQ）のGENAERRSキュー経由でエラー監視システムに通知されます。データベース管理者およびシステム運用担当者が主な受信者となります。

**通知内容の概要**：日時、プログラム名、顧客番号、ポリシー番号、SQL操作種別、SQLCODEが含まれます。

**期待されるアクション**：データベース管理者は通知を受け取り次第、SQLCODEの意味を確認し、DB2の状態確認、テーブル/インデックスの状態確認、ロック競合の有無確認、必要に応じてトランザクションの再実行やDB2の回復処理を実施します。

## 通知種別

システムログ出力（CICSキュー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（LGSTSQプログラム経由） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

送信先は固定です。LGSTSQプログラムが以下の2つのキューに同時出力します：
1. TDQ: CSMT（CICSシステムメッセージキュー）
2. TSQ: GENAERRS（GENAPPエラーキュー）

## 通知テンプレート

### システムログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先TDQ | CSMT |
| 出力先TSQ | GENAERRS |
| 形式 | テキスト |

### 本文テンプレート

```
{SYSID} {日付} {時刻} {プログラム名} CNUM={顧客番号} PNUM={ポリシー番号} {SQL操作種別} SQLCODE={SQLコード}
```

例：
```
XXXX 01/06/2026 10:30:00 LGIPDB01 CNUM=0000067890 PNUM=0000012345  SELECT ENDOW  SQLCODE=-911
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| SYSID | CICSシステムID | EXEC CICS ASSIGN | Yes |
| 日付 | エラー発生日 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| 時刻 | エラー発生時刻 | EXEC CICS FORMATTIME TIME | Yes |
| プログラム名 | 発行元プログラム | ERROR-MSG固定値 | Yes |
| 顧客番号 | 処理対象顧客番号 | CA-CUSTOMER-NUM | Yes |
| ポリシー番号 | 処理対象ポリシー番号 | CA-POLICY-NUM | Yes |
| SQL操作種別 | 実行中のSQL操作 | EM-SQLREQ | Yes |
| SQLコード | DB2 SQLCODE | SQLCODE | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| SQL SELECT実行 | 照会処理失敗 | SQLCODE Not = 0 and Not = 100 | 養老保険、住宅保険、自動車保険、商業用不動産保険の照会 |
| SQL INSERT実行 | 追加処理失敗 | SQLCODE Not = 0 | 顧客、ポリシー情報の登録 |
| SQL UPDATE実行 | 更新処理失敗 | SQLCODE Not = 0 | 顧客、ポリシー情報の更新 |
| SQL DELETE実行 | 削除処理失敗 | SQLCODE Not = 0 | ポリシー情報の削除 |

### 使用プログラム一覧

| プログラム名 | 説明 | SQL操作種別 |
|------------|------|-----------|
| LGIPDB01 | ポリシー照会 | SELECT ENDOW/HOUSE/MOTOR/Commercial |
| LGICDB01 | 顧客照会 | SELECT CUSTOMER |
| LGACDB01 | 顧客追加 | INSERT CUSTOMER |
| LGAPDB01 | ポリシー追加 | INSERT POLICY/ENDOW/HOUSE/MOTOR/COMMERCIAL |
| LGUCDB01 | 顧客更新 | UPDATE CUSTOMER |
| LGUPDB01 | ポリシー更新 | UPDATE POLICY/ENDOW/HOUSE/MOTOR/COMMERCIAL |
| LGDPDB01 | ポリシー削除 | DELETE |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SQLCODE = 0 | 正常完了 |
| SQLCODE = 100 | データなし（リターンコード01として処理） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SQL操作実行] --> B{SQLCODE = 0?}
    B -->|Yes| C[正常終了]
    B -->|No| D{SQLCODE = 100?}
    D -->|Yes| E[データなし リターンコード01]
    D -->|No| F[CA-RETURN-CODE = '90']
    F --> G[WRITE-ERROR-MESSAGE実行]
    G --> H[日時取得 ASKTIME/FORMATTIME]
    H --> I[SQLCODEをエラーメッセージに設定]
    I --> J[LGSTSQ呼び出し TDQ/TSQ出力]
    J --> K[COMMAREA内容も出力]
    K --> L[処理終了/呼び出し元へ戻る]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| POLICY | ポリシー基本情報 | 各種保険の共通情報 |
| CUSTOMER | 顧客情報 | 顧客マスタ |
| ENDOWMENT | 養老保険情報 | ポリシー詳細 |
| HOUSE | 住宅保険情報 | ポリシー詳細 |
| MOTOR | 自動車保険情報 | ポリシー詳細 |
| COMMERCIAL | 商業用不動産保険情報 | ポリシー詳細 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 上記全テーブル | INSERT/UPDATE/DELETE | 各業務処理に応じて更新 |

### キュー出力

| キュー名 | 種別 | 操作 | 概要 |
|---------|------|------|------|
| CSMT | TDQ | WRITEQ TD | システムメッセージ出力 |
| GENAERRS | TSQ | WRITEQ TS | エラーログ出力 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 一般SQLエラー | SQLCODE Not = 0 and Not = 100 | エラーメッセージ出力、呼び出し元に制御を返す |

### 代表的なSQLCODE

| SQLCODE | 意味 | 対処方法 |
|---------|-----|---------|
| -803 | 重複キー（INSERT時） | 既存データの確認 |
| -811 | 複数行が返された | WHERE句の条件確認 |
| -904 | リソース不足 | DB2システムリソース確認 |
| -911 | デッドロック/タイムアウト | トランザクション再実行 |
| -913 | デッドロック（ロールバック済み） | トランザクション再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（呼び出し元で判断） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（エラー発生時は24時間即時出力）

## セキュリティ考慮事項

- 顧客番号、ポリシー番号がログに出力されるため、ログファイルへのアクセス権限を適切に設定する必要があります
- SQLCODEの情報はデータベースの内部状態を示すため、外部公開されないよう注意が必要です
- エラーメッセージにCOMMAREAの内容が含まれる場合があり、個人情報が含まれる可能性があるため注意が必要です

## 備考

- 本リターンコードは、GENAPPの全てのDB2アクセスプログラムで使用される汎用エラーコードです
- SQL操作種別（EM-SQLREQ）は各プログラムで異なる値が設定されます
  - LGIPDB01: ' SELECT ENDOW '、' SELECT HOUSE '、' SELECT MOTOR '、' SELECT Commercial '
  - LGICDB01: ' SELECT CUSTOMER'
  - LGACDB01: ' INSERT CUSTOMER'
  - LGAPDB01: ' INSERT POLICY'、' INSERT ENDOW'等
  - LGUCDB01: ' UPDATE CUSTOMER'
  - LGUPDB01: ' UPDATE POLICY'、' UPDATE ENDOW'等
  - LGDPDB01: ' DELETE '
- ABENDは発行されず、リターンコード90をセットして呼び出し元に制御を返します
- 呼び出し元プログラムでリターンコードを確認し、適切なエラー処理を行う必要があります

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード90の設定箇所を理解する

各種DB2プログラムでのSQLエラー発生時のリターンコード90設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行426でSELECTエラー時に'90'を設定（養老保険照会） |
| 1-2 | lgicdb01.cbl | `base/src/lgicdb01.cbl` | 行200でSELECT CUSTOMERエラー時に'90'を設定 |
| 1-3 | lgacdb01.cbl | `base/src/lgacdb01.cbl` | 行246, 275でINSERT CUSTOMERエラー時に'90'を設定 |
| 1-4 | lgapdb01.cbl | `base/src/lgapdb01.cbl` | 行301, 390, 428, 474, 548でINSERTエラー時に'90'を設定 |
| 1-5 | lgucdb01.cbl | `base/src/lgucdb01.cbl` | 行176でUPDATE CUSTOMERエラー時に'90'を設定 |
| 1-6 | lgupdb01.cbl | `base/src/lgupdb01.cbl` | 行263, 267, 339, 354, 377, 413, 449, 490でUPDATEエラー時に'90'を設定 |
| 1-7 | lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | 行199でDELETEエラー時に'90'を設定 |

**リターンコード90設定**（lgipdb01.cbl 行426）:
```cobol
IF SQLCODE NOT EQUAL 0
  IF SQLCODE NOT EQUAL 100       ... データなしは除外
    MOVE '90' TO CA-RETURN-CODE  ... リターンコード90設定
    PERFORM WRITE-ERROR-MESSAGE  ... エラーログ出力
  END-IF
END-IF
```

### プログラム呼び出し階層図

```
画面プログラム / Webサービス
    │
    └─ LINK LGxxOL01/LGxxUS01（業務プログラム）
           │
           └─ LINK LGxxDB01（DB2アクセスプログラム）
                  │
                  ├─ EXEC SQL SELECT/INSERT/UPDATE/DELETE
                  │      │
                  │      └─ SQLCODE Not = 0 and Not = 100
                  │             ├─ MOVE '90' TO CA-RETURN-CODE
                  │             ├─ WRITE-ERROR-MESSAGE → LGSTSQ
                  │             └─ RETURN
                  │
                  └─ 呼び出し元に戻る（CA-RETURN-CODE='90'）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | ポリシー照会（DB2）- リターンコード90設定（行426, 517, 615, 717, 822） |
| lgicdb01.cbl | `base/src/lgicdb01.cbl` | ソース | 顧客照会（DB2）- リターンコード90設定（行200） |
| lgacdb01.cbl | `base/src/lgacdb01.cbl` | ソース | 顧客追加（DB2）- リターンコード90設定（行246, 275） |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | ソース | ポリシー追加（DB2）- リターンコード90設定（行301, 390, 428, 474, 548） |
| lgucdb01.cbl | `base/src/lgucdb01.cbl` | ソース | 顧客更新（DB2）- リターンコード90設定（行176） |
| lgupdb01.cbl | `base/src/lgupdb01.cbl` | ソース | ポリシー更新（DB2）- リターンコード90設定（行263, 267, 339, 354, 377, 413, 449, 490） |
| lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | ソース | ポリシー削除（DB2）- リターンコード90設定（行199） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | ソース | エラーログ出力（TDQ/TSQ） |
